<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.ebsApp"></cv:cvMessages>
</script>
<div class="panel">
	<div class="panel-body">
		<div class="form-group">
			<label class="col-xs-12 col-lg-6">
				<cv:msg key="label.ebsAppName" bundle="ebsApp" />
			</label >
			<label class="col-xs-12 col-lg-6">
				{{ebsClone.data.srcEBSAppName}}
			</label>
		</div>
		<div class="form-group">
			<label class="col-xs-12 col-lg-6">
				<cv:msg key="label.appType" bundle="dbs"/>
			</label >
			<label class="col-xs-12 col-lg-6">
				<cv:msg key="label.oracleEBS" bundle="ebsApp" />
			</label>
		</div>
		<div class="form-group">
			<label class="col-xs-12 col-lg-6">
				<cv:msg key="label.destEBSAppName" bundle="ebsApp" />
			</label >
			<div class="col-xs-12 col-lg-6">
				<input type="text" id="destEBSAppName" name="destEBSAppName" 
					data-ng-required="true" data-ng-model="ebsClone.data.destEBSAppName" >
				<span class="help-block" data-ng-show="cv.wizardForm.needsAttention(wizardForm.destEBSAppName)">
					<cv:msg key="error.destEBSAppName" bundle="ebsApp"/>
				</span>
			</div>
		</div>
		<div class="form-group">
			<label class="col-xs-12 col-lg-6">
				<cv:msg key="header.Version" bundle="clients" />
			</label >
			<label class="col-xs-12 col-lg-6">
				{{ebsClone.data.version}}
			</label>
		</div>
		<div class="form-group">
			<label class="col-xs-12 col-lg-6" for="preRegistore">
				<cv:msg key="label.userPreRegister" bundle="oracle"/>
			</label>
			<div class="col-xs-12 col-lg-6">
				<input type="checkbox" id="preRegistore" name="preRegistore" data-ng-change="ebsClone.registoredServerChanged(ebsClone.data.preRegistore)"
				data-ng-model="ebsClone.data.preRegistore" style="visibility: visible;left: 14px;"/>					
			</div>
		</div>
		<div class="form-group" data-ng-if="!ebsClone.data.preRegistore">
			<label class="col-xs-12 col-lg-6" for="cloudType">
				<cv:msg key="label.cloudType" bundle="oracle"/>
			</label >
			<div class="col-xs-12 col-lg-6">
				<select name="cloudType" id="cloudType" 
					data-ng-options="cloud.cloudId as cloud.name for cloud in ebsClone.cloudTypes" 
					data-ng-change="ebsClone.cloudTypechange(ebsClone.data.cloudType)"
					data-ng-model="ebsClone.data.cloudType" 
					data-ng-required="true" >
					<option value=""><cv:msg key="options.cloudType" bundle="oracle"/></option>
				</select>
				<span class="help-block" data-ng-show="cv.wizardForm.needsAttention(wizardForm.cloudType)">
					<cv:msg key="error.cloudType" bundle="oracle"/>
				</span>
			</div>
		</div>
		<div class="form-group" data-ng-if="!ebsClone.data.preRegistore">
			<label class="col-xs-12 col-lg-6" for="AllocPolicyId">
				<cv:msg key="label.policyName" bundle="oracle"/>
			</label >
			<div class="col-xs-12 col-lg-6">
				<select name="AllocPolicyId" id="AllocPolicyId" 
					data-ng-options="policy as policy.entity.vmAllocPolicyName for policy in ebsClone.policyList | orderBy:'policy.entity.vmAllocPolicyName'" 
					data-ng-model="ebsClone.data.policyId"  data-ng-required="true" >
					<option value=""><cv:msg key="options.policyName" bundle="oracle"/></option>
				</select>
				<span class="help-block" data-ng-show="cv.wizardForm.needsAttention(wizardForm.AllocPolicyId)">
					 <cv:msg key="error.policyName" bundle="oracle"/>
				</span>
			</div>
		</div>
	</div>
</div>	
	
