<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.dbs"></cv:cvMessages>
</script>
<div  data-ng-controller="createEBSNodeCtrl as ebsNode">
<div data-ng-hide="isSetup" class="setup-title">
	<h1><cv:msg key="label.addEBSApp" bundle="ebsApp" /></h1>
</div>
<div class="{{ebsNode.addEBSMessage.type}} text-center" data-ng-bind="ebsNode.addEBSMessage.message"></div>
<form name="addEBSApp" novalidate autocomplete="off" data-cv-submit="ebsNode.saveEBSNode()" class="bootstrap-wrapper form-horizontal">
	<uib-accordion close-others="true" class="text-left">
	    <div uib-accordion-group is-open="ebsNode.tileState.generalInfo">
		   	 <uib-accordion-heading >
			        <cv:msg key="label.general" bundle="storage" />
		        	<i class="pull-right glyphicon" data-ng-class="{'glyphicon-chevron-down': ebsNode.tileState.generalInfo, 'glyphicon-chevron-right': !ebsNode.tileState.generalInfo}"></i>
		      </uib-accordion-heading>
			<!-- EBS App Name -->
			<div class="form-group">
				<label class="col-xs-12 col-lg-4" for="ebsAppName">
					<cv:msg key="label.ebsAppName" bundle="ebsApp" />
				</label>
				<div class="col-xs-12 col-lg-8">
					<input  name="ebsAppName" id="ebsAppName" type="text" data-ng-required="true"
						data-ng-model="ebsNode.data.ebsAppName" />
					<span class="help-block" data-ng-show="cv.addEBSApp.needsAttention(addEBSApp.ebsAppName)">
						 <cv:msg key="error.ebsAppName" bundle="ebsApp" />
					</span>
				</div>
			</div>
			<!-- DB client (cloneTabProxy) -->
			<div class="form-group">
				<label class="col-xs-12 col-lg-4" for="cloneTabProxy" >
					<cv:msg key="label.cloneTabProxy" bundle="ebsApp"/>
				</label>
				<div class="col-xs-12 col-lg-8">
					<isteven-multi-select id="createEBSNodeDBConfigPage_button_#5726" 
								input-model="ebsNode.clientList"
								button-label="clientName"
								item-label="clientName"
								tick-property="selected"
								class="isteven-multi-select user-group-select "
								helper-elements="filter"
								selection-mode="single"
								on-close="ebsNode.parseIStevenOutput()"
								on-item-click="ebsNode.selectedOneClient(data)"
								translation="ebsNode.localLang"  />
					<span class="help-block" data-ng-show="ebsNode.error.cloneTabProxy">
						 <cv:msg key="error.cloneTabProxy" bundle="ebsApp" />
					</span>
				</div>
			</div>
			<div class="form-group">
				<label class="col-xs-12 col-lg-4" for="dbInstance" >
					<cv:msg key="label.dbInstance" bundle="ebsApp"/>
				</label>
				<div class="col-xs-12 col-lg-8">
					<select name="dbInstance" id="dbInstance" data-ng-options="instance as instance.instanceName for instance in ebsNode.dbInstances | orderBy:'instanceName'" required
						data-ng-model="ebsNode.data.dbInstanceNode" >
						<option value=""><cv:msg key="option.dbInstance" bundle="ebsApp" /></option>
					</select>
					<span class="help-block" data-ng-show="cv.addEBSApp.needsAttention(addEBSApp.dbInstance)">
						 <cv:msg key="error.dbInstance" bundle="ebsApp" />
					</span>
				</div>
			</div>
			<div class="form-group">
				<label class="col-xs-12 col-lg-4" for="systemPwd">
					<cv:msg key="label.systemPass" bundle="ebsApp" />
				</label>
				<div class="col-xs-12 col-lg-8">
					<input type="password" data-ng-model="ebsNode.data.dbTier.systemPwdString" data-ng-required="true"
						id="systemPwd" name="systemPwd" />
					<span class="help-block" data-ng-show="cv.addEBSApp.needsAttention(addEBSApp.systemPwd)">
						 <cv:msg key="error.systemPass" bundle="ebsApp" />
					</span>
				</div>
			</div>
			<div class="form-group">
				<label class="col-xs-12 col-lg-4" for="sysPwd">
					<cv:msg key="label.sysPass" bundle="ebsApp"/>
				</label>
				<div class="col-xs-12 col-lg-8">
					<input type="password" data-ng-model="ebsNode.data.dbTier.sysPwdString" data-ng-required="true"
						id="sysPwd" name="sysPwd" />
					<span class="help-block" data-ng-show="cv.addEBSApp.needsAttention(addEBSApp.sysPwd)">
						 <cv:msg key="error.sysPass" bundle="ebsApp" />
					</span>
				</div>
			</div>
			<div class="form-group">
				<label class="col-xs-12 col-lg-4" for="userName">
					<cv:msg key="label.appsUsername" bundle="ebsApp" />
				</label>
				<div class="col-xs-12 col-lg-8">
					<input type="text" data-ng-model="ebsNode.data.appTier.appsUser.userName" required
						id="userName" name="userName" />
					<span class="help-block" data-ng-show="cv.addEBSApp.needsAttention(addEBSApp.userName)">
						 <cv:msg key="error.appsUsername" bundle="ebsApp" />
					</span>
				</div>
			</div>
			<div class="form-group">
				<label class="col-xs-12 col-lg-4" for="userNamePassword">
					<cv:msg key="label.appsPassword" bundle="ebsApp"/>
				</label>
				<div class="col-xs-12 col-lg-8">
					<input type="password" data-ng-model="ebsNode.data.appTier.appsUser.userNamePassword" required
						id="userNamePassword" name="userNamePassword" />
					<span class="help-block" data-ng-show="cv.addEBSApp.needsAttention(addEBSApp.userNamePassword)">
						 <cv:msg key="error.appsPassword" bundle="ebsApp" />
					</span>
				</div>
			</div>
			<div class="form-group">
				<label class="col-xs-12 col-lg-4" for="webLogicUser">
					<cv:msg key="label.WeblogicUsername" bundle="ebsApp" />
				</label>
				<div class="col-xs-12 col-lg-8">
					<input type="text" data-ng-model="ebsNode.data.appTier.weblogicUser.userName" required
						id="webLogicUser" name="webLogicUser" />
					<span class="help-block" data-ng-show="cv.addEBSApp.needsAttention(addEBSApp.webLogicUser)">
						 <cv:msg key="error.WeblogicUsername" bundle="ebsApp" />
					</span>
				</div>
			</div>
			<div class="form-group">
				<label class="col-xs-12 col-lg-4" for="webLogicPassword">
					<cv:msg key="label.WeblogicPassword" bundle="ebsApp" />
				</label>
				<div class="col-xs-12 col-lg-8">
					<input type="password" data-ng-model="ebsNode.data.appTier.weblogicUser.passwordValue" required
						data-ng-change="ebsNode.updatePassword(ebsNode.data.appTier.weblogicUser,ebsNode.data.appTier.weblogicUser.passwordValue)" id="webLogicPassword" name="webLogicPassword" />
					<span class="help-block" data-ng-show="cv.addEBSApp.needsAttention(addEBSApp.webLogicPassword)">
						 <cv:msg key="error.WeblogicPassword" bundle="ebsApp" />
					</span>
				</div>
			</div>
		</div>
		<div uib-accordion-group is-open="ebsNode.tileState.clientMapping" title="">
			<uib-accordion-heading>
				<cv:msg key="label.clientMapping" bundle="ebsApp"/>
		       <i class="pull-right glyphicon" data-ng-class="{'glyphicon-chevron-down': ebsNode.tileState.clientMapping, 'glyphicon-chevron-right': !ebsNode.tileState.clientMapping}"></i>
		    </uib-accordion-heading>
		    <div class="panel-body text-center" data-ng-show="ebsNode.showDefaultMessage"><cv:msg key="label.discoverNodesMessage" bundle="ebsApp" /></div>
			<div data-ng-show="ebsNode.showClientMapping" class="col-xs-12 col-lg-12" >
				<cv-grid cv-grid-options="ebsNode.clientMapGridOptions"></cv-grid>
			</div>
		</div>
	</uib-accordion>
	<div class="button-container">
  		<button type="button" data-ng-if="!isSetup" class="btn" data-ng-click="cancelModel()">
  			<cv:msg key="Cancel" bundle="messages" />
		</button>
		<button id="createEBSNodeDBConfigPage_button_#0902" type="button" data-ng-if="isSetup" class="btn btn-default cvBusyOnAjax" data-ng-click="skipStep()"> 
				<cv:msg key="action.doItLater" bundle="profiles" />
		</button>
		<button id="createEBSNodeDBConfigPage_button_#7181" data-ng-disabled="!addEBSApp.$valid" type="button" data-ng-class="{'busy':ebsNode.loading}" data-ng-click="ebsNode.discoverNodes(wizardCtrl, addEBSApp)"  class="btn btn-primary cvBusyOnAjax"> 
			<cv:msg key="button.discover.nodes" bundle="servers" />
		</button>
  		<button id="createEBSNodeDBConfigPage_button_#1402" data-ng-disabled="!addEBSApp.$valid || !ebsNode.isClientMappingValid" type="submit" class="btn btn-primary cvBusyOnAjax"> 
  			<span data-ng-hide="isSetup">
	  			<cv:msg key="Add" bundle="messages" />
  			</span>
  			<span data-ng-show="isSetup">
	  			<cv:msg key="Save" bundle="messages" />
  			</span>
  		</button>
	</div>
</form>
</div>
