<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>

<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.vmsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.dbs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.navJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.saphana"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>

<div class="bootstrap-wrapper">
	<form class="form-horizontal">
		<div class="panel panel-default setup-panel">
			<div class="panel-heading">
				<div class="panel-title">
					<cv:msg key="label.selectTarget" bundle="vmsJs"></cv:msg>
				</div>
			</div>

			<div class="panel-body">
				<div class="row">
					<div
						class="col-xs-12 col-md-10 col-md-offset-1 col-lg-8 col-lg-offset-2">

						<div class="form-group">
							<label class="col-xs-12 col-md-4"><cv:msg
									key="label.servers" bundle="vmsJs"></cv:msg></label>
							<div class="col-xs-12 col-md-8"
								data-ng-disabled="replicationGroup.task">
								<isteven-multi-select id="targetClient"
									data-input-model="repTarget.clients"
									data-tick-property="checked" data-item-label="clientName"
									class="isteven-multi-select user-group-select"
									data-button-label="clientName" data-helper-elements="filter"
									on-item-click="repTarget.selectClient(data)"
									data-selection-mode="single" translation="repTarget.localLang">
								</isteven-multi-select>
							</div>
						</div>

						<div class="form-group">
							<label class="col-xs-12 col-md-4"> <cv:msg
									key="label.instance" bundle="dbs"></cv:msg>
							</label>
							<div class="col-xs-12 col-md-8"
								data-ng-disabled="replicationGroup.task">
								<isteven-multi-select id="targetInstance"
									data-input-model="repTarget.instances"
									data-tick-property="checked" data-item-label="instanceName"
									class="isteven-multi-select user-group-select"
									data-button-label="instanceName" data-helper-elements="filter"
									on-item-click="repTarget.selectInstance(data)"
									data-disable-property="disabled"
									data-selection-mode="single" translation="repTarget.localLang">
								</isteven-multi-select>
							</div>
						</div>

                        <div class="form-group" data-ng-if="replicationGroup.sourceEntity.isBackupsetSupported && repTarget.selectedInstance">
                            <label class="col-xs-12 col-md-4" >
                            	<cv:msg key="label.databases" bundle="dbs"></cv:msg>
                            </label>
                            <div class="col-xs-12 col-md-8" data-ng-disabled="replicationGroup.task">
                                <isteven-multi-select
                                	id="targetBackupset"
                                    data-input-model="repTarget.backupsets"
                                    data-tick-property="checked"
                                    data-item-label="backupsetName"
                                    class="isteven-multi-select user-group-select"
                                    data-button-label="backupsetName"
                                    data-helper-elements="filter"
                                    on-item-click="repTarget.selectBackupset(data)"
                                    data-selection-mode="single"
                                    data-disable-property="disabled"
                                    translation="repTarget.localLang">
                                </isteven-multi-select>
                            </div>
                        </div>

                        <div class="form-group">
							<label class="col-xs-12 col-md-4"><cv:msg
									key="label.replication.copyPrecedence" bundle="restore"></cv:msg></label>
							<div class="col-xs-12 col-md-8">
								<isteven-multi-select
									data-input-model="repTarget.storagePolicyCopies"
									data-tick-property="checked" data-item-label="copyName"
									class="isteven-multi-select user-group-select" id="copyName"
									data-button-label="copyName" data-helper-elements="filter"
									on-item-click="repTarget.selectCopyName(data)"
									data-selection-mode="single" translation="repTarget.localLang"></isteven-multi-select>
							</div>
						</div>


						<!-- Hiding this as not required in case of clone jobs
                        <div class="form-group" data-ng-if="repTarget.selectedInstance">
                            <label class="col-xs-12 col-md-4" >
                            	<cv:msg key="label.hanaDataDirectory" bundle="saphana" />
                            	<cv-help-component help-text="<cv:msg key="help.hanaDataDirectory" bundle="saphana"/>"></cv-help-component>
                            </label>
                            <div class="col-xs-12 col-md-8" data-ng-disabled="replicationGroup.task">
	                            <div class="input-group">
	                            	<input type="text" name="dataFilePath"
	                                   id="hanaDirectory"
	                                   data-ng-model="replicationGroup.hanaDirectory" />
	                                   <span class="input-group-btn">
			                               <cv-machine-browse
			                                  id="dataFilePathBrowse"
			                                  button-label='<cv:msg key="label.browse" bundle="restore"/>'
			                                  client-id='{{repTarget.selectedInstance.instance.clientId}}'
			                                  result-function="repTarget.updateHanaDirectory">
			                              </cv-machine-browse>
			                          </span>
                              </div>
                            </div>
                        </div>
                        -->

					</div>
				</div>

				<!-- <div class="row">
					<div
						class="col-xs-12 col-md-10 col-md-offset-1 col-lg-8 col-lg-offset-2">
						<div class="form-header cursor-pointer push-down"
							data-ng-click="repTarget.advancedOptions = !repTarget.advancedOptions">
							<cv:msg key="label.advancedOptions" bundle="vmsJs"></cv:msg>
							<i class="pull-right"
								data-ng-class="{'ion-chevron-down': repTarget.advancedOptions, 'ion-chevron-right': !repTarget.advancedOptions}"></i>
						</div>
						 Generate scrolling view for advanced options
						<div
							data-uib-collapse="!repTarget.advancedOptions">
							<div class="form-group">
								<label class="col-xs-12 col-md-4"><cv:msg
										key="label.replication.copyPrecedence" bundle="restore"></cv:msg></label>
								<div class="col-xs-12 col-md-8">
									<isteven-multi-select
										data-input-model="repTarget.storagePolicyCopies"
										data-tick-property="checked" data-item-label="copyName"
										class="isteven-multi-select user-group-select" id="copyName"
										data-button-label="copyName" data-helper-elements="filter"
										on-item-click="repTarget.selectCopyName(data)"
										data-selection-mode="single" translation="repTarget.localLang"></isteven-multi-select>
								</div>
							</div>

						</div>

					</div>

				</div> -->
			</div>
		</div>
	</form>
</div>
<div class="row additional-padding">
    <div class="button-container">
            <button id="backButton" class="btn btn-default"
                data-ng-click="repTarget.backClick()" >
                <cv:msg key="Back" bundle="messages"></cv:msg>
            </button>
            <button class="btn btn-primary" type="submit" id="saveButton" data-ng-click="repTarget.submitLiveSyncTask()"
                data-ng-if="replicationGroup.task">
                <cv:msg key="Save" bundle="messages"></cv:msg>
            </button>
            <button id="subButton" class="btn btn-primary" type="submit" data-ng-if="!replicationGroup.task" data-ng-click="repTarget.submitLiveSyncTask()" data-ng-disabled="!repTarget.selectedBackupset && !repTarget.selectedInstance">
                <cv:msg key="Submit" bundle="messages"></cv:msg>
            </button>
    </div>
</div>