<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>

<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.vmsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.dbs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.browse"></cv:cvMessages>
	<cv:cvMessages bundle="localization.browseJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.navJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
</script>

<div class="bootstrap-wrapper">
	<form class="form-horizontal">
		<div class="panel panel-default setup-panel">
			<div class="panel-heading">
				<div class="panel-title">
					<cv:msg key="label.selectSource" bundle="vmsJs"></cv:msg>
				</div>
			</div>

			<div class="panel-body">
				<div class="row">
					<div
						class="col-xs-12 col-md-10 col-md-offset-1 col-lg-8 col-lg-offset-2">
						<div class="form-group">
							<label class="col-xs-12 col-md-4"> <cv:msg
									key="label.name" bundle="vmsJs"></cv:msg>
							</label>
							<div class="col-xs-12 col-md-8">
								<input type="text" id="name"
									data-ng-model="replicationGroup.replicationName" required />
							</div>
						</div>

						<div class="form-group">
							<label class="col-xs-12 col-md-4"><cv:msg
									key="label.servers" bundle="vmsJs"></cv:msg></label>
							<div class="col-xs-12 col-md-8"
								data-ng-disabled="replicationGroup.task">
								<isteven-multi-select id="sourceClient"
									data-input-model="repSource.clients"
									data-tick-property="checked" data-item-label="clientName"
									class="isteven-multi-select user-group-select"
									data-button-label="clientName" data-helper-elements="filter"
									on-item-click="repSource.selectClient(data)"
									data-selection-mode="single" translation="repSource.localLang">
								</isteven-multi-select>
							</div>
						</div>

						<div class="form-group">
							<label class="col-xs-12 col-md-4"> <cv:msg
									key="label.instance" bundle="dbs"></cv:msg>
							</label>
							<div class="col-xs-12 col-md-8"
								data-ng-disabled="replicationGroup.task">
								<isteven-multi-select id="sourceInstance"
									data-input-model="repSource.instances"
									data-tick-property="checked" data-item-label="instanceName"
									class="isteven-multi-select user-group-select"
									data-button-label="instanceName" data-helper-elements="filter"
									on-item-click="repSource.selectInstance(data)"
									data-selection-mode="single" translation="repSource.localLang">
								</isteven-multi-select>
							</div>
						</div>

                        <div class="form-group" data-ng-if="repSource.isBackupsetSupported">
                            <label class="col-xs-12 col-md-4" >
                            	<cv:msg key="label.databases" bundle="dbs"></cv:msg>
                            </label>
                            <div class="col-xs-12 col-md-8" data-ng-disabled="replicationGroup.task">
                                <isteven-multi-select
                                	id="sourceDatabase"
                                    data-input-model="repSource.backupsets"
                                    data-tick-property="checked"
                                    data-item-label="backupsetName"
                                    class="isteven-multi-select user-group-select"
                                    data-button-label="backupsetName"
                                    data-helper-elements="filter"
                                    on-item-click="repSource.selectBackupset(data)"
                                    data-selection-mode="single"
                                    translation="repSource.localLang">
                                </isteven-multi-select>
                            </div>
                        </div>

					</div>
				</div>
			</div>
		</div>
	</form>
</div>
<div class="row">
    <div class="button-container">
            <button id="nextButton" class="btn btn-primary" type="button"
                data-ng-click="repSource.nextClick()" data-ng-disabled="((!replicationGroup.task && !repSource.allowTargetSelection)
                || (repSource.isBackupsetSupported && !repSource.selectedBackupset) ||  (!replicationGroup.replicationName.length))">
                <cv:msg key="Next" bundle="messages"></cv:msg>
            </button>
    </div>
</div>