<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.vmsJs"></cv:cvMessages>
    <cv:cvMessages bundle="localization.dbs"></cv:cvMessages>
    <cv:cvMessages bundle="localization.messages"></cv:cvMessages>
     <cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
     <cv:cvMessages bundle="localization.replicationGroups"></cv:cvMessages>
     <cv:cvMessages bundle="localization.sqlserver"></cv:cvMessages>
</script>
<script type="text/ng-template"  id="browse_tree_item_renderer.html">
    <div ng-class="{selected: (!selectMultiple && item == selectedItem) || (selectMultiple && selectedItems[getPath(item)] !== undefined)}" >
        <button id="selectOracleTarget_button_#7502" ng-if="item.state!='LEAF'" ng-class="item.state | lowercase" ng-click="folderDrilledDown(item)"></button> 
        <span ng-click="folderSelected(item)"><span class="path-title">{{item.label}}</span></span>
    </div>
    <div class="children" ng-class="item.state">
        <div class="browse-item" ng-repeat="item in item.children" ng-include="'browse_tree_item_renderer.html'"></div>
    </div>
</script>
<div class="bootstrap-wrapper">
 <form class="form-horizontal" >
    <div class="panel panel-default setup-panel">
		<div class="panel-heading">
            <div class="panel-title">
                <cv:msg key="label.selectTarget" bundle="vmsJs"></cv:msg>
            </div>
        </div>
        <div class="panel-body">
            <div class="row">
                <div
                    class="col-xs-12 col-md-10 col-md-offset-1 col-lg-8 col-lg-offset-2" >
                        <div class="form-group">
                            <label class="col-xs-12 col-md-4" ><cv:msg
                                    key="label.servers" bundle="vmsJs"></cv:msg></label>
                            <div class="col-xs-12 col-md-8" data-ng-disabled="replicationGroup.task">
                                <isteven-multi-select id="selectOracleTarget_isteven-multi-select_#5260" 
                                    data-input-model="configRepliOracleGroupTarget.destinationClients"
                                    data-tick-property="checked"
                                    data-item-label="clientName"
                                    class="isteven-multi-select user-group-select"
                                    data-button-label="clientName"
                                    data-helper-elements="filter"
									on-item-click="configRepliOracleGroupTarget.serverClick(data)"
                                    data-selection-mode="single" translation="configRepliOracleGroupTarget.localLang"></isteven-multi-select>
                            </div>
                        </div>
                        
						<div class="form-group">
                            <label class="col-xs-12 col-md-4"><cv:msg
                                    key="label.instance" bundle="dbs"></cv:msg></label>
                            <div class="col-xs-12 col-md-8" data-ng-disabled="!configRepliOracleGroupTarget.enableInstanceSelection || replicationGroup.task">
                                <isteven-multi-select id="selectOracleTarget_isteven-multi-select_#5565" 
                                    data-input-model="configRepliOracleGroupTarget.destinationInstances"
                                    data-tick-property="checked"
                                    data-item-label="instanceName"
                                    class="isteven-multi-select user-group-select"
                                    data-button-label="instanceName"
                                    data-helper-elements="filter"
                                    tick-property="ticked"
                                    group-property="instancesGroup"
									on-item-click="configRepliOracleGroupTarget.instanceClick( data )"
                                    data-selection-mode="single" translation="configRepliOracleGroupTarget.localLang"></isteven-multi-select>
                            </div>
                        </div>
                        
                        <!-- Hide Scheulde label
                        <div class="form-group">
                        	<label class="col-xs-12 col-md-4"><cv:msg
                                    key="label.schedule" bundle="profiles"></cv:msg></label>
                            <div class="col-xs-12 col-md-8">      
                            	<label for="schedule">
									<span class="ng-binding"><cv:msg
	                                    key="schedule.patternName" bundle="replicationGroups"></cv:msg></span>
								</label>  
                            </div>
                        </div>
                         -->
                                                
						
                </div>
            </div>
        </div>
	</div>
	
<div data-ng-show="configRepliOracleGroupTarget.errorMessageToShow" class="error horz-center extra-top-padding" data-ng-bind="configRepliOracleGroupTarget.errorMessageToShow"/>
</div>
	<div class="button-container">
			<button id="selectOracleTarget_button_#8789" class="btn btn-default" 
				data-ng-click="configRepliOracleGroupTarget.goBack()" >
				<cv:msg key="Back" bundle="messages"></cv:msg>
			</button>
			<button id="selectOracleTarget_button_#2600" class="btn btn-primary" type="button" data-ng-click="configRepliOracleGroupTarget.nextClick()" data-ng-disabled="!configRepliOracleGroupTarget.selectedDestinationInstance"> 
				<cv:msg key="Next" bundle="messages"></cv:msg>
			</button>
	</div>
  </form>
</div>
