<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.vmsJs"></cv:cvMessages>
    <cv:cvMessages bundle="localization.dbs"></cv:cvMessages>
    <cv:cvMessages bundle="localization.messages"></cv:cvMessages>
     <cv:cvMessages bundle="localization.browse"></cv:cvMessages>
     <cv:cvMessages bundle="localization.browseJs"></cv:cvMessages>
     <cv:cvMessages bundle="localization.navJs"></cv:cvMessages>
     <cv:cvMessages bundle="localization.clients"></cv:cvMessages>
</script>
<script type="text/ng-template"  id="browse_tree_item_renderer.html">
    <div ng-class="{selected: (!selectMultiple && item == selectedItem) || (selectMultiple && selectedItems[getPath(item)] !== undefined)}" >
        <button id="selectOracleContent_button_#7465" ng-if="item.state!='LEAF'" ng-class="item.state | lowercase" ng-click="folderDrilledDown(item)"></button> 
        <span ng-click="folderSelected(item)"><span class="path-title">{{item.label}}</span></span>
    </div>
    <div class="children" ng-class="item.state">
        <div class="browse-item" ng-repeat="item in item.children" ng-include="'browse_tree_item_renderer.html'"></div>
    </div>
</script>
<style type="text/css">
.row.additional-padding {
	padding-top: 20px;
}
</style>
<div class="bootstrap-wrapper">
 <form class="form-horizontal">
    <div class="panel panel-default setup-panel">
		<div class="panel-heading">
            <div class="panel-title">
                <cv:msg key="label.selectSource" bundle="vmsJs"></cv:msg>
            </div>
        </div>
        <div class="panel-body">
            <div class="row">
                <div
                    class="col-xs-12 col-md-10 col-md-offset-1 col-lg-8 col-lg-offset-2" >
                        <div class="form-group">
							<label class="col-xs-12 col-md-4"> <cv:msg
									key="label.name" bundle="vmsJs"></cv:msg>
							</label>
							<div class="col-xs-12 col-md-8">
								<input type="text" id="name"
								data-ng-model="configRepliOracleGroupContent.replicationName" required />
							</div>
						</div>
                        
                        <div class="form-group">
                            <label class="col-xs-12 col-md-4" ><cv:msg
                                    key="label.servers" bundle="vmsJs"></cv:msg></label>
                            <div class="col-xs-12 col-md-8" data-ng-disabled="replicationGroup.task">
                                <isteven-multi-select id="selectOracleContent_isteven-multi-select_#6376" 
                                    data-input-model="configRepliOracleGroupContent.clients"
                                    data-tick-property="checked"
                                    data-item-label="clientName"
                                    class="isteven-multi-select user-group-select"
                                    data-button-label="clientName"
                                    data-helper-elements="filter"
									on-item-click="configRepliOracleGroupContent.serverClick(data)"
                                    data-selection-mode="single" translation="configRepliOracleGroupContent.localLang"></isteven-multi-select>
                            </div>
                        </div>
						<div class="form-group">
                            <label class="col-xs-12 col-md-4"><cv:msg
                                    key="label.instance" bundle="dbs"></cv:msg></label>
                            <div class="col-xs-12 col-md-8" data-ng-disabled="replicationGroup.task || !configRepliOracleGroupContent.enableInstanceSelection">
                                <isteven-multi-select id="selectOracleContent_isteven-multi-select_#2194" 
                                    data-input-model="configRepliOracleGroupContent.instances"
                                    data-tick-property="checked"
                                    data-item-label="instanceName"
                                    class="isteven-multi-select user-group-select"
                                    data-button-label="instanceName"
                                    data-helper-elements="filter"
                                    tick-property="ticked"
                                    group-property="instancesGroup"
									on-item-click="configRepliOracleGroupContent.instanceClick( data )"
                                    data-selection-mode="single" translation="configRepliOracleGroupContent.localLang"></isteven-multi-select>
                            </div>
                        </div>
                </div>
            </div>
        </div>
	</div>
</form>
</div>
<div class="row additional-padding">
	<div class="button-container">
			<button id="selectOracleContent_button_#1569" class="btn btn-primary" type="button" 
			    data-ng-click="configRepliOracleGroupContent.nextClick()" data-ng-disabled="((!configRepliOracleGroupContent.restoreAllowed && !replicationGroup.task)
			    || (!configRepliOracleGroupContent.replicationName.length ))">
				<cv:msg key="Next" bundle="messages"></cv:msg>
			</button>
	</div>
</div>
