<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.vmsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.dbs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.browse"></cv:cvMessages>
	<cv:cvMessages bundle="localization.browseJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.navJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
</script>
<script type="text/ng-template" id="browse_tree_item_renderer.html">
    <div ng-class="{selected: (!selectMultiple && item == selectedItem) || (selectMultiple && selectedItems[getPath(item)] !== undefined)}" >
        <button id="selectDBContent_button_#6590" ng-if="item.state!='LEAF'" ng-class="item.state | lowercase" ng-click="folderDrilledDown(item)"></button> 
        <span ng-click="folderSelected(item)"><span class="path-title">{{item.label}}</span></span>
    </div>
    <div class="children" ng-class="item.state">
        <div class="browse-item" ng-repeat="item in item.children" ng-include="'browse_tree_item_renderer.html'"></div>
    </div>
</script>
<div class="bootstrap-wrapper">
	<form class="form-horizontal">
		<div class="panel panel-default setup-panel">
			<div class="panel-heading">
				<div class="panel-title">
					<cv:msg key="label.selectSource" bundle="vmsJs"></cv:msg>
				</div>
			</div>
			<div class="panel-body">
				<div class="row">
					<div
						class="col-xs-12 col-md-10 col-md-offset-1 col-lg-8 col-lg-offset-2">
						<!-- Replication Group Name -->
						<div class="form-group">
							<label class="col-xs-12 col-md-4" for="replicationName"><cv:msg
									key="label.name" bundle="vmsJs"></cv:msg> </label>
							<div class="col-xs-12 col-md-8">
								<input type="text" id="replicationName"
									data-ng-model="configRepliDBGroupContent.replicationName"
									required />
							</div>
						</div>
						<!-- Source Server -->
						<div class="form-group">
							<label class="col-xs-12 col-md-4" for="servers"><cv:msg
									key="label.servers" bundle="vmsJs"></cv:msg></label>
							<div class="col-xs-12 col-md-8"
								data-ng-disabled="replicationGroup.task">
								<isteven-multi-select
									data-input-model="configRepliDBGroupContent.clients"
									data-tick-property="checked" data-item-label="clientName"
									class="isteven-multi-select user-group-select"
									data-button-label="clientName" data-helper-elements="filter"
									id="servers"
									on-item-click="configRepliDBGroupContent.serverClick(data)"
									data-selection-mode="single"
									translation="configRepliDBGroupContent.localLang"></isteven-multi-select>
							</div>
						</div>
						<!-- Source Instance -->
						<div class="form-group">
							<label class="col-xs-12 col-md-4" for="instance"><cv:msg
									key="label.instance" bundle="dbs"></cv:msg></label>
							<div class="col-xs-12 col-md-8"
								data-ng-disabled="replicationGroup.task || !configRepliDBGroupContent.enableInstanceSelection">
								<isteven-multi-select
									data-input-model="configRepliDBGroupContent.instances"
									data-tick-property="checked" data-item-label="instanceName"
									class="isteven-multi-select user-group-select"
									data-button-label="instanceName" data-helper-elements="filter"
									tick-property="ticked" id="instance"
									group-property="instancesGroup"
									on-item-click="configRepliDBGroupContent.instanceClick( data )"
									data-selection-mode="single"
									translation="configRepliDBGroupContent.localLang"></isteven-multi-select>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</form>
</div>
<div data-ng-show="(browseData && browseData.length==0) || configRepliDBGroupContent.showErrorMessage"
	class="error horz-center extra-top-padding" id="errorMessage"
	data-ng-bind="configRepliDBGroupContent.errorMessageToShow" />
</div>
<div class="row col-md-12 navigation" id="databasesList">
	<cv-kendo-grid
		ng-if="gridOptions && configRepliDBGroupContent.showGrid"
		cv-grid-options="gridOptions"></cv-kendo-grid>
</div>
<div class="col-xs-12 col-md-12 col-lg-12 additional-padding">
	<div class="button-container">
		<button class="btn btn-primary" type="button" id="nextButton"
			data-ng-click="configRepliDBGroupContent.nextClick()"
			data-ng-disabled="!(configRepliDBGroupContent.replicationName.length && browseData && browseData.length > 0)">
			<cv:msg key="Next" bundle="messages"></cv:msg>
		</button>
	</div>
</div>
