<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.replicationGroups"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvEnum name="TMMsg.DRReplicationType"></cv:cvEnum>
</script>
<div>
	<div class="setup-title">
		<h1><cv:msg key="label.selectReplicationGroup" bundle="replicationGroups"></cv:msg></h1>
	</div>
	<div class="bootstrap-wrapper form-horizontal edit-users-grid-form">
		<div class="form-group">
			<span data-ng-if="replicationOptCtrl.serverMessage.message"
			class="{{replicationOptCtrl.serverMessage.type}} serverMessage text-center col-xs-12">
			{{replicationOptCtrl.serverMessage.message}}
			</span>
		</div>
		<div class="padding-top-0 modal-body">
			<span data-ng-if="replicationOptCtrl.showReplicationGroupsDropDown &&
				(!replicationOptCtrl.replicationGroupsList ||
						!replicationOptCtrl.replicationGroupsList.length)">
						<cv:msg key="Loading" bundle="messages" />
			</span>
			<div class="form-group" data-ng-if="replicationOptCtrl.showInfoMessage">
				<div class="margin-10">
					<cv-please-note header='<cv:msg key="action.note" bundle="restoreJs" />' body='{{replicationOptCtrl.infoMessageBody}}'></cv-please-note>
					<a data-ng-if="replicationOptCtrl.showReviewGroupBtn" class="pull-right" href="{{replicationOptCtrl.vmDetailLink}}" ><cv:msg key="label.reviewReplicationGroups" bundle="replicationGroups" /></a>
				</div>
			</div>
			<div class="form-group" data-ng-if="replicationOptCtrl.showReplicationGroupsDropDown &&
			replicationOptCtrl.replicationGroupsList && replicationOptCtrl.replicationGroupsList.length">
				<label class="col-xs-12 col-sm-4 col-md-4 col-lg-4"><span><cv:msg key="label.replicationGroups" bundle="replicationGroups"/></span></label>
				<div class="col-xs-12 col-sm-8">
					<div class="input-group">
						<div class="physicalPathFolder">
							<isteven-multi-select
			   				  data-input-model="replicationOptCtrl.replicationGroupsList"
			  				  data-button-label="groupName"
							  data-item-label="groupName"
							  disabled="disabled"
							  data-selection-mode="single"
			   				  data-tick-property="selected"
			   				  class="isteven-multi-select user-group-select"
			   				  on-item-click="replicationOptCtrl.selectReplicationGroup(data)"
			   				  id="replicationGroups"
			   				  name="replicationGroups"
			   				  helper-elements="filter showSelected"
			   				  max-labels="1">
							</isteven-multi-select>
						</div>
						<div class="input-group-btn">
							<span class="col-xs-12 col-sm-12">
								<a data-ng-click="replicationOptCtrl.createReplicationGroup()">
									<cv:msg key="label.createNew" bundle="replicationGroups" /></a>
							</span>
						</div>
					</div>
					<div class="help-block"
					data-ng-if="replicationOptCtrl.errorMessage && replicationOptCtrl.errorMessage.message">
						{{replicationOptCtrl.errorMessage.message}}
					</div>
				</div>
			</div>
			<div class="form-group" data-ng-if="!replicationOptCtrl.showReplicationGroupsDropDown">
				<div class="margin-10" data-ng-if="replicationOptCtrl.existedInAllGroups" >
					<cv-please-note header='<cv:msg key="action.note" bundle="restoreJs" />' body='<cv:msg key="info.noGroupForReplicationVM" bundle="replicationGroups" />'></cv-please-note>
					<a data-ng-if="replicationOptCtrl.showReviewGroupBtn" class="pull-right" href="{{replicationOptCtrl.vmDetailLink}}" ><cv:msg key="label.reviewReplicationGroups" bundle="replicationGroups" /></a>
				</div>
				<h4 class="col-xs-12" >
					<a data-ng-click="replicationOptCtrl.createReplicationGroup()" data-ng-if="replicationOptCtrl.existedInAllGroups"><cv:msg key="label.createNewReplicationGroup" bundle="replicationGroups" /></a>
					<span data-ng-if="!replicationOptCtrl.existedInAllGroups">
						<cv:msg key="msg.noReplicationGroups" bundle="replicationGroups" />
						<a data-ng-click="replicationOptCtrl.createReplicationGroup()"><cv:msg key="label.configureReplicationGroup"
										bundle="vmsJs" /></a>
					</span>
				</h4>
			</div>
		</div>
		<div class="button-container">
				<button id="replicationOption_button_#8191" type="button" data-ng-click="replicationOptCtrl.cancel()" class="btn btn-default cvBusyOnAjax"> 
					<cv:msg key="button.cancel" bundle="replicationGroups"></cv:msg>
				</button>
				<button id="replicationOption_button_#8135" data-ng-if="replicationOptCtrl.showReplicationGroupsDropDown" type="submit" data-ng-click="replicationOptCtrl.addReplicationGroup()" class="btn btn-primary cvBusyOnAjax"> 
					<cv:msg key="button.add" bundle="replicationGroups"></cv:msg>
				</button>
			</div>
	</div>
</div>