<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.vmsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.dbs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.sqlserver"></cv:cvMessages>
	<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.replicationGroups"></cv:cvMessages>
</script>
<script type="text/ng-template" id="browse_tree_item_renderer.html">
    <div ng-class="{selected: (!selectMultiple && item == selectedItem) || (selectMultiple && selectedItems[getPath(item)] !== undefined)}" >
        <button id="overrideOracleOptions_button_#7836" ng-if="item.state!='LEAF'" ng-class="item.state | lowercase" ng-click="folderDrilledDown(item)"></button> 
        <span ng-click="folderSelected(item)"><span class="path-title">{{item.label}}</span></span>
    </div>
    <div class="children" ng-class="item.state">
        <div class="browse-item" ng-repeat="item in item.children" ng-include="'browse_tree_item_renderer.html'"></div>
    </div>
</script>
<div class="bootstrap-wrapper">
	<form name="restoreForm" class="form-horizontal" novalidate
		data-cv-submit="configRepliOracleOverrideOptions.doOracleLiveSync()"
		autocomplete="off">
		<div class="panel panel-default setup-panel">
			<div class="panel-heading">
				<div class="panel-title">
					<cv:msg key="label.overrideOptions" bundle="vmsJs"></cv:msg>
				</div>
			</div>
			<div class="panel-body">
				<div class="row" data-ng-hide="replicationGroup.task">
					<div
						class="col-xs-12 col-md-10 col-md-offset-1 col-lg-8 col-lg-offset-2">
						<div class="form-header cursor-pointer push-down"
							data-ng-click="configRepliOracleOverrideOptions.redirectOptions = !configRepliOracleOverrideOptions.redirectOptions">
							<cv:msg key="label.redirect" bundle="sqlserver"></cv:msg>
							<i class="pull-right"
								data-ng-class="{'ion-chevron-down': configRepliOracleOverrideOptions.redirectOptions, 'ion-chevron-right': !configRepliOracleOverrideOptions.redirectOptions}"></i>
						</div>
						<!-- Generate scrolling view for data files -->
						<div
							data-uib-collapse="!configRepliOracleOverrideOptions.redirectOptions">
							<div class="form-group">
								<div class="col-xs-12 col-lg-5">
									<input type="radio" id="redirectAllCB" name="redirectAllCB"
										data-ng-model="configRepliOracleOverrideOptions.data.redirectOption"
										value="ALL" /> <label for="redirectAllCB"> <cv:msg
											key="label.redirectAll" bundle="oracle" />
									</label>
								</div>
								<div class="col-xs-12 col-lg-5">
									<input type="text" id="redirectAll" name="redirectAll"
										data-ng-disabled="configRepliOracleOverrideOptions.data.redirectOption !== 'ALL'"
										data-ng-model="configRepliOracleOverrideOptions.data.redirectAllPath" />
								</div>
								<span class="col-xs-12 col-lg-2"> <cv-machine-browse
										data-ng-disabled="configRepliOracleOverrideOptions.data.redirectOption !== 'ALL'"
										button-label='<cv:msg key="label.browse" bundle="restore"/>'
										folders-only=true
										client-id='{{replicationGroup.attributes.selectedDestinationInstance.clientId}}'
										result-function="configRepliOracleOverrideOptions.redirectAllPathResuleFunction"
										class="upload-button"> </cv-machine-browse>
								</span>
							</div>
							<div class="form-group">
								<div class="col-lg-4 col-xs-12">
									<input type="radio" id="individualTSCB" name="individualTSCB"
										data-ng-model="configRepliOracleOverrideOptions.data.redirectOption"
										data-ng-change="configRepliOracleOverrideOptions.loadDataFiles()"
										value="INDIVIDUAL" /> <label for="individualTSCB"> <cv:msg
											key="label.individualTables" bundle="oracle" />
									</label>
								</div>
								<div class="col-lg-4" data-ng-if="configRepliOracleOverrideOptions.showLoadingIcon && !configRepliOracleOverrideOptions.dataFilesModel">
									<label class="float-left spinner-sm"></label>
								</div>
							</div>
							<span
								data-ng-show=" configRepliOracleOverrideOptions.data.redirectOption == 'INDIVIDUAL' ">
								<div class="panel"
									data-ng-if="configRepliOracleOverrideOptions.data.isPDBInstance && configRepliOracleOverrideOptions.dataFilesModel">
									<div class="panel-body margin-left-25">
										<uib-accordion close-others="true" class="text-left">
										<div class="form-group"
											data-ng-repeat="pdb in configRepliOracleOverrideOptions.dataFilesModel track by $index">
											<div uib-accordion-group is-open="pdb.status">
												<uib-accordion-heading>
												{{pdb.database}} <i class="pull-right glyphicon"
													data-ng-class="{'glyphicon-chevron-down': pdb.status, 'glyphicon-chevron-right': !pdb.status}"></i>
												</uib-accordion-heading>
												<cv-oracle-tablespace tablespaces="pdb.tableSpace">
												</cv-oracle-tablespace>
											</div>
										</div>
										</uib-accordion>
									</div>
								</div>
								<div
									data-ng-if="configRepliOracleOverrideOptions.data.isPDBInstance === false && configRepliOracleOverrideOptions.dataFilesModel">
									<cv-oracle-tablespace
										tablespaces="configRepliOracleOverrideOptions.dataFilesModel"></cv-oracle-tablespace>
								</div>
							</span>
							
						</div>
					</div>
				</div>
				<div class="row">
					<div
						class="col-xs-12 col-md-10 col-md-offset-1 col-lg-8 col-lg-offset-2">
						<div class="form-header cursor-pointer push-down"
							data-ng-click="configRepliOracleOverrideOptions.advancedOptions = !configRepliOracleOverrideOptions.advancedOptions">
							<cv:msg key="label.advancedOptions" bundle="vmsJs"></cv:msg>
							<i class="pull-right"
								data-ng-class="{'ion-chevron-down': configRepliOracleOverrideOptions.advancedOptions, 'ion-chevron-right': !configRepliOracleOverrideOptions.advancedOptions}"></i>
						</div>
						<!-- Generate scrolling view for advanced options -->
						<div
							data-uib-collapse="!configRepliOracleOverrideOptions.advancedOptions">
							<div class="form-group" data-ng-hide="replicationGroup.task">
								<label class="col-xs-12 col-sm-4" for="noRecovery"><cv:msg
										key="label.liveSyncOptions" bundle="sqlserver"></cv:msg></label>
								<div class="col-xs-12 col-sm-8">
									<div class="multiple-radio-group">
										<label><input name="radio2" value="0" type="radio"
											id="useRecentBackup"
											data-ng-model="replicationGroup.attributes.baseLineOption" />
											<span><label for="useRecentBackup"><cv:msg
														key="label.useRecentBackup" bundle="oracle"></cv:msg></label></span></label>
									</div>
									<div class="multiple-radio-group">
										<label><input name="radio2" value="1" type="radio"
											id="newBackup"
											data-ng-model="replicationGroup.attributes.baseLineOption" />
											<span><label for="newBackup"><cv:msg
														key="label.newBackup" bundle="oracle"></cv:msg></label></span></label>
									</div>
								</div>
							</div>
							<div class="form-group">
								<label class="col-sm-4" for="noOfStreams"><cv:msg
										key="label.noOfStreams" bundle="oracle"></cv:msg></label>
								<div class="col-sm-8">
									<input id="noOfStreams" name="noOfStreams"
										ng-model="configRepliOracleOverrideOptions.noOfStreams"
										min="1" max="30" value="2" class="" type="number" />
								</div>
							</div>
							<div class="form-group">
								<label class="col-xs-12 col-md-4"><cv:msg
										key="label.copyPrecedenceId" bundle="restore"></cv:msg></label>
								<div class="col-xs-12 col-md-8">
									<isteven-multi-select
										data-input-model="configRepliOracleOverrideOptions.storagePolicyCopies"
										data-tick-property="checked" data-item-label="copyName"
										class="isteven-multi-select user-group-select" id="copyName"
										data-button-label="copyName" data-helper-elements="filter"
										on-item-click="configRepliOracleOverrideOptions.selectCopyName(data)"
										data-selection-mode="single"
										translation="configRepliOracleOverrideOptions.localLang"></isteven-multi-select>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="button-container">
			<button class="btn btn-default" id="backButton"
				data-ng-click="configRepliOracleOverrideOptions.goBack()">
				<cv:msg key="Back" bundle="messages"></cv:msg>
			</button>
			<button class="btn btn-primary" type="submit" id="saveButton"
				data-ng-if="replicationGroup.task">
				<cv:msg key="Save" bundle="messages"></cv:msg>
			</button>
			<button class="btn btn-primary" type="submit" id="submitButton"
				data-ng-if="!replicationGroup.task"
				data-ng-disabled="!configRepliOracleOverrideOptions.oracleReplicationGroup">
				<cv:msg key="Submit" bundle="messages"></cv:msg>
			</button>
		</div>
	</form>
</div>
