<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.vmsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.dbs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.sqlserver"></cv:cvMessages>
	<cv:cvMessages bundle="localization.replicationGroups"></cv:cvMessages>
</script>
<script type="text/ng-template" id="browse_tree_item_renderer.html">
    <div ng-class="{selected: (!selectMultiple && item == selectedItem) || (selectMultiple && selectedItems[getPath(item)] !== undefined)}" >
        <button id="overrideDBOptions_button_#6889" ng-if="item.state!='LEAF'" ng-class="item.state | lowercase" ng-click="folderDrilledDown(item)"></button> 
        <span ng-click="folderSelected(item)"><span class="path-title">{{item.label}}</span></span>
    </div>
    <div class="children" ng-class="item.state">
        <div class="browse-item" ng-repeat="item in item.children" ng-include="'browse_tree_item_renderer.html'"></div>
    </div>
</script>
<div class="bootstrap-wrapper">
	<form name="restoreForm" class="form-horizontal" novalidate
		data-cv-submit="configRepliDBOverrideOptions.doSQLLiveSync()"
		autocomplete="off">
		<div class="panel panel-default setup-panel">
			<div class="panel-heading">
				<div class="panel-title">
					<cv:msg key="label.overrideOptions" bundle="vmsJs"></cv:msg>
				</div>
			</div>
			<div class="panel-body">
				<div class="row">
					<div data-ng-show="configRepliDBOverrideOptions.errorMessageToShow"
						class="error horz-center extra-top-padding" id="errorMessage"
						data-ng-bind="configRepliDBOverrideOptions.errorMessageToShow" />
				</div> 
			
				<div class="row">
					<div
						class="col-xs-12 col-md-10 col-md-offset-1 col-lg-8 col-lg-offset-2">
						<div class="form-header cursor-pointer push-down"
							data-ng-click="configRepliDBOverrideOptions.redirectOptions = !configRepliDBOverrideOptions.redirectOptions">
							<cv:msg key="label.redirect" bundle="sqlserver"></cv:msg>
							<i class="pull-right"
								data-ng-class="{'ion-chevron-down': configRepliDBOverrideOptions.redirectOptions, 'ion-chevron-right': !configRepliDBOverrideOptions.redirectOptions}"></i>
						</div>
						<!-- Generate scrolling view for data files -->
						<div
							data-uib-collapse="!configRepliDBOverrideOptions.redirectOptions">
							<ul class="vm-full-restore-list sql restore-left-side">
								<li
									data-ng-repeat="database in configRepliDBOverrideOptions.databasesList">
									<a class="btn"
									data-ng-click="configRepliDBOverrideOptions.databaseClick(database)"
									title="{{database.databaseName}}"
									id="{{database.databaseName}}"
									data-ng-class="{'selected-value': database.databaseName == configRepliDBOverrideOptions.selectedDatabase.databaseName}">{{database.databaseName}}
								</a>
									<ul
										data-ng-if="configRepliDBOverrideOptions.selectedDatabase.databaseName == database.databaseName">
										<li
											data-ng-repeat="sqlDbDeviceItem in configRepliDBOverrideOptions.dataFiles">
											<a class="btn"
											data-ng-click="configRepliDBOverrideOptions.selectDataFile(sqlDbDeviceItem)"
											title="{{sqlDbDeviceItem.logicalFileName}}"
											id="{{sqlDbDeviceItem.logicalFileName}}"
											data-ng-class="{'selected-value': sqlDbDeviceItem.logicalFileName == replicationGroup.attributes.restoreData.sqlDbDeviceItemsCopy[configRepliDBOverrideOptions.selectedIndex].logicalFileName}">-{{sqlDbDeviceItem.logicalFileName}}
										</a>
										</li>
									</ul>
								</li>
							</ul>
							<div
								class="vm-full-restore-form form-horizontal bootstrap-wrapper restore-right-side">
								<div id="perFileOptions" class="mainFormContent">
									<!-- Database Name -->
									<div class="form-group"
										data-ng-if="configRepliDBOverrideOptions.enableDatabaseNode">
										<label class="col-sm-4" for="databaseName"><cv:msg
												key="label.DatabaseName" bundle="sqlserver"></cv:msg></label>
										<div class="col-sm-8">
											<input type="text" name="databaseName" id="databaseName"
												data-ng-model="configRepliDBOverrideOptions.selectedDatabase.newDatabaseName"
												data-ng-blur="configRepliDBOverrideOptions.updateDatabaseName(configRepliDBOverrideOptions.selectedDatabase.newDatabaseName)" />
										</div>
									</div>
									<!-- Data File Path  -->
									<div class="form-group"
										data-ng-if="configRepliDBOverrideOptions.enableDatabaseNode">
										<label class="col-sm-4" for="dataFilePath"><cv:msg
												key="label.dataFilePath" bundle="sqlserver"></cv:msg></label>
										<div class="col-sm-8">
											<div class="input-group">
												<input type="text" name="dataFilePath"
													id="physicalPathFolder"
													data-ng-change="configRepliDBOverrideOptions.updateNDFFilesPath()"
													data-ng-model="replicationGroup.attributes.restoreData.sqlDbDeviceItemsCopy[configRepliDBOverrideOptions.dataFileNodeIndex].physicalFilePath" />
												<span class="input-group-btn"> 
													<cv-machine-browse
														id="dataFilePathBrowse"
														button-label='<cv:msg key="label.browse" bundle="restore"/>'
														client-id='{{replicationGroup.attributes.selectedDestinationInstance.clientId}}'
														result-function="configRepliDBOverrideOptions.updateDataFilePath">
													</cv-machine-browse>
												</span>
											</div>
										</div>
									</div>
									<!-- Log File Path -->
									<div class="form-group"
										data-ng-if="configRepliDBOverrideOptions.enableDatabaseNode">
										<label class="col-sm-4" for="logFilePath"><cv:msg
												key="label.logFilePath" bundle="sqlserver"></cv:msg></label>
										<div class="col-sm-8">
											<div class="input-group">
												<input type="text" name="logFilePath"
													id="physicalPathFolder"
													data-ng-model="replicationGroup.attributes.restoreData.sqlDbDeviceItemsCopy[configRepliDBOverrideOptions.logFileNodeIndex].physicalFilePath" />
												<span class="input-group-btn"> 
													<cv-machine-browse
														id="logFilePathBrowse"
														button-label='<cv:msg key="label.browse" bundle="restore"/>'
														client-id='{{replicationGroup.attributes.selectedDestinationInstance.clientId}}'
														result-function="configRepliDBOverrideOptions.updateLogFilePath">
													</cv-machine-browse>
												</span>
											</div>
										</div>
									</div>
									<!-- File Name -->
									<div class="form-group"
										data-ng-if="configRepliDBOverrideOptions.selectedIndex !== undefined">
										<label class="col-sm-4" for="physicalPathFileName"><cv:msg
												key="label.physicalFileName" bundle="sqlserver"></cv:msg></label>
										<div class="col-sm-8">
											<input type="text" name="physicalPathFileName"
												id="physicalPathFileName"
												data-ng-model="replicationGroup.attributes.restoreData.sqlDbDeviceItemsCopy[configRepliDBOverrideOptions.selectedIndex].physicalFileName" />
										</div>
									</div>
									<!-- Physical Path -->
									<div class="form-group"
										data-ng-if="configRepliDBOverrideOptions.selectedIndex !== undefined">
										<label class="col-sm-4" for="physicalPathFileName"><cv:msg
												key="label.physicalFileName" bundle="sqlserver"></cv:msg></label>
										<div class="col-sm-8">
											<label for="physicalFilePath">{{replicationGroup.attributes.restoreData.sqlDbDeviceItemsCopy[configRepliDBOverrideOptions.selectedIndex].physicalFilePath}}</label>
										</div>
									</div>
									<div class="form-group"
										data-ng-if="configRepliDBOverrideOptions.selectedIndex !== undefined">
										<label class="col-sm-4"><cv:msg key="label.fileSize"
												bundle="sqlserver"></cv:msg></label>
										<div class="col-sm-8">
											<label for="fileSize"> <span class="ng-binding">
													{{replicationGroup.attributes.restoreData.sqlDbDeviceItemsCopy[configRepliDBOverrideOptions.selectedIndex].fileMaxSize
													| capacity}}</span>
											</label>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="row">
					<div
						class="col-xs-12 col-md-10 col-md-offset-1 col-lg-8 col-lg-offset-2">
						<div class="form-header cursor-pointer push-down"
							data-ng-click="configRepliDBOverrideOptions.advancedOptions = !configRepliDBOverrideOptions.advancedOptions">
							<cv:msg key="label.advancedOptions" bundle="vmsJs"></cv:msg>
							<i class="pull-right"
								data-ng-class="{'ion-chevron-down': configRepliDBOverrideOptions.advancedOptions, 'ion-chevron-right': !configRepliDBOverrideOptions.advancedOptions}"></i>
						</div>
						<!-- Generate scrolling view for advanced options -->
						<div
							data-uib-collapse="!configRepliDBOverrideOptions.advancedOptions">
							<div class="form-group">
								<label class="col-sm-4" for="syncDelay">
								<cv-help-text help-label="label.syncDelay" help-text="'<cv:msg key='label.syncDelayHelpText' bundle='sqlserver'/>'" />
								</label>
								<div class="col-sm-8">
									<input id="syncDelay" name="syncDelay"
										data-ng-model="replicationGroup.attributes.syncDelay" min="0"
										max="24" value="0" class="" type="number" />
									<cv:msg key="label.hours" bundle="sqlserver"></cv:msg>
								</div>
							</div>
							<div class="form-group" data-ng-disabled="replicationGroup.task">
								<label class="col-xs-12 col-sm-4" for="noRecovery"><cv:msg
										key="label.recoveryType" bundle="vmsJs"></cv:msg></label>
								<div class="col-xs-12 col-sm-8">
									<div class="multiple-radio-group">
										<label><input name="radio2" value="NO_RECOVERY"
											type="radio" id="noRecovery"
											data-ng-model="replicationGroup.attributes.radioOption"
											data-ng-change="configRepliDBOverrideOptions.isStandBy(false);" />
											<span><label for="noRecovery"><cv:msg
														key="label.noRecovery" bundle="sqlserver"></cv:msg></label></span></label>
									</div>
									<div class="multiple-radio-group" >
										<label><input name="radio2" value="STAND_BY"
											type="radio" id="standBy"
											data-ng-model="replicationGroup.attributes.radioOption"
											data-ng-change="configRepliDBOverrideOptions.isStandBy(true);" />
											<span><label for="standBy"><cv:msg
														key="label.standBy" bundle="sqlserver"></cv:msg></label></span></label>
									</div>
								</div>
							</div>
							<div class="form-group" data-ng-disabled="replicationGroup.task"
								data-ng-if="configRepliDBOverrideOptions.isStandByMode">
								<label class="col-sm-4" for="undoFilePath"><cv:msg
										key="label.undoFilePath" bundle="sqlserver"></cv:msg></label>
								<div class="col-sm-8">
									<div class="input-group">
										<input type="text" name="undoFilePath" id="physicalPathFolder"
											data-ng-model="replicationGroup.attributes.undoFilePath" />
										<span class="input-group-btn">
											<cv-machine-browse
												id="undoFilePathBrowse"
												button-label='<cv:msg key="label.browse" bundle="restore"/>'
												client-id='{{replicationGroup.attributes.selectedDestinationInstance.clientId}}'
												result-function="configRepliDBOverrideOptions.updateUndoFilePath">
											</cv-machine-browse>
										</span>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="button-container">
			<button class="btn btn-default" id="backButton"
				data-ng-click="configRepliDBOverrideOptions.goBack()">
				<cv:msg key="Back" bundle="messages"></cv:msg>
			</button>
			<button class="btn btn-primary" type="submit" id="saveButton"
				data-ng-if="replicationGroup.task">
				<cv:msg key="Save" bundle="messages"></cv:msg>
			</button>
			<button class="btn btn-primary" type="submit" id="submitButton"
				data-ng-if="!replicationGroup.task"
				data-ng-disabled="!configRepliDBOverrideOptions.sqlReplicationGroup">
				<cv:msg key="Submit" bundle="messages"></cv:msg>
			</button>
		</div>
	</form>
</div>
