<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1>
		{{scriptPre.dialogTitle}}
	</h1>
</div>
<div class="bootstrap-wrapper">
	<div class="panel" >
		<div class="panel-body">
			<div id="modern-tab" class="tab-3" >
				<div class="margin-top-15" data-ng-if="scriptPre.isLoading">
					<h4 data-ng-if="!scriptPre.showError">
						<cv:msg key="Loading" bundle="messages" />
						<img class="job-log-loader" src="${pageContext.request.contextPath}/common/img/ajax-loader.gif">
					</h4>
					<span data-ng-if="scriptPre.showError" class="{{scriptPre.previewServerMessage.type}}" data-ng-bind="scriptPre.previewServerMessage.message"></span>
				</div>
				<cv-tabset-component control='scriptPre.tabControls' >
					<cv-tab tabname="<cv:msg key="label.readiness" bundle="oracle" />" >
						<div class="form-panel-holder" data-ng-if="!scriptPre.showReadinessTable">
							<textarea id="readinessScript" data-ng-bind="scriptPre.readinessScript" class="min-height-450" data-ng-disabled="true" ></textarea>
						</div>
						<div class="form-panel-holder padding-top-20" data-ng-if="scriptPre.showReadinessTable">
							<cv-kendo-grid class="previewReadiness" data-cv-grid-options="scriptPre.gridOptions"></cv-kendo-grid>
						</div>
					</cv-tab>
					<cv-tab tabname='{{scriptPre.dataTabName}}' >
						<div class="form-panel-holder">
							<textarea id="dataScript" data-ng-model="scriptPre.dataScript"  class="min-height-450" data-ng-disabled="scriptPre.enableEditing"></textarea>
						</div>
					</cv-tab>
					<cv-tab  tabname="{{scriptPre.logTabName}}" >
						<div class="form-panel-holder">
							<textarea id="logScript" data-ng-model="scriptPre.logScript"  class="min-height-450" data-ng-disabled="scriptPre.enableEditing"></textarea>
						</div>
					</cv-tab>
					<div data-ng-init="scriptPre.afterTabInit()"></div>
				</cv-tabset-component>
			</div>
		</div>
		<div class="modal-footer">
			<button id="dbCustomizeScripModel_button_close"  type="button" class="btn btn-primary"data-ng-click="scriptPre.closeDialogBox()">
				<cv:msg key="label.close" bundle="messagesJs" />
			</button>
			<button data-ng-hide="scriptPre.hideCustomizeButton" id="dbCustomizeScripModel_button_save"  type="button" class="btn btn-default"data-ng-click="scriptPre.editScript()">
				<cv:msg key="label.customize" bundle="oracle" />
			</button>
			<button data-ng-show="scriptPre.editing && !scriptPre.isLoading" id="dbCustomizeScripModel_button_submit" data-ng-class="{'busy':scriptPre.watingOnJOb}"  type="button" class="btn cvBusyOnAjax" data-ng-click="scriptPre.submitScript()">
				<cv:msg key="Submit" bundle="messages" />
			</button>
		</div>
	</div>
</div>