<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>

<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
	<cv:cvMessages bundle="localization.fs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
	<cv:cvMessages bundle="localization.saphana"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.dbs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvMessages bundle="localization.sqlserver"></cv:cvMessages>
</script>
<div class="row">
	<div class="col-xs-12">
		<h1 class="page-title"
			data-ng-bind="dbInstanceSettingsCtrl.instance.instanceName"></h1>
	</div>
</div>
<cv-tab-nav></cv-tab-nav>
<div class="row" style="margin-top: 20px;">
	<div class="col-md-6"
		data-ng-if="dbInstanceSettingsCtrl.acParams && dbInstanceSettingsCtrl.isInstanceActivitySupported"">
		<cv-activity-control-component
			data-ac-params="dbInstanceSettingsCtrl.acParams">
		</cv-activity-control-component>
		<cv-sql-cloud-config-component
			data-ng-if="dbInstanceSettingsCtrl.isAmazonSqlVirtual || dbInstanceSettingsCtrl.isAzureSqlVirtual"
			sql-prop-loaded="dbInstanceSettingsCtrl.clientDetailsLoaded"
			entity-type='dbInstanceSettingsCtrl.entityType'
			generic-entity='dbInstanceSettingsCtrl.instance'
			aws-sql-info='dbInstanceSettingsCtrl.instanceDetails.mssqlInstance.awsSqlInfo'
			azure-sql-info='dbInstanceSettingsCtrl.instanceDetails.mssqlInstance.azureInfo'
			overwrite-higher-level-settings='dbInstanceSettingsCtrl.overwriteHigherLevelSettings'>
		</cv-sql-cloud-config-component>
		<cv-sql-availability-group-replicas
			data-ng-if="dbInstanceSettingsCtrl.isAvailabilityGroupInstance"
			instance-entity="dbInstanceSettingsCtrl.instanceDetails.instance"
			ag-properties="dbInstanceSettingsCtrl.instanceDetails.mssqlInstance.agProperties"
			result-func="dbInstanceSettingsCtrl.onUpdateAgReplicaSuccess(SQLAvailabilityReplicasList, offloadFullBkpJobToSecondary)">
		</cv-sql-availability-group-replicas>
	</div>
	<div class="col-md-6">
		<cv-security-component entity-type='dbInstanceSettingsCtrl.entityType'
			generic-entity='dbInstanceSettingsCtrl.instance'
			associations-loaded="dbInstanceSettingsCtrl.associationsLoaded"
			associations='dbInstanceSettingsCtrl.formattedSecurityAssociations'>
		</cv-security-component>
	</div>

</div>

<div class="row">
	<div class="col-md-6" data-ng-if="dbInstanceSettingsCtrl.showSettingsTile">
		<cv-tile-component data-ac-id="dbInstanceSettings_settingsTile" data-title='<cv:msg key="label.settings" bundle="profiles"/>' >
				<ul class="list-style-secondary" >
					<cv-capps-region data-ng-if="dbInstanceSettingsCtrl.isAmazonDb" instance-details="dbInstanceSettingsCtrl.instanceDetails" />
				</ul>
		</cv-tile-component>
	</div>
	<div class="col-md-6" data-ng-if="dbInstanceSettingsCtrl.showProxyTile">
		<cv-instance-proxy-component
			entity-type="dbInstanceSettingsCtrl.entityType"
			instance-id="dbInstanceSettingsCtrl.instanceId"
			server-id="dbInstanceSettingsCtrl.instance.clientId"
			application-id="dbInstanceSettingsCtrl.instance.applicationId"
			server-name="dbInstanceSettingsCtrl.instance.clientName"
			server-type="dbInstanceSettingsCtrl.instance.vendor"
			instance-details="dbInstanceSettingsCtrl.instanceDetails"
			instance="dbInstanceSettingsCtrl.instance">
		</cv-instance-proxy-component>
	</div>
</div>
<cv-db2-partition-nodes data-ng-if="dbInstanceSettingsCtrl.instInfo" inst-info ="dbInstanceSettingsCtrl.instInfo" ></cv-db2-partition-nodes>

<cv-rac-manage-instances
	data-ng-if="dbInstanceSettingsCtrl.instance.applicationId == 80 && dbInstanceSettingsCtrl.instance.instanceId"
	entity="dbInstanceSettingsCtrl.instance"
	instances="dbInstanceSettingsCtrl.racInstances">
</cv-rac-manage-instances>