<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.genApp"></cv:cvMessages>
	<cv:cvMessages bundle="localization.fs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
	<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
	<cv:cvMessages bundle="localization.saphana"></cv:cvMessages>
	<cv:cvMessages bundle="localization.dbs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.db2"></cv:cvMessages>
	<cv:cvMessages bundle="localization.informix"></cv:cvMessages>
	<cv:cvMessages bundle="localization.mySql"></cv:cvMessages>
	<cv:cvMessages bundle="localization.postgres"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.sqlServerInstance"></cv:cvMessages>
	<cv:cvMessages bundle="localization.sqlserver"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vmsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.replicationGroups"></cv:cvMessages>
	<cv:cvMessages bundle="localization.sybase"></cv:cvMessages>
	<cv:cvMessages bundle="localization.settings"></cv:cvMessages>
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
    <cv:cvMessages bundle="localization.browse"></cv:cvMessages>
    <cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvEnum name="App.VSAFailoverStatus"></cv:cvEnum>
	<cv:cvEnum name="App.VSAReplicationStatus"></cv:cvEnum>
	<cv:cvEnum name="App.VMSLAStatus"></cv:cvEnum>

</script>
<div class="row">
	<div class="col-xs-12">
		<h1 class="page-title" data-ng-bind="dbInsDetails.instance.instanceName"></h1>
	</div>
</div>
<cv-tab-nav></cv-tab-nav>
<div class="row">
 	<div class="col-md-6">
 		<div data-ng-if="dbInsDetails.showKpi">
			<cv-entity-status data="dbInsDetails.instanceStatusInfo" data-title='<cv:msg key="label.databases" bundle="sqlserver"/>'></cv-entity-status>
		</div>
		<cv-tile-component data-ac-id="subscriptionsDetails-label_general-subscriptions" data-title='<cv:msg key="label.general" bundle="sqlServerInstance"/>' loader="dbInsDetails.closeLoader" enable-accordion="true">
			<ul class="list-style-secondary" >
				<cv-tile-label-value data-ng-repeat="row in dbInsDetails.instanceRows" label="{{row.label}}" value="{{row.data}}" entity-type="{{row.entityType}}" entity="row.entity"> </cv-tile-label-value>
				<li class="group" data-ng-if="dbInsDetails.isDB2Instance && dbInsDetails.instanceDetails.version">
					<span class="pageDetailColumn"> <cv:msg key="label.version" bundle="sqlserver"/> </span>
					<span class="pageDetailColumn"><a href="" data-ng-click="dbInsDetails._showVersionsModel()"><cv-help-text help-label="{{dbInsDetails.instanceDetails.version}}" help-text="'<cv:msg key="help.history" bundle="dbs"/>'"></cv-help-text></a></span>
				</li>
				<li data-ng-show="dbInsDetails.isAmazonDb || dbInsDetails.isAzureDb" class="group">
					<cv-plan-select show-edit="true" plan-entity="dbInsDetails.instanceDetails.planEntity" refresh-global-cache="true" entity="dbInsDetails.instanceDetails.instance" ng-if="dbInsDetails.instanceDetails"></cv-plan-select>
				</li>

				<li class="group" data-ng-show="dbInsDetails.showInstanceStatus">
					<span class="pageDetailColumn"> <cv:msg key="heading.instanceStatus" bundle="oracle"/></span>
					<span class="pageDetailColumn"> {{dbInsDetails.instanceStatusValue}}
						<a class="btn btn-ternary rounded-border-radius" href="" data-ng-click="dbInsDetails.refreshInstanceStatus(dbInsDetails.instance)" title="<cv:msg key="status.DEFAULTMSG" bundle="oracle" />">
							<span class="k-icon k-i-refresh" ></span>
						</a>
					</span>
				</li>

				<li class="group" data-ng-show="dbInsDetails.isAzureDb && dbInsDetails.instanceDetails.cloudAppsInstance.generalCloudProperties.azureResourceManager.subscriptionId">
					<span class="pageDetailColumn"><cv:msg key="label.subscriptionId" bundle="servers"/></span>
					<span class="pageDetailColumn">
						<a data-ng-click="dbInsDetails.editAmazonCredentials()">
							<span data-ng-bind="dbInsDetails.instanceDetails.cloudAppsInstance.generalCloudProperties.azureResourceManager.subscriptionId"></span>
						</a>
					</span>
				</li>

				<li data-ng-if="dbInsDetails.showAmazonCredentials" class="group">
					<span class="pageDetailColumn" data-ng-if="dbInsDetails.instanceDetails.cloudAppsInstance.generalCloudProperties.amazonInstanceInfo.accessKey">
						<cv:msg key="label.accessKey" bundle="servers" />
					</span>
					<span class="pageDetailColumn" data-ng-if="!dbInsDetails.instanceDetails.cloudAppsInstance.generalCloudProperties.amazonInstanceInfo.accessKey">
						<cv:msg key="label.authentication" bundle="serversJs" />
					</span>
					<div class="pageDetailColumn inline-editor" >
						<span class="inline-editor-text" data-ng-if="dbInsDetails.instanceDetails.cloudAppsInstance.generalCloudProperties.amazonInstanceInfo.accessKey"> {{dbInsDetails.instanceDetails.cloudAppsInstance.generalCloudProperties.amazonInstanceInfo.accessKey}}</span>

					    <span class="inline-editor-text" data-ng-if="!dbInsDetails.instanceDetails.cloudAppsInstance.generalCloudProperties.amazonInstanceInfo.accessKey"> <cv:msg key="label.IAMRole" bundle="servers" /> </span>
					    <span class="inline-editor-buttons">
					        <a href class="inline-editor-button text padding-right-0" ng-click="dbInsDetails.editAmazonCredentials()" id="editAmazonCredentials">
					            <cv:msg key="label.actionEdit" bundle="messagesJs"/>
					        </a>
					    </span>
					</div>
				</li>
			</ul>
			<div class="page-details-box-links" data-ng-if="dbInsDetails.instanceDetails && !dbInsDetails.isAmazonDb && !dbInsDetails.isAzureDb">
				<a href="" data-ng-click="dbInsDetails._editInstance()"><cv:msg key="action.edit" bundle="settingsJs"/></a>
			</div>
		</cv-tile-component>
		<%-- <div data-ng-if="dbInsDetails.racGridOptions">
			<cv-kendo-grid cv-grid-options="dbInsDetails.racGridOptions" >
			</cv-kendo-grid>
		</div>  --%>
		<%-- <cv-tile-component data-ng-if="dbInsDetails.racGridOptions" data-ac-id="subscriptionsDetails-label_general-RACInstances" data-title='<cv:msg key="label.racInstance" bundle="oracle"/>'
				loader="dbInsDetails.instanceDetails" >
			<span data-ng-if="dbInsDetails.racGridOptions" class="grid-no-header grid-in-tile-scroll-fix">
				<cv-kendo-grid cv-grid-options="dbInsDetails.racGridOptions" >
				</cv-kendo-grid>
			</span>
		</cv-tile-component> --%>
	</div>
	<div class="col-md-6" data-ng-if="dbInsDetails.clientDetails && dbInsDetails.showBackHistoryTile()">
		<cv-backup-history params="dbInsDetails.params" entity="dbInsDetails.instance" on-restore="dbInsDetails._performRestore(job, selectedNode, toTimeStr)"
						   show-clone="dbInsDetails.showClone" on-clone="dbInsDetails._performClone(job, fromTimeStr, toTimeStr)"></cv-backup-history>
	</div>
</div>
<div data-ng-if="dbInsDetails.instanceDetails && dbInsDetails.isDbThinClient === false">
	<span data-ng-if="!dbInsDetails.isBackupsetSupported">
		<cv-db-subclients-component entity="dbInsDetails.instance" other-options="dbInsDetails.otherOptions"  plan-entity="dbInsDetails.instanceDetails.planEntity" > </cv-db-subclients-component>
	</span>
	<span data-ng-if="dbInsDetails.isBackupsetSupported">
		<cv-kendo-grid data-cv-grid-options="dbInsDetails.gridOptions"></cv-kendo-grid>
	</span>
</div>
<div class="row col-md-12 navigation" data-ng-if="dbInsDetails.replicationEntites">
	<div>
		<cv-replication-monitor instance-id="dbInsDetails.instanceId" app-type-id="dbInsDetails.instance.applicationId" replication-entites="dbInsDetails.replicationEntites"> </cv-replication-monitor>
	</div>
</div>