<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.genApp"></cv:cvMessages>
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
	<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.scheduleJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.job"></cv:cvMessages>
	<cv:cvMessages bundle="localization.fs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collectionsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
	<cv:cvMessages bundle="localization.sqlserver"></cv:cvMessages>
	<cv:cvMessages bundle="localization.dbs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.postgres"></cv:cvMessages>
	<cv:cvMessages bundle="localization.mySql"></cv:cvMessages>
	<cv:cvMessages bundle="localization.informix"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
	<cv:cvMessages bundle="localization.db2"></cv:cvMessages>
</script>
<div class="row">
	<div class="col-xs-12">
		<h1 class="page-title" data-ng-bind="entity.subclientName"></h1>
	</div>
</div>
<cv-tab-nav></cv-tab-nav>
<div class="row collectMetaDiv">
	<div class="col-md-6">
		<cv-tile-component data-ac-id="dbCollectionDetails-heading_clientGeneral-clients" data-title='<cv:msg key="heading.clientGeneral" bundle="clients" />' loader="subclientDetails" enable-accordion="true">
			<ul class="group list-style-secondary">

				<cv-tile-label-value data-ng-repeat="serverRow in detailsRow" label="{{serverRow.label}}" value="{{serverRow.data}}" entity-type="{{serverRow.entityType}}" entity="serverRow.entity"> </cv-tile-label-value>

				<cv-activity-control label='<cv:msg key="label.backupEnabled" bundle="clients" />' ac-params="subclientDetails.subClientEntity" enable-backup="subclientDetails.commonProperties.enableBackup" enable-delay ="subclientDetails.commonProperties.enableBackupAfterDelay" delay-time="subclientDetails.commonProperties.enableBackupAtDateTime"> </cv-activity-control>

				<li class="group">
					<cv-plan-select show-edit="true" plan-entity="subclientDetails.planEntity" entity="subclientDetails.subClientEntity" ng-if="subclientDetails"></cv-plan-select>
				</li>
				<li class="group" data-ng-if="subclientDetails && (!subclientDetails.planEntity || !subclientDetails.planEntity.planId) && subclientDetails.commonProperties.storageDevice.dataBackupStoragePolicy.storagePolicyName">
					<span class="pageDetailColumn"><cv:msg key="label.storagePolicy" bundle="capps" /></span>
					<span class="pageDetailColumn" data-ng-bind="subclientDetails.commonProperties.storageDevice.dataBackupStoragePolicy.storagePolicyName"></span>
				</li>

				<li class="group" data-ng-if="subclientDetails">
					<span class="pageDetailColumn"><cv:msg key="label.column.status" bundle="job" /></span>
					<span ng-class="{'green-font': subclientDetails.commonProperties.slaStatus === 1, 'red-font': subclientDetails.commonProperties.slaStatus === 2}">
						<cv-help-text help-label="{{subclientDetails.slaStatus}}" help-text="subclientDetails.statusHelpText"></cv-help-text>
					</span>
				</li>
				<li data-ng-if='subclientDetails.commonProperties.lastBackupTime' class="group"><span class="pageDetailColumn"><cv:msg key="header.lastBackup" bundle="devicesJs" /></span>
					<span class="pageDetailColumn"><div class="time crop" val="{{subclientDetails.commonProperties.lastBackupTime}}"></div></span></li>
				<li class="group"><span class="pageDetailColumn"><cv:msg key="label.lastbackup.size" bundle="collections" /></span>
					<span class="pageDetailColumn" data-ng-bind="subclientDetails.commonProperties.lastBackupSize | capacity"></span></li>
				<li class="group"><span class="pageDetailColumn"><cv:msg key="label.totalbackup.size" bundle="collections" /></span>
					<span class="pageDetailColumn"	data-ng-bind="subclientDetails.commonProperties.totalBackupSize	| capacity"></span></li>
				<li data-ng-if='subclientDetails.commonProperties.nextBackupTime' class="group"><span class="pageDetailColumn"><cv:msg key="header.nextBackup" bundle="devicesJs" /></span>
					<span  class="pageDetailColumn"><div class="time crop"	val="{{subclientDetails.commonProperties.nextBackupTime}}"></div></span></li>
				<li class="group" data-ng-if="subclientDetails.commonProperties.dedupeRatio">
					<span class="pageDetailColumn"><cv:msg key="label.savingsPercentage" bundle="job" /></span>
					<span  class="pageDetailColumn">
						<span data-ng-bind="subclientDetails.commonProperties.dedupeRatio"></span>
						<cv-call-out html-template="savingsPercentageCallOutTemplate"></cv-call-out>
					</span>
				</li>
				<li data-ng-show="showStreams" class="group">
					<span class="pageDetailColumn" data-ng-if="!noOfStreamsHelpText">
						<cv:msg key="label.numberBackupStreams" bundle="oracle" />
					</span>
					<span class="pageDetailColumn" data-ng-if="noOfStreamsHelpText">
						<cv-help-text help-label="{{noOfStreamsLabel}}" help-text="noOfStreamsHelpText"></cv-help-text>
					</span>
					<span class="pageDetailColumn inline-editor" data-ng-hide="editStreams" >
						<label data-ng-bind="dataThresholdStreams" ></label>
						<span class="inline-editor-buttons" data-ng-show="showStreamsEdit">
							<a class="inline-editor-button text" title='<cv:msg key="action.edit" bundle="settingsJs"/>'  data-ng-click="changeStreams('Edit')"><cv:msg key="action.edit" bundle="settingsJs"/></a>
						</span>
					</span>
					<span class="pageDetailColumn inline-editor"	data-ng-show="editStreams" >

						<span class="inline-editor-input">
							<input type="number" data-ng-model="subInfoData.dataThresholdStreams" id="dataStreams" name="dataStreams" min="1" max="100" />
						</span>
						<span class="inline-editor-buttons">
							<a class="inline-editor-button" title='<cv:msg key="Save" bundle="messages" />'  data-ng-click="changeStreams('Save')"><i class="k-icon k-i-check"></i></a>
							<a class="inline-editor-button" title='<cv:msg key="Cancel" bundle="messages" />'  data-ng-click="changeStreams('cancel')"><i class="k-icon k-i-x"></i></a>
						</span>
					</span>

					<span class="server-message error" data-ng-if="editStreams && (!subInfoData.dataThresholdStreams || subInfoData.dataThresholdStreams < 1)" >
						<cv:msg key="error.numberBackupStreams" bundle="oracle" />
					</span>
				</li>
				<cv-capps-capacity data-ng-if="isAmazonDynamoDb && subclientDetails" subclient-details="subclientDetails" type="'READ'"></cv-capps-capacity>

				<!--- MySQL standby option -->
				<span data-ng-if="isStandbyApplicable()">
					<li class="group"><span class="pageDetailColumn"><cv:msg key="label.EnableStandbyBackup" bundle="postgres" /></span>
						<span class="pageDetailColumn">
							<toggle-control class="{{backupEnabledStatusInfo}}" status="subclientDetails.mySqlSubclientProp.proxySettings.isProxyEnabled==true?'enabled-activity':'disabled-activity'" data-ng-click="manageMySqlStandBy(1)" title="Enable/disable <cv:msg key='label.StandbyBackup' bundle='mySql' />"></toggle-control>
						</span>
					</li>
					<li class="group" data-ng-show="subclientDetails.mySqlSubclientProp.proxySettings.isProxyEnabled"><span class="pageDetailColumn"><cv:msg key="label.ProxyInstance" bundle="mySql" /></span>
						<span class="pageDetailColumn" data-ng-bind="standByInstanceDisplayValue"></span>
					</li>
					<li class="group" data-ng-show="subclientDetails.mySqlSubclientProp.proxySettings.isProxyEnabled" ><span class="pageDetailColumn"><cv:msg key="label.UseSource" bundle="mySql" /></span>
						<span class="pageDetailColumn">
							<toggle-control class="{{backupEnabledStatusInfo}}" status="subclientDetails.mySqlSubclientProp.proxySettings.isFailOverToProduction==true?'enabled-activity':'disabled-activity'" data-ng-click="manageMySqlStandBy(2)" title="Enable/disable <cv:msg key='label.UseSource' bundle='mySql' />"></toggle-control>
						</span>
					</li>
				</span>
				<!--- PostgreSQL Collect Object List  -->
				<span data-ng-if="isCollectObjectListApplicable()">
					<li class="group"><span class="pageDetailColumn"><cv:msg key="label.CollectObjectList" bundle="postgres" /></span>
						<span class="pageDetailColumn">
							<toggle-control class="{{backupEnabledStatusInfo}}" status="subclientDetails.postgreSQLSubclientProp.collectObjectListDuringBackup==true?'enabled-activity':'disabled-activity'" data-ng-click="manageCollectObjectList()" title="Enable/disable <cv:msg key='label.CollectObjectList' bundle='postgres' />"></toggle-control>
						</span>
					</li>
				</span>
				<!--- Block level options  -->
				<span data-ng-if="isBlocklevelApplicable()">
					<li class="group"><span class="pageDetailColumn"><cv:msg key="label.blockLevelOption" bundle="postgres" /></span>
						<span class="pageDetailColumn">
							<toggle-control class="{{backupEnabledStatusInfo}}" status="isBlockLevelEnabled==true?'enabled-activity':'disabled-activity'" data-ng-click="manageBlockLevelOptions()" title="Enable/disable <cv:msg key='label.blockLevelOption' bundle='postgres' />"></toggle-control>
						</span>
					</li>
				</span>

				<li class="group" data-ng-if="subclientDetails.subClientEntity.applicationId === AppTypes.SAP_FOR_ORACLE">
					<span class="pageDetailColumn"><cv:msg key="label.backupDevice" bundle="oracle"/></span>
					<div class="pageDetailColumn inline-editor" >
						<span class="inline-editor-text"> {{backupDevice}} </span>
					    <span class="inline-editor-buttons">
					        <a href class="inline-editor-button text" data-ng-click="editBackupDevice()">
					        	<cv:msg key="label.inlineEdit" bundle="messagesJs"/>
					        </a>
					    </span>
					</div>
				</li>
			</ul>
		</cv-tile-component>
		<cv-capps-snap-replication-tile data-ng-if="showSnapRelicationTile" subclient-info="subclientDetails" />
		<%-- <cv-security-component entity-type='entityType' generic-entity = 'entity' associations-loaded="associationsLoaded" associations='formattedSecurityAssociations'>
		</cv-security-component> --%>
		<!--<cv-tile-component data-ac-id="dbCollectionDetails-label_backup-collections" data-title='<cv:msg key="label.backup" bundle="collections" />'>
			<ul class="serverBackupTile">
				<li>
					<span class="page-details-box-links multiLinks">
						<a data-ng-if="showBackup['backup']" data-ng-click="showBackupOptions(entity,flag)" href=""><cv:msg key="action.backupNow" bundle="collections" /></a>
						<a data-ng-href="#jobs?collectionId={{subclientDetails.subClientEntity.subclientId}}&collectionName={{subclientDetails.subClientEntity.subclientName}}&jobType=Backup"><cv:msg key="action.jobs" bundle="servers" /></a>
					</span>
				</li>
				<li data-ng-if="showBackup['backup']">
					<p class="info-place-holder">	<cv:msg key="info.nobackupRunning" bundle="collections" /></p>
				</li>
				<li data-ng-if="showBackup['submittingJob']">
					<p class="info-place-holder"><cv:msg key="info.submittingJob" bundle="collections" /></p>
				</li>
				<li data-ng-if="backupJobs.length>0"><data-cv-job jobs='backupJobs' show-backup='showBackup'></data-cv-job></li>
			</ul>
		</cv-tile-component> -->
		<cv-entity-plan-policy-tiles data-ng-if="showRecoveryPoints && !isAmazonDb && !isAzureDb && !hideStorageAndSchedules" data-cv-show-plan="false" data-cv-application-id="entity.applicationId" data-cv-subclient-id="subclientId" data-cv-client-id="entity.clientId"
				data-cv-subclient-name="entity.subclientName" data-cv-show-edit="true"  data-cv-plan-entity="subclientDetails.planEntity"
				data-cv-show-schedule="subclientDetails" data-cv-show-storage="subclientDetails" data-cv-show-log-storage="isShowLogSP">
		</cv-entity-plan-policy-tiles>
		<div data-ng-if="subclientDetails">
			<cv-sla-client data-entity-data="subclientDetails" data-entity-type="'SUBCLIENT_ENTITY'" data-entity-id="subclientDetails.subClientEntity.subclientId"></cv-sla-client>
		</div>
	</div>
	<div class="col-md-6">
		<cv-backup-history data-ng-if="showRecoveryPoints && recoveryPointsParams" params="recoveryPointsParams" entity="subclientDetails.subClientEntity" on-restore="performRestore(job, selectedNode, toTimeStr)"></cv-backup-history>
		<cv-entity-plan-policy-tiles data-ng-if="!showRecoveryPoints && !hideStorageAndSchedules" data-cv-show-plan="false" data-cv-application-id="entity.applicationId" data-cv-subclient-id="subclientId" data-cv-client-id="entity.clientId"
				data-cv-subclient-name="entity.subclientName" data-cv-show-edit="true"  data-cv-plan-entity="subclientDetails.planEntity"
				data-cv-show-schedule="subclientDetails" data-cv-show-storage="subclientDetails" data-cv-show-log-storage="isShowLogSP">
		</cv-entity-plan-policy-tiles>
		<cv-sql-subclient-settings data-ng-if="showSqlSubclientSettings" generic-entity="entity" mssql-subclient-prop="subclientDetails.mssqlSubClientProp"></cv-sql-subclient-settings>
		<cv-tile-component data-ac-id="dbCollectionDetails-header_content-collections" data-ng-if="showContentTile && !isAmazonDb && !isAzureDb" data-title="{{contentHeader}}" loader="subclientDetails" data-min-height="true">
			<span data-ng-if="subclientDetails" >
				<cv-subclient-content subclient-details="subclientDetails"> </cv-subclient-content>
			</span>
		<div data-ng-if="showSQLFilter" class="content-list-separator">
			<ul data-ng-if="showFilters" data-ng-repeat="exclusion in excludeContentList"
				class="general-list list-style__row group viewContentList full-width__LI">
				<li>
					{{exclusion.excludePath}}
					<span class="parenthetical-text">
						<cv:msg key="indicator.exclusion" bundle="sqlserver" />
					</span>
				</li>
			</ul>
			<ul class="general-list list-style__row group viewContentList full-width__LI">
				<li>
					<a href="" data-ng-click="showFilters=!showFilters">{{showFilters
						? hideFiltersLabel : showFiltersLabel}}</a>
				</li>
			</ul>
		</div>
		</cv-tile-component>
		<cv-tile-component data-ac-id="dbCollectionDetails-oracle-BackupArguments" data-ng-if=" entity.applicationId === AppTypes.ORACLE || isOracleRac"
			data-title="<cv:msg key="label.backupArguments" bundle="oracle" /> " loader="subclientDetails" >
			<ul class="list-style-secondary">
				<li class="group" data-ng-hide="isOracleRac || isOracleArchiveLogSubclient">
					<span class="pageDetailColumn" > <cv:msg key="label.numberBackupStreams" bundle="oracle" /> </span>
					<span class="pageDetailColumn" data-ng-bind="dataThresholdStreams" ></span>
				</li>
				<li class="group">
					<span class="pageDetailColumn" > <cv:msg key="label.maxOpenFiles" bundle="oracle" /> </span>
					<span class="pageDetailColumn" data-ng-bind="subclientDetails.oracleSubclientProp.maxOpenFiles" > </span>
				</li>
				<li class="group" data-ng-hide="isOracleArchiveLogSubclient">
					<span class="pageDetailColumn" ><cv:msg key="label.dataFiles" bundle="oracle" /></span>
					<span class="pageDetailColumn" data-ng-bind="subclientDetails.oracleSubclientProp.dataFilesPerBFS"></span>
				</li>
				<li class="group">
					<span class="pageDetailColumn" > <cv:msg key="label.archiveFiles" bundle="oracle" /></span>
					<span class="pageDetailColumn"  data-ng-bind="subclientDetails.oracleSubclientProp.archiveFilesPerBFS"></span>
				</li>
				<li class="group" data-ng-hide="isOracleArchiveLogSubclient">
					<span class="pageDetailColumn" > <cv:msg key="label.rmanBackupSetSize" bundle="oracle" /> </span>
					<span class="pageDetailColumn"  data-ng-bind="rmanBackupSetSize"  > </span>
				</li>
			</ul>
			<div class="page-details-box-links" >
				<a href="" data-ng-click="editOracleSubclient()"><cv:msg key="action.edit" bundle="settingsJs"/></a>
			</div>
		</cv-tile-component>
		<cv-capps-content-tile data-ng-if="isAmazonDb || isAzureDb" subclient-id="entity.subclientId"></cv-capps-content-tile>

		<%-- <cv-alert-component alerts='alerts'></cv-alert-component> --%>
		<cv-snap-shot-engine-tile data-ng-if="subclientDetails && showSnapEngine  && !isCloudDBInstance" subclient-details="subclientDetails"></cv-snap-shot-engine-tile>
		<prepost-commands-tile ng-if="showPrePostCommands" subclient-details="subclientDetails" subclient-id="entity.subclientId" application-id="entity.applicationId" client-id="entity.clientId"></prepost-commands-tile>
	</div>
</div>
<cv-rac-manage-streams data-ng-if="entity && entity.applicationId == 80" entity="entity">
</cv-rac-manage-streams>
<cv-db2dpf-manage-streams data-ng-if="entity && entity.applicationId == 103" entity="entity" db2dpfdata="db2dpfdata">
</cv-db2dpf-manage-streams>
