<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
		<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
		<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.collectionsJs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.users"></cv:cvMessages>
		<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
		<cv:cvMessages bundle="localization.dbs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.mySql"></cv:cvMessages>
		<cv:cvMessages bundle="localization.sqlServerInstance"></cv:cvMessages>
		<cv:cvMessages bundle="localization.browse"></cv:cvMessages>
</script>
<div class="row">
	<div class="col-xs-12">
		<h1 class="page-title" data-ng-bind="dbBackupSet.entity.backupsetName"></h1>
	</div>
</div>
<cv-tab-nav></cv-tab-nav>
 <div class="row collectMetaDiv">
	<div class="col-md-6">
		<cv-tile-component data-ac-id="dbBackupsetDetails-heading_clientGeneral-clients" data-title='<cv:msg key="heading.clientGeneral" bundle="clients"/>' data-loader="dbBackupSet.backupsetDetails">
			<ul class="list-style-secondary" data-ng-hide="dbBackupSet.entity.applicationId == 103 || dbBackupSet.entity.applicationId == 135 || dbBackupSet.entity.applicationId == 37 || dbBackupSet.entity.applicationId == 62">
					<li class="group">
						<span class="pageDetailColumn"><cv:msg key="label.default" bundle="collections"/></span>
						<span class="pageDetailColumn" data-ng-bind="dbBackupSet.backupSetDetails.commonBackupSet.isDefaultBackupSet | boolToString"></span>
					</li>
					<li class="group">
						<span class="pageDetailColumn"><cv:msg key="label.onDemand" bundle="clients"/></span>
						<span class="pageDetailColumn" data-ng-bind="dbBackupSet.backupsetDetails.commonBackupSet.onDemandBackupset | boolToString"></span>
					</li>
			</ul>
			<ul class="list-style-secondary" data-ng-show="dbBackupSet.entity.applicationId == 135">
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.OsUsername" bundle="saphana"/> </span>
					<span class="pageDetailColumn" data-ng-bind="dbBackupSet.backupsetDetails.sapHanaBackupset.SAPHANAUser.userName"></span>
				</li>
				<li class="group" data-ng-if="!dbBackupSet.backupsetDetails.sapHanaBackupset.isUseHDBStoreKey">
					<span class="pageDetailColumn"><cv:msg key="label.hanaDBUsername" bundle="saphana"/> </span>
					<span class="pageDetailColumn" data-ng-bind="dbBackupSet.backupsetDetails.sapHanaBackupset.dbUser.userName"></span>
				</li>
				<li class="group" data-ng-if="dbBackupSet.backupsetDetails.sapHanaBackupset.isUseHDBStoreKey">
					<span class="pageDetailColumn"><cv:msg key="label.HdbStorekey" bundle="saphana"/> </span>
					<span class="pageDetailColumn" data-ng-bind="dbBackupSet.backupsetDetails.sapHanaBackupset.hdbuserstorekey"></span>
				</li>
			</ul>
			<ul class="list-style-secondary">
				<li class="group" data-ng-show="dbBackupSet.entity.applicationId == 37 || dbBackupSet.entity.applicationId == 62">
					<span class="pageDetailColumn"><cv:msg key="label.dbStorageType" bundle="db2"/></span>
					<span class="pageDetailColumn" data-ng-if="dbBackupSet.backupsetDetails.db2BackupSet.dB2AutoStorage"><cv:msg key="label.dbTypeAuto" bundle="db2"/></span>
					<span class="pageDetailColumn" data-ng-if="!dbBackupSet.backupsetDetails.db2BackupSet.dB2AutoStorage"><cv:msg key="label.dbTypeNonAuto" bundle="db2"/></span>
				</li>
				<li class="group" data-ng-show="dbBackupSet.entity.applicationId == 103">
					<span class="pageDetailColumn"><cv:msg key="label.catalogPartition" bundle="db2"/></span>
					<span class="pageDetailColumn">NODE000{{dbBackupSet.backupsetDetails.db2BackupSet.dB2CatalogPartitionNumber}}</span>
				</li>
				<li class="group" data-ng-show="dbBackupSet.backupsetDetails.db2BackupSet.useSQLConnect && dbBackupSet.isDB2Agent">
					<span class="pageDetailColumn"><cv:msg key="label.userName" bundle="users"/></span>
					<span class="pageDetailColumn" data-ng-bind="dbBackupSet.backupsetDetails.db2BackupSet.db2SqlConnectInfo.userName"> </span>
				</li>
				<li class="group" data-ng-if="dbBackupSet.showPlan">
					<cv-plan-select show-edit="!dbBackupSet.showEdit" plan-entity="dbBackupSet.backupsetDetails.planEntity" entity="dbBackupSet.entity" ></cv-plan-select>
				</li>
				<li class="group" data-ng-if="dbBackupSet.showSP">
					<span class="pageDetailColumn"><cv:msg key="label.logStoragePolicy" bundle="oracle"/></span>
					<span class="pageDetailColumn" data-ng-bind="dbBackupSet.logSP.storagePolicyName"> </span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.lastBackupTime" bundle="storage" /></span>
					<span  data-ng-if="dbBackupSet.backupsetDetails.lastBackupTime" class="pageDetailColumn" data-ng-bind="dbBackupSet.backupsetDetails.lastBackupTime | customDateTime"></span>
                    <span data-ng-if="!dbBackupSet.backupsetDetails.lastBackupTime" class="pageDetailColumn"><cv:msg key="label.neverBackedUp" bundle="serversJs" /></span>
				</li>
				<li class="group" data-ng-if="dbBackupSet.backupsetDetails.totalBackupSize > 0">
					<span class="pageDetailColumn"><cv-help-text help-label="{{'label.totalbackup.size' | cvLoc}}" help-text="'label.totalbackup.text' | cvLoc" /></span>
					<span class="pageDetailColumn" data-ng-bind="dbBackupSet.backupsetDetails.totalBackupSize | capacity"></span>
				</li>
			</ul>
			<div data-ng-show="dbBackupSet.showEdit" class="page-details-box-links">
				<a href="" data-ng-click="dbBackupSet.editBackupset(dbBackupSet.backupsetDetails.backupSetEntity,true,dbBackupSet.backupsetDetails,dbBackupSet.callBackFunction)"><cv:msg key="action.edit" bundle="settingsJs"/></a>
			</div>
		</cv-tile-component>
		<%-- <span >
			<cv-plan-component  app-id="dbBackupSet.entity.applicationId" backup-set-id="dbBackupSet.entity.backupsetId" client-id="dbBackupSet.entity.clientId" plan-entity="dbBackupSet.backupsetDetails.planEntity" highlight-error="false"></cv-plan-component>
		</span> --%>
	</div>
	<div class="col-md-6" data-ng-if="dbBackupSet.entity">
		<cv-backup-history params="dbBackupSet.params" entity="dbBackupSet.entity" on-restore="dbBackupSet.performBackupsetRestore(job, toTimeStr, restoreLevel)"
		show-clone="dbBackupSet.showClone" on-clone="dbBackupSet._performClone(job, fromTimeStr, toTimeStr)"></cv-backup-history>
	</div>
</div>
<div data-ng-if="dbBackupSet.backupsetDetails">
	<cv-db-subclients-component entity="dbBackupSet.entity" plan-entity="dbBackupSet.backupsetDetails.planEntity"> </cv-db-subclients-component>
</div>