<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
	<cv:cvMessages bundle="localization.saphana"></cv:cvMessages>
	<cv:cvMessages bundle="localization.alerts"></cv:cvMessages>
	<cv:cvMessages bundle="localization.sqlserver"></cv:cvMessages>
	<cv:cvMessages bundle="localization.dbs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.db2"></cv:cvMessages>
	<cv:cvMessages bundle="localization.postgres"></cv:cvMessages>
	<cv:cvMessages bundle="localization.mySql"></cv:cvMessages>
</script>
<div class="row">
	<div class="col-md-12">
		<h1 class="float-left" data-ng-bind="instanceDetails.instance.instanceName" data-ng-show="serverMessage.message==''"></h1>
		<span class="server-message {{serverMessage.type}}" data-ng-bind="serverMessage.message"></span>
		<span class="page-action-item spacing-right">
			<span data-ng-if="!isDbThinClient" uib-dropdown class="uib-dropdown"
				on-toggle="toggled(open)">
				<a href class="uib-dropdown-toggle" uib-dropdown-toggle> <span
						class="dropdownArrow right"></span>
					<cv:msg key="MoreActions" />
				</a>
				<ul uib-dropdown-menu>
					<li data-ng-if="instanceDetails">
						<span cv-jobs entity-type='{{entityType}}'
							entity='instanceDetails.instance'>
							<cv:msg key="label.BackupHistory" bundle="clients" />
						</span>
					</li>
					<li data-ng-if="instanceDetails">
						<span cv-jobs entity-type='{{entityType}}' job-type='Restore'
							entity='instanceDetails.instance'>
							<cv:msg key="label.RestoreHistory" bundle="clients" />
						</span>
					</li>
					<li data-ng-if="instanceDetails && showDataMasking()">
						<a href="#dataMasking/{{instanceDetails.instance.instanceId}}"><cv:msg
								key="label.dataMasking" bundle="oracle" /></a>
					</li>
					<li data-ng-if="instanceDetails && showDiscoverDBsOption()">
						<a href=""
							data-ng-click="discoverDatabases(instanceDetails.instance.instanceId)"><cv:msg
								key="label.discoverDatabases" bundle="saphana" /></a>
					</li>
					<li data-ng-if="instanceDetails && showMigrationOption()">
						<a
							href="#appMigration/{{instanceDetails.instance.applicationId}}/{{instanceDetails.instance.instanceId}}"><cv:msg
								key="pageHeader.migrateToCloud" bundle="oracle" /></a>
					</li>
					<li data-ng-if="instanceDetails && !showReconfigure">
						<a href=""
							data-ng-click="deconfigureInstance(instanceDetails.instance)"><cv:msg
								key="action.deconfigure" bundle="storage" /></a>
					</li>
					<li data-ng-if="instanceDetails && showReconfigure">
						<a href=""
							data-ng-click="reconfigureInstance(instanceDetails.instance)"><cv:msg
								key="label.reconfigure" bundle="messagesJs" /></a>
					</li>
					<li data-ng-if="instanceDetails">
						<a href=""
							data-ng-click="deleteInstance(instanceDetails.instance)"><cv:msg
								key="Delete" bundle="messages" /></a>
					</li>
				</ul>
			</span>
		</span>
		<span data-ng-if="isDbThinClient">
			<span data-ng-if="instanceDetails" class="page-action-item" >
				<span cv-jobs  entity-type='{{entityType}}'   entity='instanceDetails.instance' > <cv:msg key="label.BackupHistory" bundle="clients" /> </span>
			</span>
			<span data-ng-if="instanceDetails" class="page-action-item" >
				<span cv-jobs  entity-type='{{entityType}}' job-type='Restore'  entity='instanceDetails.instance' > <cv:msg key="label.RestoreHistory" bundle="clients" /> </span>
			</span>
			<span data-ng-if="instanceDetails" class="page-action-item" >
						  <a href="" data-ng-click="deleteInstance(instanceDetails.instance)"><cv:msg key="Delete" bundle="messages"/></a>
			</span>
		</span>
		<span data-ng-if="showManageClonesOption" ><a class="page-action-item" href="#manageClones/{{instanceDetails.instance.instanceId}}"><cv:msg key="header.manageClones" bundle="oracle" /></a></span>
		<span data-ng-if="showMergeClonesOption" ><a class="page-action-item" href="#sqlInstantClones/{{instanceDetails.instance.clientId}}/{{instanceDetails.instance.instanceId}}"><cv:msg key="header.manageClones" bundle="oracle" /></a></span>
		<span data-ng-if="instanceDetails && showRestoreOption()" ><a href="" data-ng-click="openRestorePage(instanceDetails.instance)" class="page-action-item" ><cv:msg key="header.restore" bundle="serversJs" /></a></span>
	</div>
</div>
<div class="row">
	<div class="col-md-6">
		<cv-tile-component data-ac-id="databaseDetails-heading_clientGeneral-clients" loader="instanceDetails" data-title='<cv:msg key="heading.clientGeneral" bundle="clients" />'>
			<div data-ng-if="instanceDetails" data-ng-init="loadDetails(instanceDetails)" ng-controller="databaseGeneralDetailsCtrl" >
				<ul class="list-style-secondary" >
					<cv-tile-label-value data-ng-repeat="row in rowsInfoList" label="{{row.label}}" value="{{row.data}}"> </cv-tile-label-value>
				</ul>
			</div>
			<div class="page-details-box-links">
				<a href="" data-ng-click="editInstance(instanceDetails.instance,true,instanceDetails)"><cv:msg key="action.edit" bundle="settingsJs"/></a>
			</div>
		</cv-tile-component>
		<%-- <cv-storage-policy data-ng-show="showStorageTile" storage-device ="storageDevice"  node-enity = "instanceDetails.instance"  node-Type = 'INSTANCE_ENTITY' > </cv-storage-policy> --%>
		<cv-sql-cloud-config-component data-ng-if="isAmazonSqlVirtual || isAzureSqlVirtual" sql-prop-loaded="sqlPropLoaded" entity-type='entityType' generic-entity='instanceDetails.instance'
			aws-sql-info='instanceDetails.mssqlInstance.awsSqlInfo' azure-sql-info='instanceDetails.mssqlInstance.azureInfo'
			overwrite-higher-level-settings='overwriteHigherLevelSettings'> </cv-sql-cloud-config-component>
	</div>
	<div class="col-md-6">
		<cv-security-component entity-type='entityType' generic-entity = 'entity' associations-loaded="associationsLoaded" associations='formattedSecurityAssociations'>
		</cv-security-component>
	</div>
	
</div>
	<cv-rac-manage-instances data-ng-if="isOracleRac" entity="instanceDetails.instance" instances="racInstances">
    </cv-rac-manage-instances>
	<span data-ng-if="!isDbThinClient && gridOptions">
		<cv-grid  cv-grid-options="gridOptions"></cv-grid>
	</span>
