<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.dbs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.saphana"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1 data-ng-hide="dataModel.isMetallicSetup">
		<cv:msg key="label.AddDbServers" bundle="dbs" />
		<cv-help-component help-text="<cv:msg key="label.addDBServerHelpText" bundle="dbs" />"></cv-help-component>
	</h1>
	<span data-ng-show="dataModel.isMetallicSetup">
		<h1 data-ng-bind="headingText" >
		</h1>
		<h5 class="text-align-center" >
			<cv:msg key="help.configureSapHanaAccess" bundle="saphana" />
		</h5>
	</span>
</div>
<div class="setup-content medium-width">
	<div data-ng-show="showAddDomainForm">
	<div class="panel panel-default" data-ng-hide="dataModel.isMetallicSetup">
	<div class="panel-body">
	<div class="bootstrap-wrapper form-horizontal padding-bottom-0">
		<div class="form-group" >
			<label class="col-xs-12 col-md-4 col-lg-4" for="dbType"><cv:msg key="label.appType" bundle="dbs" /></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<select id="dbType" name="dbType" data-ng-model="dataModel.dbType" required	data-ng-change="dbTypechange(dataModel.dbType)"	data-ng-options="db.appId as db.name for db in dataModel.dbTypes | orderBy: 'name'">
					<option value=""><cv:msg key="placeholder.dbType" bundle="dbs" /></option>
				</select>
				<span class="help-block" data-ng-show="cv.addServerForm.needsAttention(addServerForm.dbType)"><cv:msg key="error.dbType" bundle="dbs" /></span>
			</div>
		</div>
	</div>
	</div></div>
		<ng-include src="getTemplateUrl(dataModel.dbType)"></ng-include>
	</div>
	<div data-ng-hide="showAddDomainForm" class="button-container centered">
		<p class="serverMessage">{{serversPresentMessage.message}}</p>
		<a type="button" class="extra-spacing" data-ng-click="changeAddDBServer()"><cv:msg key="label.addMore" bundle="servers" /></a>
		<button id="createDatabaseServer_button_#2954" type="button" class="btn btn-default cvBusyOnAjax skip-btn--hidden" data-ng-click="skipSetup()"><cv:msg key="label.continue" bundle="profiles" /></button>
	</div>
</div>
