<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.dbs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1>
		<cv:msg key="pageHeader.addInstance" bundle="dbs" />
	 </h1>
</div>
<div class="setup-content">
	<span class="{{serverMessage.type}}" data-ng-bind="serverMessage.message"></span>
	<form name="addDatabase" novalidate autocomplete="off" class="add-collection-form">
	<div class="form-panel-holder">
		<ng-include src="templateId"></ng-include>
				
	</div>
		<div class="button-container">
	  		<button id="addDatabase_button_#4096" data-ng-hide="showNext" type="button" class="btn btn-default setup-btn--hidden" data-ng-click="preAction()" style="float: left;"><cv:msg key="Back" bundle="messages"/></button> 
	  		<button id="addDatabase_button_#4599" type="button" class="btn btn-default setup-btn--hidden" data-ng-click="closeModal()"><cv:msg key="Cancel" bundle="messages"/></button> 
	  		<button id="addDatabase_button_#7648" data-ng-hide="showNext" type="button" class="btn btn-primary" data-ng-click="createInstance()" > <cv:msg key="Save" bundle="messages"/></button> 
	  		<button id="addDatabase_button_#7430" data-ng-show="showNext" type="button" class="btn btn-primary" data-ng-click="nextAction($event)" > <cv:msg key="Next" bundle="messages"/>  </button> 
	  		
		</div>
	</form>
</div>
<script type="text/ng-template"  id="general_page">
			
			<label>
				<span class=page-detail-column>
					<label for="databaseType">
						<cv:msg key="label.dbType" bundle="dbs"/>
					</label>		
				</span>	
				<span class="page-detail-column select-label float-right">
					<select id="dbType" name="dbType" data-ng-model="model.dbType"
							data-ng-change="changeStepsByVendor(model.dbType)" 
							data-ng-options="db.appId as db.name for db in model.dbTypes | orderBy: 'name'" >
						<option value=""><cv:msg key="placeholder.dbType" bundle="dbs"/></option>
					</select>
				</span>	
				<span class="help-block" data-ng-show="dbTypeError">
					<cv:msg key="error.dbType" bundle="dbs"/>
				</span>
			</label>
			
			<label>
				<span class=page-detail-column>
					<label for="dbServer">
						<cv:msg key="label.dbServerName" bundle="dbs"/> 
					</label>		
				</span>	
				<span class="page-detail-column select-label float-right">
					<select name="dbServer" id="dbServer" 
						data-ng-options="server.id as server.name for server in model.serverList | orderBy:'name'" 
						data-ng-model="model.clientId" class="input"
						ng-change = "dbServerError = !model.clientId ">
						<option value=""><cv:msg key="placeholder.dbServerName" bundle="dbs"/></option>
					</select>
				</span>	
				<span class="help-block" data-ng-show="dbServerError">
					<cv:msg key="error.dbServerName" bundle="dbs"/>
				</span>
			</label>
					
			<label> 
				<span class="page-detail-column"> 
					<label for="instanceName">
						<span>
							<cv:msg key="label.dbInstanceName" bundle="dbs"/>
						</span>	
					</label>	
				</span> 
				<span class="page-detail-column float-right"> 
					<input type="text" id="instanceName" name="instanceName"  
						data-ng-model="model.instanceName" 
						ng-change = "instanceNameError = !model.instanceName"/>
				</span> 
				<span class="help-block" data-ng-show="instanceNameError" >
					<cv:msg key="error.dbInstanceName" bundle="dbs"/>
				</span>
			</label>
			<label> 
			<span class=page-detail-column>
					<label for="plan">
						<cv:msg key="header.storagePolicy" bundle="clients" />
					</label>		
				</span>	
				<span class="page-detail-column select-label float-right">
					<select id="storagePolicy" name="storagePolicy"   data-ng-model="model.storagePolicyId" 
						ng-change = "storagePolicyError = !model.storagePolicyId "
									data-ng-options="sp as sp.storagePolicyName for sp in model.availableStoragePolicies | orderBy:'storagePolicyName'" >
							<option value=""><cv:msg key="label.selectStoragePolicy" bundle="clients"/></option>
						</select>
				</span>	
				<span class="help-block" data-ng-show="storagePolicyError">
					<cv:msg key="error.selectStoragePolicy" bundle="clients" />
				</span>
			</label>
			<%-- <label>
				<span class=page-detail-column>
					<label for="plan">
						<cv:msg key="label.profile" bundle="profiles"/>
					</label>		
				</span>	
				<span class="page-detail-column select-label float-right">
					<select id="plan" name="plan" data-ng-model="model.selectedPlan"
							data-ng-options="profile.planSummary.plan.planId as profile.planSummary.plan.planName for profile in model.profileList | orderBy: 'planSummary.plan.planName'" required
							>
						<option value=""><cv:msg key="placeholder.selectPlan" bundle="profiles"/></option>
					</select>
				</span>	
				<span class="help-block" data-ng-show="planError">
					<cv:msg key="error.selectPlan" bundle="profiles"/>
				</span>
			</label>--%>
	</script>		
		
	
	<script type="text/ng-template"  id="oracle_options_page">
		
			<!--Oracle OS User. -->
			<label> 
				<span class="page-detail-column"> 
					<label for="osUserName">
						<cv:msg key="label.osUserName" bundle="oracle"/>
					</label>
				</span> 
				<span class="page-detail-column float-right"> 
					<input type="text" id="osUserName" name="osUserName" data-ng-model="model.osUserName"
						ng-change = "osUserNameError = !model.osUserName"/>
				</span> 
				<span class="help-block" data-ng-show="osUserNameError" >
					<cv:msg key="error.osUserName" bundle="oracle"/>
				</span>
			</label>
			
			<label > 
				<span class="page-detail-column"> 
					<label for="osPassword">
						<cv:msg key="label.osPassword" bundle="oracle"/>
					</label>	
				</span> 
				<span class="page-detail-column float-right"> 
					<input type="password" id="osPassword" name="ospassword" data-ng-model="model.password"  />
				</span> 
				<%-- <span class="help-block" data-ng-show="cv.addDatabase.needsAttention(addDatabase.osPassword);" >
				<cv:msg key="error.password" bundle="servers"/>
			</span>  --%>
			</label>
		<!--Oracle Home. -->
			<label> 
				<span class="page-detail-column"> 
					<label for="oracleHome">
						<cv:msg key="label.oracleHome" bundle="oracle"/>
					</label>	
				</span> 
				<span class="page-detail-column browse-input-holder float-right"> 
						<input type="text" id="oracleHome" name="oracleHome" 
							ng-change = "oracleHomeError = !model.instInfo.oracleHome"
							data-ng-model="model.instInfo.oracleHome" />
						<cv-machine-browse button-label='<cv:msg key="label.browse" bundle="restore"/>' 
							client-id='{{model.clientId}}' result-function="oraHomeResuleFunction"/>
						<span tooltip-placement="right" uib-tooltip="{{model.instInfo.oracleHome}}"></span>
				</span> 
				<span class="help-block" data-ng-show="oracleHomeError" >
					<cv:msg key="error.oracleHome" bundle="oracle"/>
				</span> 
			</label>
			
			<!--Connection String. -->
			<label>
				<cv:msg key="label.ConnectionString" bundle="oracle" /> 
			</label>	
			<label> 
				<div class="connection-string"> 
					<input id="dbUserName" name="dbUserName" type="text" placeholder="User Name" data-ng-model="model.instInfo.sqlConnect.userName" >
					<label for="dbUserName"> / </label>
					<input id="dbPassword" name="dbPassword" type="password" placeholder='<cv:msg key="label.osPassword" bundle="oracle"/>' data-ng-model="model.instInfo.password" >
					<label for="dbPassword"> @ </label>
					<input id="dbInstanceName" name="dbInstanceName" type="text" placeholder="SID" data-ng-model="model.instInfo.sqlConnect.domainName" >
				</div>
			</label>
			
	</script>	
	
	<script type="text/ng-template"  id="sql_options_page">
		
			<label data-ng-show="sqlserverInfo.overrideHigherLevelsSettings">
						<span class="page-detail-column">
							<input type="radio" id="uselocalSystemAccount" name="uselocalSystemUser" value="1" 
									class="localAccount" data-ng-model="sqlserverInfo.useLocalSystemAccount">
							<label for="uselocalSystemAccount"> <span><cv:msg key="label.useLocalSystemAccount" bundle="sqlserver"/></span></label>			
						</span>
						<span class="page-detail-column float-right">
							<input type="radio" id="uselocalSystemAccountImp" name="uselocalSystemUser" value="2" 
										class="localAccount" data-ng-model="sqlserverInfo.useLocalSystemAccount"
													>
							<label for="uselocalSystemAccountImp"> <span><cv:msg key="label.impersonateUser" bundle="sqlserver"/></span> </label>
						</span>
					</label>
					
					<label data-ng-show = "((sqlserverInfo.useLocalSystemAccount == 2) && (sqlserverInfo.overrideHigherLevelsSettings === true))">
						<span class="page-detail-column element-double-indent-class"><cv:msg key="label.userName" bundle="servers"/></span>
						<span class="page-detail-column float-right">
							<input type="text" name="username"  data-ng-model="sqlserverInfo.username" />					
						</span>
						<span class="help-block" data-ng-show="usernameError" ><cv:msg key="error.userName" bundle="users"/></span>
					</label>
					<label data-ng-show = "((sqlserverInfo.useLocalSystemAccount == 2) && (sqlserverInfo.overrideHigherLevelsSettings === true))">
						<span class="page-detail-column element-double-indent-class"><cv:msg key="label.password" bundle="servers"/></span>
						<span class="page-detail-column float-right">
							<input type="password" name="password"  data-ng-model="sqlserverInfo.password"  />
						</span>
						<span class="help-block" data-ng-show="passwordError" ><cv:msg key="error.password" bundle="users"/></span>
					</label>
			
	</script>	
				