<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<p data-ng-class="addServerMessage.type" class="serverMessage"
	data-ng-bind="addServerMessage.message"></p>
<div data-ng-controller="addDbServerCtrl">
	<form data-ng-show="showAddDomainForm" name="addServerForm" novalidate
		data-cv-submit="addServer()" autocomplete="off"
		class="bootstrap-wrapper form-horizontal">
		<div class="panel panel-default">
			<div class="panel-body">
				<div class="form-group"
					data-ng-show="dataModel.isAgentLessSupported">
					<div class="col-xs-12">
						<toggle-control
							status="dataModel.isAgentLess==true?'enabled-activity':'disabled-activity'"
							data-ng-click="agentLessOptionSelected()"
							title="<cv:msg key="label.agentLessOption" bundle="oracle" />">
						</toggle-control>
						<label for="agentLessOption"> <cv:msg
								key="label.agentLessOption" bundle="oracle" />
						</label>
					</div>
				</div>
				<div class="form-group" data-ng-show="showOsType">
					<label class="col-xs-12 col-md-4 col-lg-4 margin-top-20" for="osTypeWINDOWS"><cv:msg
							key="label.osType" bundle="serversJs" /></label>
					<div class="col-xs-12 col-md-8 col-lg-8">
						<div class="multiple-radio-group">
							<label for="osTypeWINDOWS"><input type="radio"
								id="osTypeWINDOWS" data-ng-model="dataModel.osType"
								value="WINDOWS" name="osType" data-ng-change="osTypeChanged()" />
								<span class="block-indent"><cv:msg
										key="label.osType.windows" bundle="serversJs" /></span></label>
						</div>
						<div class="multiple-radio-group">
							<label for="osTypeUNIX"><input type="radio"
								id="osTypeUNIX" data-ng-model="dataModel.osType" value="UNIX"
								name="osType" data-ng-change="osTypeChanged()" /> <span
								class="block-indent"><cv:msg key="label.osType.unixLinux"
										bundle="serversJs" /></span></label>
						</div>
					</div>
				</div>
				<!-- data-ng-show here -->
				<div class="form-group" data-ng-if="!dataModel.isAgentLess">
					<label class="col-xs-12 col-md-4 col-lg-4 margin-top-15" for="serverName">
						<cv-help-text
							help-label="<cv:msg key="label.dbServerName" bundle="dbs" />"
							help-text="'<cv:msg key='info.databaseServerName' bundle='dbs' />'"></cv-help-text>
					</label>
					<div class="col-xs-12 col-md-8 col-lg-8">
						<div class="input-group">
							<input type="text" name="serverName" id="serverName"
								data-ng-model="dataModel.serverName" ng-blur="addHostName(true)" />
							<span data-ng-disabled="!dataModel.serverName"
								class="input-group-btn"> <span
								class="k-icon k-i-plus cursor-pointer" id="add-host-name"
								title="Add" data-ng-click="addHostName()"></span>
							</span>
						</div>
						<div data-ng-repeat="hostname in dataModel.hostNames"
							class="info-tag">
							<div class="cv-flex">
								<span title="{{hostname}}" class="crop" data-ng-bind="hostname"></span>
								<span> <a
									class="close-icon k-icon k-i-close cursor-pointer"
									data-ng-click="removeHostName($index)"></a>
								</span>
							</div>
						</div>
						<span class="help-block"
							data-ng-show="cv.addServerForm.getAttempted() && errors.showServerName"
							data-ng-bind="errors.showServerNameMesage"> </span>
					</div>
				</div>
				<div class="form-group" data-ng-if="dataModel.isAgentLess">
					<label class="col-xs-12 col-md-4 col-lg-4" for="serverName">
						<cv-help-text
							help-label="<cv:msg key="label.dbServerName" bundle="dbs" />"
							help-text="'<cv:msg key='info.databaseServerName' bundle='dbs' />'"></cv-help-text>
					</label>
					<div class="col-xs-12 col-md-8 col-lg-8">
						<input type="text" name="serverName" id="serverName" data-ng-model="dataModel.serverName" required />
						<span class="help-block" data-ng-show="cv.addServerForm.needsAttention(addServerForm.serverName) || errors.showServerName">
							<span data-ng-hide="errors.showServerName"> <cv:msg key="error.dbServerName" bundle="dbs" /> </span>
							<span data-ng-show="errors.showServerName" data-ng-bind="errors.showServerNameMesage"></span>
						</span>
					</div>
				</div>
				<div class="form-group" data-ng-if="dataModel.isAgentLess">
					<label class="col-xs-12 col-md-4 col-lg-4" for="databaseName">
						<cv:msg key="label.sidValue" bundle="saphana" />
					</label>
					<div class="col-xs-12 col-md-8 col-lg-8">
						<input type="text" id="databaseName" name="databaseName"
							data-ng-model="dataModel.instanceName"
							placeholder='<cv:msg key="label.DatabaseName" bundle="saphana" />'
							required /> <span class="help-block"
							data-ng-show="cv.addServerForm.needsAttention(addServerForm.databaseName)">
							<cv:msg key="error.oracleSid" bundle="oracle" />
						</span>
					</div>
				</div>
				<%-- <div class="form-group" >
			<label class="col-xs-12 col-md-4 col-lg-4" for="storagePolicy">
				<cv:msg key="header.storagePolicy" bundle="clients" />
			</label>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<select id="storagePolicy" name="storagePolicy"	data-ng-model="dataModel.storagePolicyId" required
					data-ng-options="sp.storagePolicyId as sp.storagePolicyName for sp in libraries">
					<option value="">
						<cv:msg key="label.selectStoragePolicy" bundle="clients" />
					</option>
				</select>
				<span class="help-block" data-ng-show="cv.addServerForm.needsAttention(addServerForm.storagePolicy)">
					<cv:msg key="error.selectStoragePolicy" bundle="clients" />
				</span>
			</div>
		</div> --%>
				<!-- fake fields are a workaround for chrome autofill getting the wrong fields and filling it with login credentials for add Server-->
				<input style="display: none" type="text"
					name="fakeusernameremembered" /> <input style="display: none"
					type="password" name="fakepasswordremembered" />
				<div class="form-group" data-ng-if="!dataModel.isAgentLess">
					<label class="col-xs-12 col-md-4 col-lg-4 margin-top-15" for="userName">
						<cv:msg key="label.userName" bundle="servers" />
					</label>
					<div class="col-xs-12 col-md-8 col-lg-8">
						<input type="text" name="userName" id="userName"
							data-ng-model="dataModel.userName" required
							autoCompleteType="disable" autocomplete="none" /> <span
							class="help-block"
							data-ng-show="cv.addServerForm.needsAttention(addServerForm.userName)">
							<cv:msg key="error.userName" bundle="servers" />
						</span>
					</div>
				</div>
				<div class="form-group" data-ng-if="!dataModel.isAgentLess">
					<label class="col-xs-12 col-md-4 col-lg-4" for="password">
						<cv:msg key="label.password" bundle="servers" />
					</label>
					<div class="col-xs-12 col-md-8 col-lg-8">
						<input type="password" name="password" id="password"
							data-ng-model="dataModel.password" required
							autoCompleteType="disable" autocomplete="off" /> <span
							class="help-block"
							data-ng-show="cv.addServerForm.needsAttention(addServerForm.password)">
							<cv:msg key="error.password" bundle="servers" />
						</span>
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-md-4 col-lg-4" for="plan"><cv:msg
							key="label.profile" bundle="profiles" /></label>
					<div class="col-xs-12 col-md-8 col-lg-8"
						data-ng-if="dataModel.profileList">
						<cv-plan-summary-dropdown id="planSummarySelection"
							input-model="dataModel.profileList"
							output-model="dataModel.selectedProfileList" item-label="'name'"
							button-label="'name'" tick-property="'selected'"
							translation="localLang" group-property="'msGroup'"
							helper-elements="'filter'" selection-mode="'single'"
							on-close="parseIStevenOutput()"> </cv-plan-summary-dropdown>
						<span class="help-block"
							data-ng-show="cv.addServerForm.getAttempted() && showPlanError">
							<cv:msg key="error.selectPlan" bundle="profiles" />
						</span>
					</div>
				</div>
				<div class="form-group"
					data-ng-if="dataModel.osType === 'UNIX' && !dataModel.isAgentLess">
					<label class="col-xs-12 col-md-4 col-lg-4" for="uGroup"> <cv-help-text
							help-label="<cv:msg key="label.unixGroup" bundle="oracle" />"
							help-text="'<cv:msg key="help.unixGroup" bundle="oracle" />'"></cv-help-text>
						<span class="optional-text"><cv:msg key="label.optional"
								bundle="restore" /></span>
					</label>
					<div class="col-xs-12 col-md-8 col-lg-8">
						<input type="text" name="uGroup" id="uGroup"
							data-ng-model="dataModel.unixGroup" />
					</div>
				</div>
				<div class="form-group"
					data-ng-if="dataModel.isDB2Client && !dataModel.isAgentLess">
					<label class="col-xs-12 col-md-4 col-lg-4" for="db2Path"> <cv-help-text
							help-label="<cv:msg key="label.db2LogPath" bundle="db2" />"
							help-text="'<cv:msg key="help.db2LogPath" bundle="db2" />'"></cv-help-text>
					</label>
					<div class="col-xs-12 col-md-8 col-lg-8">
						<input type="text" name="db2Path" id="db2Path"
							data-ng-model="dataModel.db2LogPath" required /> <span
							class="help-block"
							data-ng-show="cv.addServerForm.needsAttention(addServerForm.db2Path)"><cv:msg
								key="error.db2LogPath" bundle="db2" /></span>
					</div>
				</div>

				<div class="form-group">
					<label class="col-xs-12 col-md-4 col-lg-4 margin-top-15"
						for="installLocation"> <cv:msg key="label.installLocation"
							bundle="serversJs" /> <span class="optional-text"><cv:msg
								key="label.optional" bundle="restore" /></span>
					</label>
					<div class="col-xs-12 col-md-8 col-lg-8">
						<input type="text" name="installLocation" id="installLocation"
							data-ng-model="dataModel.installDirectory"
							data-ng-change="validateInstallDirPath()"
							placeholder='<cv:msg key="label.enterInstallLocation" bundle="serversJs"/>' "/>
						<span class="cv-help-block"
							data-ng-show="errors.installDirectory.invalidPath"><cv:msg
								key="error.installLocation" bundle="serversJs" /></span>
					</div>
				</div>
				<uib-accordion close-others="false" class="text-left" data-ng-if="!dataModel.isAgentLess && dataModel.dbType == 81 ">
				<div uib-accordion-group is-open="sqlAccountAccordionStatus"
					class="panel form-panel-holder" data-scroll-to-when-open>
					<uib-accordion-heading> <cv-help-text
								help-label="<cv:msg key="label.sqlServerAccount" bundle="sqlserver" />"
								help-text="'<cv:msg key="info.sqlServerAccount" bundle="sqlserver" />'"></cv-help-text><span
							class="optional-text">
							<cv:msg key="label.optional" bundle="users" />
						</span><i
						class="float-right glyphicon"
						data-ng-class="{'glyphicon-chevron-down': sqlAccountAccordionStatus, 'glyphicon-chevron-right': !sqlAccountAccordionStatus}"></i>
					</uib-accordion-heading>

<!-- 					<div class="form-group"> -->
<!-- 						<span class="col-xs-12 col-md-5 col-lg-5"> <label -->
<!-- 							class="radio"> <input type="radio" -->
<!-- 								id="uselocalSystemAccount" name="uselocalSystemUser" value="1" -->
<!-- 								class="localAccount" -->
<%-- 								data-ng-model="sqlserverInfo.useLocalSystemAccount"> <cv:msg --%>
<%-- 									key="label.useLocalSystemAccount" bundle="sqlserver" /> --%>
<!-- 						</label> -->
<!-- 						</span> <span class="col-xs-12 col-md-7 col-lg-7"> <label -->
<!-- 							class="radio"> <input type="radio" -->
<!-- 								id="uselocalSystemAccountImp" name="uselocalSystemUser" -->
<!-- 								value="2" class="localAccount" -->
<%-- 								data-ng-model="sqlserverInfo.useLocalSystemAccount"> <cv:msg --%>
<%-- 									key="label.impersonateUser" bundle="sqlserver" /> --%>
<!-- 						</label> -->
<!-- 						</span> -->
<!-- 					</div> -->

					<div class="form-group">
						<label class="col-xs-12 col-md-5 col-lg-5"> <cv:msg
								key="label.userName" bundle="servers" />
						</label> <span class="col-xs-12 col-md-7 col-lg-7"> <input
							type="text" name="sqlServerUserName" id="sqlServerUserName"
							data-ng-model="dataModel.sqlServerUserName"
							data-ng-change="sqlserverInfo.inputAlertFlags.username=false"
							placeholder="<cv:msg key="error.userName" bundle="users" />" />
							<span class="help-block" data-ng-if="sqlserverInfo.inputAlertFlags.username">
								<cv:msg key="error.userName" bundle="users" />
						</span>
						</span>
					</div>
					<div class="form-group">
						<label class="col-sm-5"> <cv:msg key="label.password"
								bundle="servers" />
						</label> <span class="col-sm-7"> <input type="password" id="sqlServerPassword"
							name="sqlServerPassword" data-ng-model="dataModel.sqlServerPassword"
							data-ng-change="sqlserverInfo.inputAlertFlags.password=false" 
							placeholder="<cv:msg key="error.password" bundle="users" />"/>
							<span class="help-block" data-ng-if="sqlserverInfo.inputAlertFlags.password">
								<cv:msg key="error.password" bundle="users" />
						</span>
						</span>
					</div>

				</div>
				</uib-accordion>

				<div class="form-group" data-ng-if="dataModel.isAgentLess">
					<label class="col-xs-12 col-md-4 col-lg-4" for="physicalClients"><cv:msg
							key="label.proxies" bundle="sqlserver" /></label>
					<div class="col-xs-12 col-md-8 col-lg-8">
						<isteven-multi-select input-model="physicalClients"
							button-label="clientName" item-label="clientName"
							tick-property="ticked"
							class="isteven-multi-select user-group-select"
							id="physicalClients" name="physicalClients"
							helper-elements="all none reset filter" max-labels="1"
							translation="localLang1"
							on-item-click="validateClientSelection()"
							on-select-none="validateClientSelection()"
							on-select-all="validateClientSelection()"
							on-reset="validateClientSelection()" ng-cloak>
						</isteven-multi-select>
						<span class="help-block" data-ng-show="showAddServerErrorMessage"><cv:msg
								key="placeholder.dbPhysicalClients" bundle="dbs" /></span>
					</div>
				</div>
			</div>
		</div>
		<!-- //closes panels classes // -->
		<div class="button-container">
			<button id="addDBServerTemplate_button_#6231" type="button"
				data-ng-if="!isSetup" class="btn btn-default setup-btn--hidden"
				data-ng-click="closeModal()">
				<cv:msg key="Cancel" bundle="messages" />
			</button>
			<button id="addDBServerTemplate_button_#9572" type="button"
				data-ng-if="isSetup" class="btn btn-default cvBusyOnAjax"
				data-ng-click="skipSetup()">
				<cv:msg key="action.doItLater" bundle="profiles" />
			</button>
			<button id="addDBServerTemplate_button_#9428" type="submit"
				class="btn btn-primary cvBusyOnAjax">
				<span data-ng-if="!showDoItLater"><cv:msg key="Add"
						bundle="messages" /> </span> <span data-ng-if="showDoItLater"><cv:msg
						key="Finish" bundle="messages" /> </span>
			</button>
		</div>
	</form>
</div>