(function() {
	'use strict';

	var siMod = angular.module('siApp', [
		'ngRoute',
		'chieffancypants.loadingBar',
		'ui.bootstrap',
		'cvCommon',
		'ui.router',
		'ngSanitize'
	]);

	siMod.config([
		'$provide',
		function($provide) {
			$provide.decorator('$state', [
				'$delegate',
				'$stateParams',
				function($delegate, $stateParams) {
					$delegate.forceReload = function() {
						return $delegate.go($delegate.current, $stateParams, {
							reload: true,
							inherit: false,
							notify: true
						});
					};
					return $delegate;
				}
			]);
		}
	]);

	siMod.config([
		'$httpProvider',
		function($httpProvider) {
			$httpProvider.defaults.headers.post['Content-Type'] = 'application/x-www-form-urlencoded;charset=utf-8';

			// Override $http service's default transformRequest
			$httpProvider.defaults.transformRequest = [
				function(data) {
					/**
					 * The workhorse; converts an object to x-www-form-urlencoded serialization.
					 *
					 * @param {Object}
					 *            obj
					 * @return {String}
					 */
					var param = function(obj) {
						var query = '';
						var name, value, fullSubName, subName, subValue, innerObj, i;

						for (name in obj) {
							value = obj[name];

							if (value instanceof Array) {
								for (i = 0; i < value.length; ++i) {
									subValue = value[i];
									fullSubName = name + '[' + i + ']';
									innerObj = {};
									innerObj[fullSubName] = subValue;
									query += param(innerObj) + '&';
								}
							} else if (value instanceof Object) {
								for (subName in value) {
									subValue = value[subName];
									fullSubName = name + '[' + subName + ']';
									innerObj = {};
									innerObj[fullSubName] = subValue;
									query += param(innerObj) + '&';
								}
							} else if (value !== undefined && value !== null) {
								query += encodeURIComponent(name) + '=' + encodeURIComponent(value) + '&';
							}
						}

						return query.length ? query.substr(0, query.length - 1) : query;
					};

					return angular.isObject(data) && String(data) !== '[object File]' ? param(data) : data;
				}
			];

			$httpProvider.interceptors.push([
				'$q',
				'$location',
				'cvUtil',
				function($q, $location, cvUtil) {
					return {
						responseError: function(response) {
							if (response.status === 401) {
								response.data = {
									status: false,
									description: 'Authentication required!'
								};
								window.location = window.location.origin + '/' + window.location.pathname + '/login';
								return response;
							}
							return $q.reject(response);
						},
						request: function(config) {
							var csrfParam = cvUtil.readCookie('csrf');
							config.headers['csrf'] = csrfParam;
							return config;
						}
					};
				}
			]);
		}
	]);

	siMod.config([
		'$stateProvider',
		'$urlRouterProvider',
		function($stateProvider, $urlRouterProvider) {
			$urlRouterProvider.otherwise('/sysInfo');

			$stateProvider
				.state('index', {
					url: '/sysInfo',
					templateUrl: 'sysInfo.jsp',
					controller: 'sysInfoController'
				})
				.state('config', {
					url: '/config',
					templateUrl: 'config.jsp',
					controller: 'configController'
				})
				.state('logs', {
					url: '/logs',
					templateUrl: 'logs.jsp',
					controller: 'logsController'
				})
				.state('protocoltest', {
					url: '/protocolTest',
					templateUrl: 'protocolTest.jsp',
					controller: 'protocolTestController'
				});
		}
	]);

	siMod
		.controller('sysInfoController', [
			'$scope',
			'sysInfoService',
			function($scope, sysInfoService) {
				$scope.title = 'System Info';
				$scope.message = '';
				$scope.serviceStatus = '';
				sysInfoService
					.getSysInfo()
					.success(function(data) {
						$scope.sysInfo = data;
					})
					.error(function() {
						$scope.message = 'Failed to load sys info';
					});

				$scope.checkStatus = function() {
					$scope.serviceStatus = '';
					$scope.serviceStatusString = '';
					sysInfoService
						.checkWebServiceStatus()
						.success(function() {
							$scope.serviceStatus = 'Up';
							$scope.serviceStatusString = 'Service is up';
						})
						.error(function(data, status, headers, config) {
							$scope.serviceStatus = 'Down';
							$scope.serviceStatusString = 'Service is down';
						});
				};
			}
		])
		.controller('configController', [
			'$scope',
			'configService',
			'cvToaster',
			function($scope, configService, cvToaster) {
				$scope.title = 'Configuration';
				$scope.message = '';

				configService
					.getConfig()
					.success(function(data) {
						$scope.config = data;
					})
					.error(function() {
						$scope.message = 'Failed to load config';
					});

				$scope.updateProp = function(k, v) {
					$scope.message = '';
					configService
						.updateConfig(k, v)
						.success(function(data) {
							cvToaster.showSuccessMessage({
								ttl: '10000', //10 sec
								message: 'Config successfully set'
							});
						})
						.error(function() {
							cvToaster.showErrorMessage({
								ttl: '10000', //10 sec
								message: 'Failed to set config'
							});
						});
				};
			}
		])
		.controller('logsController', [
			'$scope',
			function($scope) {
				$scope.title = 'Logs';
				$scope.tailOn = true;

				$scope.$watch('tailOn', function(nv, ov) {
					if (!nv && socket != null) {
						socket.disconnect();
						socket = null;
					} else {
						if (!socket || socket == null) {
							init();
						}
					}
				});

				var socket = null;

				var init = function() {
					var request = {
						url: '/AdminConsole/ws?logFile=adminConsole',
						contentType: 'application/json',
						transport: 'websocket',
						reconnectInterval: 5000,
						enableXDR: true,
						timeout: 60000
					};
					var tx = angular.element('#tail');
					request.onMessage = function(response) {
						var responseBody = response.responseBody;
						console.debug('Applying..');

						if (tx) {
							var currVal = tx.val();
							if (currVal.length >= 20000) {
								var respLen = responseBody.length;
								var toBeExtracted = respLen - 20000;
								if (toBeExtracted > 0) {
									currVal = currVal.substr(toBeExtracted);
								}
							}
							tx.val(currVal + responseBody);
							tx.scrollTop(tx[0].scrollHeight - tx.height());
						} else {
							tx = angular.element('#tail');
						}
					};
					socket = atmosphere.subscribe(request);
				};
				if (!socket || socket == null) {
					init();
				}
			}
		])
		.controller('protocolTestController', [
			'$scope',
			'protocolTestService',
			function($scope, protocolTestService) {
				$scope.title = 'Protocol Test';
				$scope.message = '';
				$scope.model = {
					contentType: 'application/xml',
					accept: 'application/json'
				};
				$scope.testApi = function() {
					protocolTestService.testapi(
						this.model,
						function(data) {
							if (data.error != undefined) {
								$scope.model.response = data.error;
							} else {
								$scope.model.response = data.response;
							}
						},
						function(e) {
							$scope.model.response = e;
						}
					);
				};
			}
		]);

	siMod
		.service('sysInfoService', [
			'$http',
			function($http) {
				this.getSysInfo = function() {
					return $http.get('sysInfo.do');
				};

				this.checkWebServiceStatus = function() {
					return $http.get('webServiceStatus.do');
				};
			}
		])
		.service('configService', [
			'$http',
			function($http) {
				this.getConfig = function() {
					return $http.get('cvConfig.do');
				};

				this.updateConfig = function(k, v) {
					return $http.post('cvConfig.do', {
						key: k,
						val: v
					});
				};
			}
		])
		.service('logsService', [
			'$scope',
			function($scope) {
				$scope.title = 'Logs';
			}
		])
		.service('protocolTestService', [
			'$http',
			function($http) {
				this.testapi = function(data, successcallBack, errorcallback) {
					return $http
						.post('protocolTest.do', {
							api: data.api,
							contentType: data.contentType,
							accept: data.accept,
							headers: data.headers,
							method: data.method,
							request: data.request
						})
						.success(successcallBack)
						.error(errorcallback);
				};
			}
		]);
})();
