<%
    response.setHeader("Cache-Control", "no-cache");
    response.setDateHeader("Expires", 0);
%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<html>
<head>
<title>AdminConsole SysInfo</title>
<link rel="stylesheet" href="${pageContext.request.contextPath}/common/css/template.css?${applicationScope.BUILD_TS}">
<jsp:include page="common/favicon.jsp"></jsp:include>

<style>
    body, td, th, div, span {
        font-family: Helvetica, Arial, Verdana;
        font-size: 16px;
        overflow-wrap: break-word;
    }
    
    td {
        word-break: break-all;
    }
    
    th {
    	min-width: 200px;
    }
    
    table.inner div {
	    max-height: 300px;
	    overflow: scroll;
	    display: relative;
	}
	
	.collapse-toggle {
		display: absolute;
		right: 10px;
		top: 5px;
	}
</style>
<script src="${pageContext.request.contextPath}/lib/jquery/jquery.min.js?${applicationScope.BUILD_TS}"></script>
<script nonce="${sessionScope.cspNonce}">
	var pretty = true;
	var deep = false;
    $(document).ready(function(){
    	var getObjStr = function(obj) {
    		if(obj == '[object Object]') {
    			return deep ? getTable(JSON.stringify(obj)) : "<div><pre>" + JSON.stringify(obj, null, 2) + "</pre></div>";
    		}
    		return obj;
    	};
    	
    	var getTable = function(json){
    		var object = JSON.parse(json);
    		var table = "<table class='table inner'>";
    		for(o in object){
    			table += "<tr><th>" + o + "</th><td>" + getObjStr(object[o]) + "</td></tr>";
    		}
    		table += "</table>";
    		return table;
    	};
    	
    	var getRow = function(cookie) {
    		return "<tr><td>" + cookie["name"] + "</td><td><div>" + cookie["value"] + "</div></td><td>" + cookie["secure"] + "</td><td>" + cookie["httpOnly"] + "</td></tr>";	
    	};
    	
    	var getCookiesTable = function(json){
    		var cookies = JSON.parse(json);
    		var table = "<table class='table inner cookie-table'>";
    		table += "<thead><tr><th>Name</th><th>Value</th><th>Secure</th><th>HTTPOnly</th></tr></thead><tbody>";
    		for(i=0;i<cookies.length;i++) {
    			table += getRow(cookies[i]);
    		}
    		table += "</tbody></table>";
    		return table;
    	};
    	
    	$(".content-json").each(function(i,e){
    		var ele = $(e);
    		var json = ele.html();
    		var table = ele.hasClass('cookies') ? getCookiesTable(json) : getTable(json); 
    		ele.html(table);
    	});
    });
</script>
</head>
<body>
	<div class="container">
    <c:if test="${requestScope.sysInfo.canDisplay == true}">
	    <table class="table responsive">
	        <tr>
	            <th colspan="2" style="text-align:center"><h1>AdminConsole SysInfo</h1><h3>${requestScope.sysInfo.BUILD_INFO}</h3></th>
	        </tr>
	        <tr class="info">
	            <th>Web Service</th>
	            <td><a href="${requestScope.sysInfo.BASE_URL}" target="_blank">${requestScope.sysInfo.BASE_URL}</a></td>
	        </tr>
	        <tr class="info">
	            <th>System Path</th>
	            <td>${requestScope.sysInfo.BASE_PATH}</td>
	        </tr>
	        <tr class="info">
	            <th>Application Params</th>
	            <td class="content-json">
	                ${requestScope.sysInfo.APPLICATION_PARAMS}
	            </td>
	        </tr>
	        <tr class="info">
	            <th>Session Attributes</th>
	            <td class="content-json">${requestScope.sysInfo.SESSION_INFO}</td>
	        </tr>
	        <tr class="info">
	            <th>Cookies</th>
	            <td class="content-json cookies">
	                ${requestScope.sysInfo.COOKIES}
	            </td>
	        </tr>
	        <tr class="info">
	            <th>Headers</th>
	            <td class="content-json">${requestScope.sysInfo.HEADERS}</td>
	        </tr>
	        
	   		 <tr class="info">
	            <th valign="top">Basic Memory Info</th>
	            <td>
	                <b>Heap Size</b>: ${requestScope.sysInfo.HEAP_SIZE}<br/>
	                <b>Max Size</b>: ${requestScope.sysInfo.MAX_HEAP_SIZE}<br/>
	                <b>Available Size</b>: ${requestScope.sysInfo.AVAILABLE_MEM}<br/>
	                <div class="detailedMemInfo">${requestScope.sysInfo.DETAILED_MEM_INFO}</div>
	            </td>
	        </tr>
	       
	        <tr class="info">
	            <th>JVM Info</th>
	            <td>
	                <div class="detailedJvmInfo">${requestScope.sysInfo.JVM_INFO}</div>
	            </td>
	        </tr>     
	    </table>
	</c:if>
	</div>
</body>
</html>