<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.messages">
	<html>

<head>
<meta charset="utf-8" />
<jsp:include page="common/favicon.jsp"></jsp:include>
<style>
body {
	background: #F4F4F4;
	-moz-background-size: cover;
	background-size: cover;
	font-family: 'Roboto', sans-serif;
}

.center {
	width: 50%;
	margin: auto;
	position: fixed;
	top: 47%;
	left: 50%;
	transform: translate(-50%, -50%);
}

.msgstyle {
	font-size: 1.5rem;
	color: #555;
}
</style>
</head>

<body>
	<div class="msgstyle center">
		<fmt:message key="readinessFilter.message.wait" /><span id="timer"></span>
	</div>

	<script nonce="${sessionScope.cspNonce}">
		var timer = 4;
		var dots = '';
		var timerTask = window.setInterval(function() {
			timer--;
			dots += '.';
			if (!timer) {
				clearTimeout(timerTask);
				window.location.reload();
			} else {
				document.getElementById("timer").textContent = dots;
			}
		}, 2000);
	</script>

</body>
	</html>
</fmt:bundle>