<%@ page isErrorPage="true"%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib prefix="enhance" uri="http://pukkaone.github.com/jsp" %>
<!DOCTYPE html>
<html>

<head>
	<meta charset="utf-8" />
	<title><fmt:message key="Exception_Title" /></title>
	<link rel="stylesheet" href="${pageContext.request.contextPath}/common/css/serverDown.css?${applicationScope.BUILD_TS}" />
	<jsp:include page="common/favicon.jsp"></jsp:include>

	<style>
	*, *:before, *:after {
		-webkit-box-sizing: border-box;
		-moz-box-sizing: border-box;
		box-sizing: border-box;
	}

	body {
		background: #F4F4F4;
		-moz-background-size: cover;
		background-size: cover;
		font-family: 'Roboto', sans-serif;
		margin: 0px;
	}

	html, body {
		margin: 0;
	}

	.server-img {
	  width:100%;
	  text-align: center;
	  background-color: #0B2E44;
	}

	.svg-size {
	  width:80% ;
	  max-width: 800px;
	}

	.background {
	  fill: #0B2E44;
	}
	.server-img-total{
	  position: relative;
	  width:100%;
	  margin-top:60px;
	  margin-bottom:20px;
	}
	.main-color {
	  fill : #ddd;
	}

	.warning-traingle {
	  fill:#f2e44c;
	}

	.error-server{
	  fill:#ee3124;
	}

	.server-img .circle {
	  animation: blink 1s step-end infinite;
	  -webkit-animation:blink 1s step-end infinite;
	}

	.server-img.circle-img{
	  position: absolute;
	  left:0;
	  top:0;
	  background: none;
	}

	@keyframes blink {
	    0%{
	    opacity: 1;
	    }
	    50% {
	      opacity: 0;
	    }

	    100%{
	      opacity: 1;
	    }
	}
	@-webkit-keyframes blink {
	  0%{
	  opacity: 1;
	  }
	  50% {
	    opacity: 0;
	  }

	  100%{
	    opacity: 1;
	  }
	}


	.server-down-wrapper {
		margin: 0 auto;
		width: 71%;
		max-width: 750px;
	}


	.server-down-wrapper .admin-message {
		color:#888;
		border-top: 1px solid #ccc;
		margin-top: 15px;
	}

	.server-down-wrapper > div:first-child {
		color:#0B2E44;
		font-size: 25px;
		word-break: break-word;
	}

	.user-message {
		margin-top: 23px;
	}

	.followupText {
		margin-top: 10px;
	}

	.user-message > div{
		margin-top:10px;
	}

	.server-down-wrapper p {
		margin: 0;
	}

	.admin-message > p {
		margin : 10px 0;
	}

	a {
		color: #069;
	    cursor: pointer;
	    text-decoration: none;
	}
	a:hover {
	    text-decoration: underline;
	}
	</style>

</head>

<body>

	<c:set var="details" value="${sessionScope.SERVER_ERROR_DETAILS}"/>
	  <div class="server-img-total">
	  <div class="server-img">
	<svg class="svg-size" xmlns="http://www.w3.org/2000/svg"  viewBox="0 0 930 290">
	  <rect class="main-color" x="731.69" y="69.59" width="6.37" height="19.54"/>
	  <rect class="main-color" x="718.24" y="70.01" width="6.37" height="19.54"/>
	  <rect class="main-color" x="745.14" y="69.59" width="6.37" height="19.54"/>
	  <rect class="main-color" x="731.69" y="114.19" width="6.37" height="19.54"/>
	  <rect class="main-color" x="718.24" y="114.62" width="6.37" height="19.54"/>
	  <rect class="main-color" x="745.14" y="114.19" width="6.37" height="19.54"/>
	  <rect class="main-color" x="731.69" y="157.52" width="6.37" height="19.54"/>
	  <rect class="main-color" x="718.24" y="157.95" width="6.37" height="19.54"/>
	  <rect class="main-color" x="745.14" y="157.52" width="6.37" height="19.54"/>
	  <path class="main-color" d="M887,213.66h-3.54v-3.4H887a10,10,0,0,0,1.3-.08l.43,3.37A13.43,13.43,0,0,1,887,213.66Zm-8.59,0h-5.05v-3.4h5.05Zm15.71-2.07-1.77-2.88a10.34,10.34,0,0,0,3.09-3.05l2.78,1.88A13.73,13.73,0,0,1,894.13,211.59Zm6.18-9.48-3.3-.53a10.63,10.63,0,0,0,.12-1.61v-3.25h3.34V200A14,14,0,0,1,900.31,202.11Zm.16-10.53h-3.34v-5.14h3.34Zm0-10.28h-3.34v-3.23a10.62,10.62,0,0,0-.13-1.64l3.3-.53a14.06,14.06,0,0,1,.17,2.17Zm-5-8.93a10.34,10.34,0,0,0-3.1-3l1.76-2.89a13.73,13.73,0,0,1,4.11,4Zm-7.15-4.51a10.17,10.17,0,0,0-1.28-.08h-3.56v-3.4H887a13.41,13.41,0,0,1,1.7.11Zm-9.9-.08h-5.05v-3.4h5.05Z" transform="translate(0.22 0.65)"/>
	  <path class="main-color" d="M886.95,124.16H883.4v-3.4h3.55a10.11,10.11,0,0,0,1.31-.08l.43,3.37A13.54,13.54,0,0,1,886.95,124.16Zm-8.63,0h-5.08v-3.4h5.08Zm15.78-2.07-1.78-2.88a10.37,10.37,0,0,0,3.1-3.05l2.8,1.88A13.76,13.76,0,0,1,894.1,122.1Zm6.21-9.48-3.32-.53a10.59,10.59,0,0,0,.12-1.61v-3.25h3.36v3.25A14,14,0,0,1,900.31,112.62Zm.16-10.53h-3.36V96.94h3.36Zm0-10.28h-3.36V88.58a10.58,10.58,0,0,0-.13-1.64l3.31-.53a14,14,0,0,1,.17,2.17Zm-5.06-8.93a10.37,10.37,0,0,0-3.11-3l1.77-2.89a13.76,13.76,0,0,1,4.13,4Zm-7.18-4.51a10.25,10.25,0,0,0-1.29-.08h-3.58v-3.4h3.58a13.52,13.52,0,0,1,1.7.11Zm-9.94-.08h-5.08v-3.4h5.08Z" transform="translate(0.22 0.65)"/>
	  <path class="main-color" d="M868.4,99.12H713.11a6.35,6.35,0,0,1-6.35-6.35V65.94a6.35,6.35,0,0,1,6.35-6.35H868.4a6.35,6.35,0,0,1,6.35,6.35V92.77A6.35,6.35,0,0,1,868.4,99.12ZM713.11,61.29a4.65,4.65,0,0,0-4.65,4.65V92.77a4.65,4.65,0,0,0,4.65,4.65H868.4A4.65,4.65,0,0,0,873,92.77V65.94a4.65,4.65,0,0,0-4.65-4.65Z" transform="translate(0.22 0.65)"/><path class="main-color" d="M868.4,142.45H713.11a6.35,6.35,0,0,1-6.35-6.35V109.27a6.35,6.35,0,0,1,6.35-6.35H868.4a6.35,6.35,0,0,1,6.35,6.35V136.1A6.35,6.35,0,0,1,868.4,142.45ZM713.11,104.62a4.65,4.65,0,0,0-4.65,4.65V136.1a4.65,4.65,0,0,0,4.65,4.65H868.4A4.65,4.65,0,0,0,873,136.1V109.27a4.65,4.65,0,0,0-4.65-4.65Z" transform="translate(0.22 0.65)"/><path class="main-color" d="M868.4,185.78H713.11a6.35,6.35,0,0,1-6.35-6.35V152.6a6.35,6.35,0,0,1,6.35-6.35H868.4a6.35,6.35,0,0,1,6.35,6.35v26.83A6.35,6.35,0,0,1,868.4,185.78ZM713.11,148a4.65,4.65,0,0,0-4.65,4.65v26.83a4.65,4.65,0,0,0,4.65,4.65H868.4a4.65,4.65,0,0,0,4.65-4.65V152.6A4.65,4.65,0,0,0,868.4,148Z" transform="translate(0.22 0.65)"/><path class="main-color" d="M868.4,229.11H713.11a6.35,6.35,0,0,1-6.35-6.35V195.93a6.35,6.35,0,0,1,6.35-6.35H868.4a6.35,6.35,0,0,1,6.35,6.35v26.83A6.35,6.35,0,0,1,868.4,229.11ZM713.11,191.28a4.65,4.65,0,0,0-4.65,4.65v26.83a4.65,4.65,0,0,0,4.65,4.65H868.4a4.65,4.65,0,0,0,4.65-4.65V195.93a4.65,4.65,0,0,0-4.65-4.65Z" transform="translate(0.22 0.65)"/><circle class="main-color" cx="855.66" cy="80.63" r="9.35"/><circle class="main-color" cx="855.66" cy="123.96" r="9.35"/><circle class="main-color" cx="855.66" cy="167.51" r="9.35"/><circle class="main-color" cx="855.66" cy="210.62" r="9.35"/>
	  <rect class="main-color" x="758.6" y="69.59" width="6.37" height="19.54"/>
	  <rect class="main-color" x="758.6" y="114.19" width="6.37" height="19.54"/>
	  <rect class="main-color" x="772.83" y="114.19" width="6.37" height="19.54"/>
	  <rect class="main-color" x="758.6" y="157.52" width="6.37" height="19.54"/>
	  <rect class="main-color" x="758.6" y="201.07" width="6.37" height="19.54"/>
	  <rect class="main-color" x="773.46" y="201.07" width="6.37" height="19.54"/>
	  <rect class="main-color" x="787.91" y="200.85" width="6.37" height="19.54"/>
	  <rect class="main-color" x="731.69" y="201.07" width="6.37" height="19.54"/>
	  <rect class="main-color" x="718.24" y="201.49" width="6.37" height="19.54"/>
	  <rect class="main-color" x="745.14" y="201.07" width="6.37" height="19.54"/>
	  <path class="warning-traingle" d="M471.94,157.19,456,129.34a2.23,2.23,0,0,0-4.22,0l-15.92,27.85c-1.16,2-.16,3.69,2.21,3.69h31.65C472.1,160.88,473.09,159.22,471.94,157.19Z" transform="translate(0.22 0.65)"/><path d="M453.9,151.62a2.64,2.64,0,1,0,2.64,2.64A2.65,2.65,0,0,0,453.9,151.62Zm-1.33-1.32h2.64l1.33-11.9h-5.29Z" transform="translate(0.22 0.65)"/><rect class="main-color" x="218.45" y="145.44" width="6" height="4"/><path class="main-color" d="M259.7,148.79H247.88v-4H259.7Zm-17.73,0H230.14v-4H242Z" transform="translate(0.22 0.65)"/>
	  <path class="main-color" d="M419.32,148.79H407.49v-4h11.82Zm-17.74,0H389.76v-4h11.82Zm-17.74,0H372v-4h11.82Zm-17.74,0H354.29v-4h11.82Zm-17.74,0H336.55v-4h11.82Zm-17.74,0H318.82v-4h11.82Zm-17.74,0H301.08v-4H312.9Zm-17.74,0H283.35v-4h11.82Zm-17.73,0H265.61v-4h11.82Z" transform="translate(0.22 0.65)"/><rect class="main-color" x="425.45" y="145.44" width="6" height="4"/><rect class="main-color" x="477.45" y="145.44" width="6" height="4"/><path class="main-color" d="M518.7,148.79H506.88v-4H518.7Zm-17.73,0H489.14v-4H501Z" transform="translate(0.22 0.65)"/>
	  <path class="main-color" d="M678.32,148.79H666.49v-4h11.82Zm-17.74,0H648.76v-4h11.82Zm-17.74,0H631v-4h11.82Zm-17.74,0H613.29v-4h11.82Zm-17.74,0H595.55v-4h11.82Zm-17.74,0H577.82v-4h11.82Zm-17.74,0H560.08v-4H571.9Zm-17.74,0H542.35v-4h11.82Zm-17.73,0H524.61v-4h11.82Z" transform="translate(0.22 0.65)"/><rect class="main-color" x="684.45" y="145.44" width="6" height="4"/><polygon class="main-color" points="129.22 186.3 100.89 186.3 100.89 203.93 67.69 203.93 67.69 212.06 162.43 212.06 162.43 203.93 129.22 203.93 129.22 186.3"/>
	  <path class="main-color" d="M29.09,183h171.5V77.29H29.09Zm166.77-4.73h-162V82.1h162v96.21Z" transform="translate(0.22 0.65)"/>
	</svg>
	</div>
	<div class="server-img circle-img">
	<svg class="circle svg-size" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 930 290" >
	  <circle class="error-server" cx="855.66" cy="80.63" r="9.35"/>
	</svg>
	</div>
	</div>
	<div class="server-down-wrapper">
		<div><fmt:message key="connection.error" /></div>
		<div class="user-message">
		<div>
			<c:if test="${not empty details.localizedMessageForUser}">
				<p class="user-local-message">${details.localizedMessageForUser}</p>
			</c:if>
		</div>
		</div>
		<c:if test="${not empty details.technicalDetailsForAdmin || not empty details.incidentId}">
		<!-- Technical details for admin or help desk -->
		<div class="admin-message" >
			<%-- Using enhance:out to exclude this message form out filter that automatically encodes jstl expressions --%>
			<enhance:out escapeXml="false">
					<c:if test="${not empty details.incidentId}">
						<p><fmt:message key="common.error.incidentIdFormatted" ><fmt:param value="${details.incidentId}"/></fmt:message></p>
					</c:if>
					<c:if test="${not empty details.technicalDetailsForAdmin}">
						<p><c:out value="${fn:escapeXml(details.technicalDetailsForAdmin)}" escapeXml="false" /></p>
					</c:if>
			</enhance:out>
		</div>
		</c:if>
	</div>

</body>

</html>