(function() {
	'use strict';

	var pushMod = angular.module('cvModule.push', []);

	pushMod.factory('pushService', [
		function() {
			var socket = null;
			var messageListeners = {};

			var init = function() {
				var request = {
					url: '/AdminConsole/ws',
					contentType: 'application/json',
					transport: 'websocket',
					reconnectInterval: 5000,
					enableXDR: true,
					timeout: 60000
				};

				request.onMessage = function(response) {
					angular.forEach(messageListeners, function(callback, type) {
						callback(response.responseBody);
					});
				};
				socket = atmosphere.subscribe(request);
			};

			if (!socket || socket == null) {
				init();
			}

			return {
				subscribe: function(subscriptionInfo, callback) {
					messageListeners[subscriptionInfo.type] = callback;
					setTimeout(function() {
						socket.push(JSON.stringify(subscriptionInfo));
					}, 500);
				},

				unsubscribe: function(type) {
					socket.push(
						JSON.stringify({
							msg: 'unsubscribe',
							type: type
						})
					);
				}
			};
		}
	]);
})();
