<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="enhance" uri="http://pukkaone.github.com/jsp" %>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8" />
    <title>Command Center</title>
    <style>
        html, body, table {
            height: 100%;
            width: 100%;
            padding: 0;
            margin: 0;
        }
        body {
       
            font-family: 'Roboto';
            font-weight: 300;
        }
        table {
            margin-left: -1px;
            border-top: unset;
            margin-top: -1px;
            margin-right: -1px;
            width: 100%;
        }
        th, td {
        padding:10px;
            text-align: left;
         
        }
        tr:nth-child(odd) {
            background-color: #EEF1F5;
        }
        .progress {
            background-color: #d0c7c7;
            height: 15px;
            width: 100%;
        }
        #fill {
            background: repeating-linear-gradient(45deg,#FF4A6A,#FF4A6A 10px,#092E44 10px, #092E44 20px);
            background-size: 55px 100%;
            border-radius: 5px;
            animation: move 1s linear infinite;
            animation-iteration-count: infinite;
            background-color: #FF4A6A;
            padding: 8px;
        }
        @@keyframes move {
            100% {
                background-position: 60px 0px;
            }
        }

        br {
            display: block;
            margin: 10px 0;
        }
        
        #title svg {
        	width: 60px;
        	height: 60px;
        }
    </style>
</head>
<body align="center">
    
    <div style="background-color:#DDE5EC">
        <br />
        <center>  
            <div id="OEMAdminLogo" style="padding-bottom:10px;">
            	<enhance:out escapeXml="false">${requestScope.PatchingStatus.images.oemAdminLogo}</enhance:out>
           	</div>  
        </center>

        <p align="center" style="color:#FF4A6A;font-size:30px" id="title">
        	<enhance:out escapeXml="false">${requestScope.PatchingStatus.images.adminMaintenance}</enhance:out>
        	Server is under maintenance
        </p>
        <div id="block">
            <c:if test="${not empty requestScope.PatchingStatus.info}">
                 <table style="background-color:white">
                 <caption style="color:white;background-color:#092E44;caption-side:top;font-size:20px;font-weight:bold;text-align:center;padding:7px;margin:0px">
                    Update Progress Information
                 </caption>
                <thead style="font-size:13px;color:#092E44;text-decoration:solid;">
                    <tr style="background-color:white;">
                        <th>Name</th>
                        <th>Phase</th>
                        <th>Status</th>
                        <th>Installed packages</th>
                        <th>Progress</th>
                    </tr>
                </thead>
                <tbody style="color:#444444;font-family:Roboto;font-size:13px;">

                    <c:forEach items="${requestScope.PatchingStatus.info}" var="info">
                        <tr>
                            <td>
                                ${info.clientName}
                            </td>
                            <td>
                                ${info.installPhase}
                            </td>
                            <td>
                                ${info.installStatus}
                            </td>
                            <td>
                                ${info.installedPackages}
                            </td>
                            <td>
                            	<progress id="file" value="${info.installPercentage}" max="100"> ${info.installPercentage}</progress>
                            </td>
                        </tr>
                    </c:forEach>
                </tbody>
            </table>
            </c:if>
    </div>
</div>
</body>
</html>