<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<!doctype html>
<html lang="">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
        <title></title>
        <meta name="description" content="">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <link rel="stylesheet" href="${pageContext.request.contextPath}/common/css/template.css">
        
        <style>
          span#pagingInfo {
        float: right;
        font-size: .4em;
    }
    td.large {
    	word-break: break-word;
    }
        </style>
    </head>
    <body>

    <div class="container">
      <div class="row">
          <h1>Network Log Viewer<span id='pagingInfo'>Top 100 sorted by time taken desc | <a href='#' id='export'>Export</a> | <a href='#' id='del'>Delete All</a></span></h1>
          <table class="table">
            <thead>
              <tr>
          <!-- <th>Req Method</th> -->
          <th width="14%">Page</th>
          <th width="14%">UI Endpoint</th>
          <th width="14%">API</th>
          <th width="14%">Response</th>
          <th width="14%">Time Taken</th>
          <th width="14%">Content Length</th>
          <th width="14%">Action</th> 
              </tr>
            </thead>
            <tbody>
              
            </tbody>
          </table>
      </div>

      <hr>

    </div> <!-- /container -->        
        <script src="${pageContext.request.contextPath}/lib/jquery/jquery.min.js?_20171017092959"></script>
        <script src="${pageContext.request.contextPath}/common/bootstrap/js/bootstrap.min.js"></script>
        
        <script nonce="${sessionScope.cspNonce}" >

          $(document).ready(function(){
            var page = 0, count = 100, sortCol = 'timeTaken', sortOrder='DESC', includePosts = false, api= '';
            var getUrl = function(){
              return 'nwl.do?page=' + page + '&count=' + count + '&sortCol=' + sortCol + '&sortOrder=' + sortOrder + '&includePosts=' + includePosts + '&api=' + api
            };
            
            var getCsrfCookie = function(){
              var cookies = document.cookie.split(";")
              for(i=0;i<cookies.length;i++){
                var c = $.trim(cookies[i]);
                if(c.indexOf('csrf') === 0) {
                  return c.split('=')[1];
                }
              }
              return '';
            };
            $("body").on("click", "#export", function(){
              var path = prompt('Please enter the path and filename where database has to be exported. Please make sure the path exists and is writable.');
              if($.trim(path) === ''){
                alert('Path cant be empty');
                return;
              }
              
              $.ajax({
                     url: 'exportNwLog.do?path=' + path,
                     data: { },
                     type: "POST",
                     beforeSend: function(xhr){xhr.setRequestHeader('csrf', getCsrfCookie());},
                     success: function(data) {
                        alert('Done');
                  }, 
                  error: function(){
                    alert('Please make sure the path: ' + path + ' exists and is writable.')
                  }
              });
           });
            
            $("body").on("click", "#del", function(){
              if(!confirm('Sure?')) {
                return;
              }
              $.ajax({
                     url: 'delNwLog.do',
                     data: { },
                     type: "POST",
                     beforeSend: function(xhr){xhr.setRequestHeader('csrf', getCsrfCookie());},
                     success: function(data) {
                        window.location.reload();
                  }, 
                  error: function(){
                    alert('Something went wrong. Please try again later');
                  }
              });
           });
            
            $("tbody").on("click", ".del-link", function(){
              if(!confirm('Sure?')) {
                return;
              }
              var key = $(this).data('key');
              var row = $(this).parents("tr");
              row.remove();
              $.ajax({
                     url: 'deleteNwLog.do?key=' + key,
                     data: { },
                     type: "POST",
                     beforeSend: function(xhr){xhr.setRequestHeader('csrf', getCsrfCookie());},
                     success: function(data) {
                        //do nothing
                  }
              });
           });
            
            $("tbody").on("click", ".load-resp", function(e){
              e.preventDefault();
              var ele = $(this);
              var id = ele.data("rid");
              var ctx = {ele: ele, id: id};
              
              $.ajax({
                url: 'nwlResp.do?id=' + id,
                data: { },
                dataType: 'text',
                type: 'GET',
                beforeSend: function(xhr){xhr.setRequestHeader('csrf', getCsrfCookie());},
                success: function(data, status, respData) {
                  var id = respData.getResponseHeader("row-id");
                        var holder = $("td.rid" + id);
                        var ta = $("<textarea>" + data + "</textarea>");
                        holder.html(ta);
                      }
              });
            });
            
            $.ajax({
                   url: getUrl(),
                   data: { },
                   type: "GET",
                   beforeSend: function(xhr){xhr.setRequestHeader('csrf', getCsrfCookie());},
                   success: function(data) {
                	   var transactionIdAndPages = {};
                       var table = $("tbody");
                       /* table.html(''); */
                       $.each(data, function(idx, row){
	                   	   if(row.hostPage && row.hostPage !== '') {
	                   		var key = row.hostPage + "_" + row.transId + "_" + row.endpoint;
	                   		if(transactionIdAndPages[key]) {
	                   			console.log("Ignoring " + key);
	                   			return true;
	                   		}
	                   		transactionIdAndPages[key] = key;
	                   	   }
                        var tr = $("<tr></tr>");
                        console.log(row);
                        if(!row.endpoint) {
                        	row["endpoint"] = "NA";
                        }
                        if(!row.hostPage || row.hostPage === '') {
                        	row["hostPage"] = "NA";
                        } else {
                        	row.hostPage + "<br>(" + row.transId + ")";
                        }
                        
                        /* tr.append("<td class='large'>" + row.reqMethod + "</td>"); */
                        tr.append("<td class='large'>" + row.hostPage +  "</td>");
                        tr.append("<td class='large'>" + row.endpoint + "</td>");
                        tr.append("<td class='large'>" + row.api + "</td>");
                        /* tr.append("<td class='large'>" + row.reqPayload + "</td>"); */
                        /* tr.append("<td class='large'>" + row.user + "</td>");
                        tr.append("<td class='large'>" + row.status + "</td>"); */
                        tr.append("<td class='large rid" + row.id + "'><a href='#' class='load-resp' data-rid='" + row.id + "'>Load Response</a></td>");
                        tr.append("<td class='large'>" + (row.timeTaken/1000000).toFixed(2) + "ms</td>");
                        tr.append("<td class='large'>" + row.contentLength + "</td>");
                        tr.append("<td class='large'><a href='#' class='del-link' data-key='" + encodeURIComponent(row.key) + "'>Delete</a></td>");
                        table.append(tr);
                       });
                       
                       /* $("#pagingInfo").html('Showing ' + count + ' on page ' + page); */
                   }
                });
          });
        </script>        
    </body>
</html>
