<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv" %>
<!doctype html>
<html lang="en" ng-app="acApp.fs">
<head>

<jsp:include page="common/favicon.jsp"></jsp:include>

<title>Admin Console</title>
<meta charset="utf-8">
<meta name="description" content="AdminConsole">
<meta name="viewport" content="width=device-width">
<meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate" />
<meta http-equiv="Pragma" content="no-cache" />
<meta http-equiv="Expires" content="0" />

<!-- this will normalize all css styles -->
<!-- <link rel="stylesheet" href="common/css/vendor/normalize.min.css"> -->
<link rel="stylesheet" href="lib/bower_components/angular-loading-bar/build/loading-bar.min.css">
<link rel="stylesheet" href="lib/loading-bar/loading-bar.custom.min.css">
<link rel="stylesheet" href="lib/ng-grid/ng-grid.min.css">
<link rel="stylesheet" href="lib/ng-grid/ng-grid.custom.css">
<link rel="stylesheet" href="lib/bower_components/angular-growl/build/angular-growl.min.css">
<link rel="stylesheet" href="common/css/fsa.css">
<link rel="stylesheet" href="bareFrameMode.css.do">
<script nonce="${sessionScope.cspNonce}" >

var localMsg={};
var cv={};
<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
</script>
</head>
<body>
	<div id="wrapper"  ng-class="{'browse-page':$state.includes('browse')}" >
		<header class="group header">

			<nav class="nav">
				<a ui-sref="servers"><img class="logo" src="img/vweb.png"/></a>
				<ul class="nav__list">
				<!--  NOTE: Add class hasTabs to links that have tabs, like Alerts -->
					<li ui-sref-active="active-link" ng-class="{'active-link': $state.is('serverDetails') || $state.is('collectionDetails') || $state.is('restoreOptions') || $state.is('browse.table')}"><a ui-sref="servers">Servers</a></li>
					<li ui-sref-active="active-link" ><a ui-sref="jobs">Jobs</a></li>
					<li ui-sref-active="active-link" ng-class="{'active-link': $state.is('alertsDefinitions')}" class="hasTabs"><a ui-sref="triggeredAlerts">Alerts</a></li>
					<li ui-sref-active="active-link" ><a ui-sref="events">Events</a></li>
					<li ui-sref-active="active-link" ><a ui-sref="storage">Storage</a></li>
					<li ui-sref-active="active-link"><a ui-sref="users">Users</a></li>
					<li class="uib-dropdown user-account">
						<a class="uib-dropdown-toggle" href="">${loginContext.userEntity.userName}</a>
						<ul uib-dropdown-menu class="dropdown-menu">
							<li><a href="logout.do">Logout</a></li>
						</ul>
					</li>
				</ul>
			</nav>
		</header>

		<div class="nav-breadcrumbs group">
			<!-- The data-cv-global-breadcrumb directive below loads the necessary markup from the partials directory -->
			<div data-cv-global-breadcrumb></div>
		</div>

		<div class="main group" ui-view>
			<!-- add Content here -->
		</div>
	</div>
	<div growl></div>
	<footer class="footer">
		<ul>
			<li><a href="${applicationScope.WHATSNEW_LINK}" target="_blank">What's New</a></li>
			<li><a href="">Legal</a></li>
		</ul>
	</footer>

	<!-- bower dependencies -->
  	<script src="lib/jquery/jquery.min.js"></script>
	<script src="lib/bower_components/angular/angular.js"></script>
	<script src="lib/bower_components/angular-route/angular-route.min.js"></script>
	<script src="lib/bower_components/angular-ui-router/release/angular-ui-router.min.js"></script>
	<script src="lib/bower_components/angular-sanitize/angular-sanitize.min.js"></script>
	<script src="lib/ng-grid/ng-grid.min.js"></script>
	<script src="lib/bower_components/angular-loading-bar/build/loading-bar.min.js"></script>
	<script src="lib/bower_components/angular-bootstrap/ui-bootstrap-tpls.min.js"></script>
	<script src="lib/bower_components/atmosphere/atmosphere.min.js"></script>
	<script src="lib/bower_components/lodash/dist/lodash.min.js"></script>
	<script src="lib/dialog/js/dialog.js"></script>
	<script src="lib/bower_components/angular-growl/build/angular-growl.min.js"></script>

	<!-- manual dependencies -->
	<script src="lib/checklist/checklist-model.js"></script>

	<!-- CV Code -->
	<script src="common/js/localization.js"></script>
	<script src="common/js/common.js"></script>
	<script src="common/js/tableOptions.js"></script>

	<script src="fsa/js/fsaApp.js"></script>
	<script src="common/js/directives/cvDirectives.js"></script>


	<!-- <script src="vsa/js/controllers/wizardController.js"></script> -->

	<script src="commonForAllAgents/js/controllers/clients.ctrl.js"></script>
	<script src="commonForAllAgents/js/services/clients.svc.js"></script>
	
	<script src="commonForAllAgents/js/controllers/collections.ctrl.js"></script>
	
	<script src="commonForAllAgents/js/controllers/schedules.ctrl.js"></script>
	<script src="commonForAllAgents/js/services/schedules.svc.js"></script>
	
	<script src="commonForAllAgents/js/controllers/allBrowse.ctrl.js"></script>
	<script src="commonForAllAgents/js/services/allBrowse.svc.js"></script>
	
	<!-- File system Agent specific files -->
	<script src="fsa/js/controllers/fs.ctrl.js"></script>
	<script src="fsa/js/services/fsService.svc.js"></script>

	<script src="vsa/js/controllers/servers.ctrl.js"></script>
	<script src="/modules/servers/js/services/servers.svc.js"></script>
	
	<!-- Virtual Server Agent specific files 

	<script src="commonForAllAgents/js/services/servers.svc.js"></script>-->
	
	<script src="machineBrowse/js/controllers/machineBrowse.ctrl.js"></script>
	<script src="machineBrowse/js/services/machineBrowse.svc.js"></script>

	<script src="storage/js/controllers/storage.ctrl.js"></script>
	<script src="storage/js/services/storage.svc.js"></script>


	<script src="users/js/controllers/users.ctrl.js"></script>
	<script src="users/js/services/users.svc.js"></script>

	<script src="jobs/js/controllers/jobs.ctrl.js"></script>
	<script src="jobs/js/services/jobs.svc.js"></script>
	<script src="jobs/js/directives/jobs.directives.js"></script>

	<script src="alerts/js/controllers/alerts.ctrl.js"></script>
	<script src="alerts/js/services/alerts.svc.js"></script>
	<script src="alerts/js/plugin-Height-ngGrid.js"></script>

	<script src="events/js/controllers/events.ctrl.js"></script>
	<script src="events/js/services/events.svc.js"></script>
	<script src="events/js/directives/events.directives.js"></script>

	<script src="log/js/logViewer.ctrl.js"></script>
	<script src="log/js/logViewer.svc.js"></script>
</body>
</html>
