var pushUtils = {};
(function(utils) {
	'use strict';

	utils.initGeneralListener = function(onMessage) {
		var socket = null;

		var init = function() {
			var request = {
				url : '/AdminConsole/ws/general',
				contentType : 'application/json',
				transport : 'websocket',
				reconnectInterval : 5000,
				enableXDR : true,
				timeout : 60000
			};
			var tx = angular.element("#tail");
			request.onOpen = function(args) {
				console.debug(arguments);
			};
			request.onMessage = function(response) {
				var responseBody = response.responseBody;
				responseBody = ((responseBody.indexOf("|") >= 0) ? responseBody.split("|")[1] : responseBody);
				onMessage(responseBody);
			};
			socket = atmosphere.subscribe(request);
		};
		if (!socket || (socket == null)) {
			init();
		}
	};

	utils.initJobListener = function($scope) {
		$scope.jobs = [];

		var socket = null;
		var socketId = null;

		var initSocket = function() {
			var request = {
				url : '/AdminConsole/ws?forJobs=true',
				contentType : 'application/json',
				transport : 'websocket',
				reconnectInterval : 5000,
				enableXDR : true,
				timeout : 60000
			};
			request.onMessage = function(response) {
				var responseBody = response.responseBody;
				var parts = responseBody.split("|");
				if (parts.length == 3) {
					var rJobId = parts[1];
					var rJobProg = parts[2];
					//set in scope
					this.jobData = {
						jobId : rJobId,
						progress : rJobProg
					};
					angular.forEach($scope.jobs, function(val, key) {
						if (val.jobId === this.jobData.jobId) {
							val.progress = this.jobData.progress;
							$scope.jobs[key] = {
								jobId : this.jobData.jobId,
								progress : this.jobData.progress
							};
							console.debug('done');
						}
					}, this);
					$scope.$apply();
					return;
				}
				responseBody = parts[1];
				if (responseBody.indexOf("id:") == 0) {
					socketId = responseBody.split(":")[1];
				}
			};

			request.onOpen = function(data) {
				console.debug(data);
			};
			socket = atmosphere.subscribe(request);
		};
		if (!socket || (socket == null)) {
			initSocket();
		}

		$scope.addToWatch = function($event) {
			if ($event.keyCode == 13) {
				var jobId = $("#jobToWatch").val();
				$scope.jobs.push({
					jobId : jobId,
					progress : 0
				});
				socket.push({
					data : socketId + "|" + jobId
				});
				$("#jobToWatch").val('');
			}
		};
	};

	return utils;
})(pushUtils);