<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>	
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
</script>
<div class="row">
	<div class="col-md-12">
		<h1 class="page-title">{{userGroup.userGroupEntity.userGroupName}}</h1>
		<cv-capability-links data-ng-if="userGroupLoaded" cv-permitted-options="permittedOptions"></cv-capability-links>
		<!-- <a data-ng-if="userGroup.userGroupEntity && (userGroup.userGroupEntity.userGroupName!='master' && userGroup.userGroupEntity.userGroupName!='View All')" class="page-action-item" href="" data-ng-click="deleteUserGroup(userGroup)"><cv:msg key="action.delete" bundle="profiles" /></a> -->
	</div>
</div>
<cv-tab-nav ng-if="userGroupLoaded"></cv-tab-nav>
<span class="server-message {{serverMessageDetails.type}}">{{serverMessageDetails.message}}</span>
<div class="row">
	<div class="col-md-12">
		<cv-tile-component data-ac-id="userGroupDetails-label_general-users" data-title='<cv:msg key="label.general" bundle="users"/>' loader="userGroup">
			<ul class="list-style-secondary">
					<li class="group" data-ng-if="providerDomainName">
						<span class="pageDetailColumn"><cv:msg key="label.externalDomain" bundle="users" /></span>
						<span class="pageDetailColumn">{{providerDomainName}}</span>
					</li>
					<li class="group" >
						<span class="pageDetailColumn"><cv:msg key="label.groupName" bundle="users" /></span>
						<span class="pageDetailColumn">{{userGroup.userGroupEntity.userGroupName}}</span>
					</li>
					<li class="group" data-ng-if="userGroup.email">
						<span class="pageDetailColumn"><cv:msg key="label.email" bundle="users" /></span>
						<span class="pageDetailColumn"><a href='mailto:{{userGroup.email}}'>{{userGroup.email}}</a></span>
					</li>
					<li class="group" data-ng-if="userGroup.description">
						<span class="pageDetailColumn"><cv:msg key="label.groupDesc" bundle="users" /></span>
						<span class="pageDetailColumn" data-ng-bind-html="userGroup.description" ></span>
					</li>
					<li class="group" data-ng-if="!isADGroup">
						<span class="pageDetailColumn"><cv:msg key="label.groupEnabled" bundle="users" /></span>
						<span class="pageDetailColumn" >{{userGroup.enabled | userEnabled}}</span>
					</li>
					<li class="group" data-ng-if="showTFA && userGroup.enableTwoFactorAuthentication && userGroup.enableTwoFactorAuthentication !== 'DISABLED_AT_COMPANY'">
						<span class="pageDetailColumn"><cv:msg key="label.enableTwoFactorAuthentication" bundle="users" /></span>
						<span class="pageDetailColumn">{{userGroup.enableTwoFactorAuthentication==='ON' | userEnabled}}</span>
					</li>
					<li class="group">
						<span class="pageDetailColumn"><cv-help-text help-label="{{'label.isBlackListed' | cvLoc}}"
						help-text="'label.isBlackListedHelpText' | cvLoc" /></span>
						<span class="pageDetailColumn">{{userGroup.isBlackListed | userEnabled}}</span>
					</li>
					<li class="group" data-ng-if="userGroup.enforceFSQuota">
						<span class="pageDetailColumn"><cv:msg key="label.quotaLimit" bundle="users" /></span>
						<span class="pageDetailColumn">{{userGroup.quotaLimitInGB}} <span ><cv:msg key="label.gb" bundle="users" /></span>  </span>
					</li>
					<li class="group user-detail-list" data-ng-if="isADGroup">
						<span class="pageDetailColumn"><cv:msg key="label.associateLocalGroup" bundle="users" /></span>
						<span class="pageDetailColumn wrap-cv-fancy-tooltip">
							<cv-fancy-tooltip  data-ng-if="userGroup.localUserGroupsMap && userGroup.localUserGroupsMap.length !== 0" cv-objects="userGroup.localUserGroupsMap" cv-display-width="300"></cv-fancy-tooltip>
							<span class="server-message no-padding" data-ng-if="!userGroup.localUserGroupsMap || userGroup.localUserGroupsMap.length === 0">
								{{localUserGroupsMapLoaded ? '<cv:msg key="label.noGroup" bundle="users" />' : '<cv:msg key="label.loading" bundle="users" />'}}</span>
						</span>
					</li>
					<li class="group" data-ng-if="curUserGroupInfo">
						<cv-plan-migration user-info="curUserGroupInfo" is-modal=false show-tile="editNotAllowed" server-msg="serverMessageDetails"></cv-plan-migration>
					</li>
			</ul>
				<div class="page-details-box-links" data-ng-if ="!editNotAllowed  && userGroupId">
					<a href="" data-ng-click="editUserGroup()"><cv:msg key="label.edit" bundle="users" />
					</a>
				</div>
		</cv-tile-component>
	</div>
</div>
<span data-ng-class="{removedSelection:readonlyGroup}">
	<cv-grid class="bottom-grid-fix" data-ng-if="userGroupId" cv-grid-options="gridOptions"></cv-grid>
</span>