<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.navJs"></cv:cvMessages>
</script>
<div class="row" data-ng-init="tc.loadAppDetails(tc.thirdPartyApp.appName, tc.filterAppProps)">
	<div data-ng-if="tc.loaded" class="col-md-12">
		<h1 class='page-title' ng-bind="tc.thirdPartyApp.appName"></h1>
			<cv:comp name="delete"><span><a href="" class="page-action-item"  data-ng-click="tc.deleteThirdPartyApp(tc.thirdPartyApp.appKey,tc.thirdPartyApp.appName)"><cv:msg key="action.delete" bundle="servers" /></a></span></cv:comp>
			<cv:comp name="editMetadata"><span><a href="" class="page-action-item"  data-ng-click="tc.showAddThirdPartyAppDialog(tc.thirdPartyApp)"><cv:msg key="label.edit" bundle="users" /></a></span></cv:comp>
			<cv:comp name="downloadMetadata"><span><a href="downloadSPMetadataXml.do?appName={{tc.thirdPartyApp.appName | encode}}" class="page-action-item" ><cv:msg key="action.downloadSpMetadata" bundle="users" /></a></span></cv:comp>
	</div>
</div>
<span class="server-message {{tc.serverMessageDetails.type}}">{{tc.serverMessageDetails.message}}</span>
<div class="row">
	<div class="col-md-6">
		<cv-tile-component data-ac-id="thirdPartyAppDetails-label_general-users" data-title='<cv:msg key="label.general" bundle="users"/>' loader="tc.loaded">
			<ul class="list-style-secondary bootstrap-wrapper">
				<li class="group" ><span class="pageDetailColumn"><cv:msg key="label.enabled" bundle="users" /></span>
					<span class="pageDetailColumn">
						<toggle-control class="tc.activityInfo.isEnabled" status="tc.activityInfo.isEnabled" data-ng-click="tc.manageActivity(true)" title="Enable/disable"></toggle-control>
					</span>
				</li>
				<li class="group" ><span class="pageDetailColumn"><cv:msg key="label.createUserAutomatically" bundle="users" /><cv-help-component help-text="<cv:msg key="label.autoCreateUserHelpText" bundle="users" />"></cv-help-component></span>
					<span class="pageDetailColumn">
						<toggle-control class="tc.activityInfo.createUserAutomatically" status="tc.activityInfo.createUserAutomatically" data-ng-click="tc.manageActivity(false)" title="Enable/disable"></toggle-control>
					</span>
				</li>
				<li class="group" >
					<span class="pageDetailColumn"><cv:msg key="label.userGroup" bundle="users"/><cv-help-component help-text="<cv:msg key="label.defaultUserGroupHelpText" bundle="users" />"></cv-help-component></span>
					<span class="pageDetailColumn" title="{{tc.thirdPartyApp.defaultUserGroup.userGroupName}}">{{tc.thirdPartyApp.defaultUserGroup.userGroupName ? tc.thirdPartyApp.defaultUserGroup.userGroupName : '<cv:msg key="label.notSet" bundle="subscriptions"/>'}}
					<a  class="no-index-server-error" data-ng-if="tc.groups" href="" data-ng-click="tc.editDefaultUserGroup(tc.thirdPartyApp.defaultUserGroup)">{{tc.thirdPartyApp.defaultUserGroup.userGroupName ? '<cv:msg key="action.edit" bundle="profiles"/>' : '<cv:msg key="action.add" bundle="profiles" />'}}</a>
					</span>
	  			</li>
	  			<li data-ng-if="tc.isMspAdmin && tc.thirdPartyApp.createdForCompany" class="group" >
					<span class="pageDetailColumn"><cv:msg key="label.createdForCompany" bundle="users" /></span>
					<span class="pageDetailColumn" title="{{tc.thirdPartyApp.createdForCompany}}">{{tc.thirdPartyApp.createdForCompany}}</span>
				</li>
				<li class="group" >
					<span class="pageDetailColumn upload-label"><cv:msg key="label.spEntityId" bundle="users" /></span>
					<span class="pageDetailColumn">
						<span class="input-group">
							<input type="url" title="{{tc.thirdPartyApp.webAppTypeVal}}" disabled data-ng-model="tc.thirdPartyApp.webAppTypeVal" />
							<span class="input-group-btn">
								<button id="thirdPartyAppDetails_button_#7475" tooltip-placement="bottom" uib-tooltip="{{tc.copyMessage}}"  type="button" class="entity-icon btn btn-primary" data-ng-click="tc.copyLinkToClipboard(tc.thirdPartyApp.webAppTypeVal, true)"> 
									<span class="ion-ios-copy-outline"></span>
								</button>
							</span>
						</span>
					</span>
				</li>
				<li class="group" >
					<span class="pageDetailColumn"><cv:msg key="label.singleSignonUrl" bundle="users" /></span>
					<span class="pageDetailColumn">
						<span class="input-group">
							<input type="url" title="{{tc.singleSignonUrl}}" disabled data-ng-model="tc.singleSignonUrl" />
							<span class="input-group-btn">
								<button id="thirdPartyAppDetails_button_#1154" tooltip-placement="bottom" uib-tooltip="{{tc.copyMessage}}" type="button" class="entity-icon btn btn-primary" data-ng-click="tc.copyLinkToClipboard(tc.singleSignonUrl)"> 
									<span class="ion-ios-copy-outline"></span>
								</button>
							</span>
						</span>
					</span>
				</li>
			</ul>
		</cv-tile-component>
	</div>
	<div class="col-md-6" data-ng-if="tc.thirdPartyApp.assocTree.length">
		<cv-tile-component data-ac-id="thirdPartyAppDetails-label_associations-users" data-min-height="true" data-title='<cv:msg key="label.associations" bundle="users" />' loader="tc.loaded">
	 		<span data-ng-if="tc.thirdPartyApp.assocTree.length==0">
				<p class="info-place-holder"><cv:msg key="error.noUsersOrGroups" bundle="users"/></p>
			</span>
			<ul data-columns="2" class="list-style__row group associated-users" data-ng-repeat="users in tc.thirdPartyApp.assocTree">
				<li data-ng-if="users.userId" class="user-type"><span class="invite-user-plan">{{users.userName}}</span> </li>
				<li data-ng-if="users.userGroupId" class="group-type"><span class="invite-user-plan">{{users.userGroupName}}</span></li>
				<li data-ng-if="users.providerId" class="domain-type"><span class="invite-user-plan">{{users.domainName}}</span></li>
			</ul>
			<div class="page-details-box-links multiLinks" data-ng-if="tc.thirdPartyApp.assocTree && tc.loaded">
				 <a href="" data-ng-click="tc.editAssociate()"><cv:msg key="action.edit" bundle="profiles" />
				</a>
			</div>
		</cv-tile-component>
	</div>
	
	<div class="col-md-6">
		<cv-tile-component data-ac-id="thirdPartyAppDetails-label_attributeMappingHelpText-users" data-min-height="true" data-title='<cv:msg key="header.attributeMappings" bundle="users" />' loader="tc.loaded" help-text='<cv:msg key="label.attributeMappingHelpText" bundle="users" />'>
			<span data-ng-if="!tc.thirdPartyApp.attributeMappings || tc.thirdPartyApp.attributeMappings.length == 0">
				<label class="info-place-holder"><cv:msg key="error.noMappingsDefined" bundle="users"/></label>
			</span>
			<div data-ng-if="tc.thirdPartyApp.attributeMappings">
				<cv-kendo-grid data-cv-grid-options="tc.gridOptions"></cv-kendo-grid>
			</div>
			<div class="page-details-box-links multiLinks" data-ng-if="tc.loaded">
				 <a href="" data-ng-click="tc.editAttributeMappings()"><cv:msg key="action.edit" bundle="profiles" /></a>
			</div>
		</cv-tile-component>
	</div>
	
</div>
<div data-ng-if="tc.loaded">
	<cv-identity-redirect title='<cv:msg key="label.identityRedirectRule" bundle="users"/>' redirect-rules="redirectRules" is-created-for-commcell="tc.isCreatedForComcell" submit="submit"></cv-identity-redirect>
</div>