<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
</script>
<fmt:bundle basename="localization.users">
<div data-ng-controller="identityServersAddEditController" data-ng-init=init()>
		<form name="addAppForm" novalidate data-cv-submit="saveApp(imc.close)" autocomplete="off" class="form-horizontal edit-users-grid-form bootstrap-wrapper">
			<div class="text-center no-padding">
				<span class="{{serverMessage.type}}">{{serverMessage.message}}</span>
			</div>
			<div class="modal-body">
				<div class="form-group">
					<label class="col-xs-12 col-md-5 col-lg-5"  for="name2">
						<cv-call-out placement="top" html-template="identityServerDomainNameDocTemplate" label=" <cv:msg key="label.domainName" bundle="users" />" trigger="mouseenter">
						</cv-call-out>
					</label>
					<div class="col-xs-12 col-md-7 col-lg-7">
						<input data-ng-disabled="imc.app || configureForDummyDomainRequest" type="text" id="name2" name="name2" data-ng-model="thirdPartyApp.appName" required maxlength="100" ng-change="cleanDomainName()" />
						<div class="help-block">
							<span data-ng-show="addAppForm.name2.$error.required && cv.addAppForm.needsAttention(addAppForm.name2) || showInvalidDomainError"><i class="ion-alert-circled" ></i><cv:msg key="error.domainNameIsRequired" bundle="ediscovery"/></span>
						</div>
					</div>
				</div>	
				
				<div class="form-group" ng-if="!imc.app">
					<label class="col-xs-12 col-md-5 col-lg-5"  for="webConsoleUrl">
						<cv-call-out placement="top" html-template="identityServerSMTPAddressDocTemplate" label=" <cv:msg key="label.SAML.SMTPAddress" bundle="users" />" trigger="mouseenter">
						</cv-call-out>
					</label>	
					<div class="col-xs-12 col-md-7 col-lg-7">
						<input placeholder='<cv:msg key="placeholder.commaSeparatedSMTPAddresses" bundle="users" />' type="text" id="SMTPAddressForDummyDomain" name="SMTPAddress" data-ng-model="redirectRule.CommaSeparatedSMTPAddresses" required data-ng-pattern="CommaSeparatedSMTPPattern" max-length="300">
						<span class="help-block" data-ng-show="cv.addAppForm.needsAttention(addAppForm.SMTPAddress)"><cv:msg key="error.smtpAddress" bundle="users" /></span>
					</div>
				</div>
						
				<div class="form-group">
					<label  class="col-sm-5" 
						data-ng-class="{'has-error': addAppForm.IDPMetadataPath.$invalid}"
						for="IDPMetadataPath">
						<fmt:message key="label.IDPMetadata"/>
					</label>
					<div class="col-sm-7">
						<div class="input-group">
							<input class="hidden"
								type="file"
								id="IDPMetadata"
								name="IDPMetadata"
								maxlength="100"/>
								<input placeholder="<fmt:message key="placeholder.selectIdpMetadata"/>"
								type="url"
								readonly
								required
								id="IDPMetadataPath"
								name="IDPMetadataPath"
								maxlength="100" disabled/>
							<span class="input-group-btn">
								<button type="button" id="outputIDPMetadata" 
									class="btn btn-default" 
									data-ng-click="browseLocalPath('IDPMetadata', 'IDPMetadataPath', true);">
									<cv:msg key="action.browse" bundle="collections"/>
								</button>
							</span>
						</div>
					</div>
				</div>
				
					<div class="form-group">
						<label class="col-xs-12 col-md-5 col-lg-5"  for="webConsoleUrl">
							<cv-call-out placement="top" html-template="identityServerWebConsoleURLDocTemplate" label="<fmt:message key="label.webconsoleUrl"/>" trigger="mouseenter">
							</cv-call-out>
						</label>
						
						<div class="col-xs-12 col-md-7 col-lg-7">
							<input placeholder='<fmt:message key="placeholder.webConsoleUrl"/>' type="text" id="webConsoleUrl" name="webConsoleUrl" data-ng-model="thirdPartyApp.webAppTypeVal" required maxlength="285" data-ng-pattern="validWebconsoleUrl"/>
							<!--https://260Character :[5-portNumber]/webconsole = 285-->
							<div class="help-block" >
								<span data-ng-show="addAppForm.webConsoleUrl.$error.required && cv.addAppForm.needsAttention(addAppForm.webConsoleUrl)"><i class="ion-alert-circled" ></i><cv:msg key="error.webConsoleUrl" bundle="users"/></span>
								<span data-ng-show="cv.addAppForm.needsAttention(addAppForm.webConsoleUrl) && !addAppForm.webConsoleUrl.$error.required"><i class="ion-alert-circled" ></i><cv:msg key="error.validUrl" bundle="users"/></span>
							</div>
						</div>
					</div>		
					<div data-ng-if="!imc.app && isMspAdmin">
						<!-- else if imc.app is not defined, it is in create mode -->
						<div class="form-group">
							<label class="col-xs-12 col-md-5 col-lg-5" for="createdForCompanies"><cv:msg key="label.createForCompany" bundle="users" />
								<span class="optional-text" ng-hide="companyName"><cv:msg key="label.optional" bundle="subscriptions" /></span>
							</label>
							<div class="col-xs-12 col-md-7 col-lg-7" ng-hide="companyName">
								<isteven-multi-select
				   				  input-model="companies"
				  				  button-label="name"
				  				  item-label="name"
				   				  tick-property="ticked"
				   				  class="isteven-multi-select user-group-select"
				   				  id="createdForCompanies"
				   				  name="createdForCompanies"
				   				  helper-elements="none filter reset"
				   				  max-labels="1"
				   				  translation="localLang"
				   				  disable-property="disabled"
				   				  selection-mode="single">
								</isteven-multi-select>
								<div class="help-block" data-ng-show="showCompanyErrorMessage">
									<i class="ion-alert-circled" ></i><fmt:message key="error.selectACompany" />
								</div>
							</div>
							<div class="col-xs-12 col-md-7 col-lg-7" ng-show="companyName" class="text-left">
								<label ng-bind="companyName"></label>
						</div>
					</div>
				</div>
			
				<div data-ng-if="isMspAdmin">
					<div class="form-group" data-ng-if="thirdPartyApp.createdForCompany && imc.app" >
						<label class="col-xs-12 col-md-5 col-lg-5">
							<fmt:message key="label.createdForCompany"/>
						</label>
						
						<div class="col-xs-12 col-md-7 col-lg-7">
							<label>{{thirdPartyApp.createdForCompany}}</label>
						</div>
					</div>
				</div>					
								
				<br/>
				<div class="form-group">
					<div class="col-xs-12 text-left" data-ng-if="!imc.app">
						<toggle-control status="thirdPartyApp.autoGenerateKey ? 'enabled-activity': 'disabled-activity'" ng-click="autoGenerateToggle()"></toggle-control>
						<span><cv:msg key="label.autoGenerateKey" bundle="users"/></span>
					</div>
				</div>
			
				<br/>
				<div data-ng-show="imc.app || !thirdPartyApp.autoGenerateKey"> <!-- Show this for Edit || during app creation time if autoGenerateKeyCheckBox is unchecked -->
				
					<legend data-ng-show="imc.app" class="cursor-pointer"
							data-ng-click="accordionStatus.generateSPMetadataTab = !accordionStatus.generateSPMetadataTab"><fmt:message key="label.uploadNewKeystoreFile"/><span data-ng-if="imc.app" class="optional-text"><cv:msg key="label.optional"
										bundle="subscriptions" /></span><i class="float-right glyphicon"
							data-ng-class="accordionStatus.generateSPMetadataTab ? 'glyphicon-chevron-down' : 'glyphicon-chevron-right'"></i>
					</legend>
			
					<div data-uib-collapse="!accordionStatus.generateSPMetadataTab" class="cv-modal-wrapper extra-top-spacing">
						<div class="form-group">
							<label class="col-sm-5"  
								for="IDPMetadataPath">
								<fmt:message key="label.keyStoreFile"/>
							</label>
							<div class="col-sm-7">
								<div class="input-group">
									<input class="hidden"
									type="file"
									id="SPMetadata"
									name="SPMetadata"
									maxlength="100" />
									
									<input placeholder="<fmt:message key="placeholder.uploadKeyStore" />"
									type="url"
									readonly
									required
									id="SPMetadataPath"
									name="SPMetadataPath"
									maxlength="100" disabled />
									<span class="input-group-btn">
										<button type="button" id="outputSPMetadata" class="btn btn-default" data-ng-click="browseLocalPath('SPMetadata', 'SPMetadataPath');">
											<cv:msg key="action.browse" bundle="collections"/>
										</button>
									</span>
								</div>								
							</div>
						</div>
			
						<div class="form-group">
							<label class="col-xs-12 col-md-5 col-lg-5" for="aliasName">
								<fmt:message key="label.aliasName" />
							</label>
							<div class="col-xs-12 col-md-7 col-lg-7">
								<input data-ng-required="!imc.app && !thirdPartyApp.autoGenerateKey" type="text" id="aliasName" name="aliasName" data-ng-model="spMetadata.certificateAliasName" maxlength="100" />
								<div class="help-block" data-ng-show="addAppForm.aliasName.$error.required && cv.addAppForm.needsAttention(addAppForm.aliasName)">
									<i class="ion-alert-circled" ></i><fmt:message key="error.aliasName"/>
								</div>
							</div>
						</div>
			
						<div class="form-group">
							<label class="col-xs-12 col-md-5 col-lg-5" for="keyStorePassword"><fmt:message key="label.keyStorePassword" />
							</label>
							<div class="col-xs-12 col-md-7 col-lg-7">
								<input data-ng-required="!imc.app && !thirdPartyApp.autoGenerateKey" type="password" id="keyStorePassword" name="keyStorePassword" data-ng-model="spMetadata.keyStorePassword" maxlength="100" />
								<div class="help-block" data-ng-show="addAppForm.keyStorePassword.$error.required && cv.addAppForm.needsAttention(addAppForm.keyStorePassword)">
									<i class="ion-alert-circled" ></i><fmt:message key="error.password"/>
								</div>	
							</div>
						</div>
			
						<div class="form-group">
							<label class="col-xs-12 col-md-5 col-lg-5" for="keyPassword">
								<fmt:message key="label.keyPassword" />
							</label>
							<div class="col-xs-12 col-md-7 col-lg-7">
								<input data-ng-required="!imc.app && !thirdPartyApp.autoGenerateKey" type="password" id="keyPassword" name="keyPassword" data-ng-model="spMetadata.privateKeyPassword"  maxlength="100" />
								<div class="help-block" data-ng-show="addAppForm.keyPassword.$error.required && cv.addAppForm.needsAttention(addAppForm.keyPassword)">
									<i class="ion-alert-circled" ></i><fmt:message key="error.password"/>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="button-container">
				<fmt:bundle basename="localization.messages">
			  		<button id="addThirdPartyApp_button_#8616" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="close()"><cv:msg key="Cancel" /></button> 
			  		<button id="addThirdPartyApp_button_#9635" type="submit" class="btn btn-primary cvBusyOnAjax" ><cv:msg key="Save"/></button> 
			  	</fmt:bundle>
			</div>
		</form>
	</div>
</fmt:bundle>