<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.usersJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
</script>
<fmt:bundle basename="localization.users">
	<div  data-ng-controller="roleAddEditController as rc" data-ng-init="rc.init(rmc.role)">
		<div class="setup-title">
			<h1 data-ng-if="!rmc.role"><fmt:message key="pageHeader.addRole" /></h1>
			<h1 data-ng-if="rmc.role"><fmt:message key="pageHeader.editRole" /></h1>
		</div>
		<div class="setup-content">
			<span class="{{rc.rolesMessage.type}} serverMessage">{{rc.rolesMessage.message}}</span>
			<form name="addRoleForm" novalidate data-cv-submit="rc.saveRole(rmc.close)" autocomplete="off" class="add-collection-form">
				<div class="global-options remove-border-padding">	
					<label for="name"><cv:msg key="label.name" bundle="collections"/>
						<input type="text" id="name" name="name" data-ng-model="rc.role.roleName" required
							data-ng-class="{'has-error': cv.addRoleForm.needsAttention(addRoleForm.name)}" maxlength="100" />
						<span class="help-block" data-ng-show="addRoleForm.name.$error.required && cv.addRoleForm.needsAttention(addRoleForm.name)"><cv:msg key="error.name" bundle="collections"/></span>
						
					</label>
					<div class="row">
						<div class="col-md-4">
							<label for=""><cv:msg key="label.rolePermissions" bundle="collections"/>
							</label>
						</div>
						<div class="col-md-8">
							<div>
								<input class="tree-inline-search" 
									type="text" name="searchSelection" id="searchSelection" 
									placeholder="<cv:msg key="label.search" bundle="messages"/>" data-ng-model="searchValue" data-ng-change="rc.searchPermissions(searchValue)">
							</div>
							<div class="role-show-selection-wrapper" data-ng-if="rc.showSelect">	
								<input type="checkbox" name="showSelected" id="showSelected" data-ng-model="rc.isDisplaySelection" data-ng-change="rc.searchPermissions(searchValue)"/>
								<label class="checkbox-label" for="showSelected"><cv:msg key="label.showSelected" bundle="users" /></label>
							</div>
						</div>
					</div>
				</div>
				
				<div data-ng-if="rc.categories.length==0">
					<cv:msg key="label.noPermissionsOnSearch" bundle="collections"/>
				</div>
				
				<div data-ng-if="rc.categories" id="category-container" data-ivh-treeview="rc.categories" data-ivh-treeview-expand-to-depth="0" data-ivh-treeview-use-checkboxes="true" data-ivh-treeview-on-cb-change="rc.selectionChanged(ivhNode, ivhIsSelected, ivhTree, searchValue)">
				</div>
					
				<!-- // check box added start // -->	
				<div class="cv-modal-wrapper no-pad">	
					<input type="checkbox" id="rolesEnabled" name="quotaEnabled" class="" data-ng-model="rc.role.enabled">
					<label for="rolesEnabled" class="checkbox-label"><cv:msg key="label.rolesEnabled" bundle="collections"/></label>
				</div>
				<div class="cv-modal-wrapper no-pad">
					<input type="checkbox" id="visibleToAll" name="visibleToAll"
						class="" data-ng-model="rc.role.visibleToAll"> <label
						for="visibleToAll" class="checkbox-label"><cv:msg
							key="label.visibleToAll" bundle="collections" /></label>
				</div>
				<!-- // check box added end // -->
				
				<div class="row">
					<div class="col-md-12">
						<uib-accordion ng-if='rc.showSecurityTile' close-others="true"
							class="text-left">
						<div uib-accordion-group is-open="rc.accordionStatus.security">
							<uib-accordion-heading> <i
								class="glyphicon"
								data-ng-class="{'glyphicon-chevron-down': rc.accordionStatus.security, 'glyphicon-chevron-right': !rc.accordionStatus.security}"></i>
							<cv:msg key="heading.Security" bundle="clients" /> </uib-accordion-heading>
							<div>
								<cv-security-component hide-title="rc.hideSecurityTitle"
									entity-type='rc.entityType' generic-entity='rc.genericEntity'
									associations='rc.formattedSecurityAssociations'
									associations-loaded="rc.securityAssociationsLoaded">
								</cv-security-component>
							</div>
						</div>
						</uib-accordion>
					</div>
				</div>	
				<div class="button-container">
					<fmt:bundle basename="localization.messages">
				  		<button id="addRoleModal_button_#4789" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="rmc.close()"><cv:msg key="Cancel" /></button> 
				  		<button id="addRoleModal_button_#0046" type="submit" class="btn btn-primary cvBusyOnAjax" ><cv:msg key="Save" /></button> 
				  	</fmt:bundle>
				</div>
			</form>
			
		</div>
	</div>
</fmt:bundle>
