import DateTimeDropdown from 'common/js/datetimedropdown';

export const getColumns = function(angularLibs) {
	const columns = {
		...getWorkflowNameColumn(angularLibs.cvLoc),
		...getVersionColumn(angularLibs.cvLoc),
		...getCreatorColumn(angularLibs.cvLoc),
		...getModifiedTimeColumn(angularLibs.cvLoc),
		...getDeployedOnColumn(angularLibs.cvLoc),
		...getDescriptionColumn(angularLibs.cvLoc),
		...getUpdatesColumn(angularLibs.cvLoc),
		...getTagsColumn(angularLibs.cvLoc),
		...getActionsColumn(angularLibs.cvLoc),
		...getFolderColumn()
	};
	return columns;
};

export const getFolderColumn = function(cvLoc) {
	return {
		isFolderStr: {
			type: 'number',
			hidden: true,
			sortable: true,
			allowHiding: false
		}
	};
};

export const getActionsColumn = function(cvLoc) {
	return {
		action: {
			title: 'Actions',
			filterable: false,
			searchable: false,
			type: 'string',
			template: `<div class="permittedActions"></div>`,
			disableViewFiltering: true,
			sortable: false,
			disableColumnFilter: true,
			width: '20%',
			attributes: {
				class: 'permitted-actions'
			}
		}
	};
};
export const getWorkflowNameColumn = function(cvLoc) {
	return {
		'entity.workflowName': {
			title: 'Workflow Name',
			type: 'string',
			template: getNameTemplate(cvLoc),
			disableViewFiltering: false,
			width: '40%'
		}
	};
};

export const getVersionColumn = function(cvLoc) {
	return {
		version: {
			title: 'Version',
			type: 'number',
			template: getVersionTemplate(cvLoc),
			disableViewFiltering: false,
			width: '20%'
		}
	};
};

export const getCreatorColumn = function(cvLoc) {
	return {
		'creator.userName': {
			title: 'Creator',
			type: 'string',
			template: getCreatorColumnTemplate(cvLoc),
			disableViewFiltering: false,
			width: '20%'
		}
	};
};

export const getModifiedTimeColumn = function(cvLoc) {
	return {
		modifiedTime: {
			title: 'Modified',
			type: 'number',
			filterType: 'datetimedropdown',
			template: getModifiedTimeColumnTemplate(cvLoc),
			disableViewFiltering: false,
			searchable: false,
			width: '35%'
		}
	};
};

export const getDeployedOnColumn = function(cvLoc) {
	return {
		deployedOn: {
			title: 'Deployed on',
			type: 'string',
			template: getDeployedOnColumnTemplate(cvLoc),
			disableViewFiltering: false,
			width: '25%'
		}
	};
};

export const getDescriptionColumn = function(cvLoc) {
	return {
		description: {
			title: 'Description',
			type: 'string',
			template: getDescriptionColumnTemplate(cvLoc),
			disableViewFiltering: false,
			width: '60%',
			attributes: {
				class: 'no-tooltip'
			}
		}
	};
};

export const getUpdatesColumn = function(cvLoc) {
	return {
		updateStatus: {
			title: 'Updates',
			type: 'string',
			template: getUpdatesColumnTemplate(cvLoc),
			disableViewFiltering: false,
			width: '20%'
		}
	};
};

export const getTagsColumn = function(cvLoc) {
	return {
		tags: {
			title: 'Tags',
			type: 'string',
			template: getTagsColumnTemplate(cvLoc),
			disableViewFiltering: false,
			width: '20%'
		}
	};
};

const getNameTemplate = cvLoc => {
	return ` #if(data.isFolder){#
			<div class="crop">
					<span cv-toggle="tooltip" cv-toggle-content="#:entity.workflowName#">
						<a href="\\#/folders/#:entity.workflowId#/workflows" class="crop k-workflow-folder workflow-folder" title="">#:entity.workflowName#</a>
					</span>
				</div>
			#}else{#
			<div class="crop">
					<span cv-toggle="tooltip" cv-toggle-content="#:entity.workflowName#">
					# if(data.flags & 1 === 1){ #
						<a class="disabled-workflow" href="workflow/editor?id=#:entity.workflowId#" target="_blank" class="crop" title="">#:entity.workflowName#</a>
					#} else {#
						<a href="workflow/editor?id=#:entity.workflowId#" target="_blank" class="crop" title="">#:entity.workflowName#</a>
					# } #
					</span>
			</div>
			#}#`;
};

const getVersionTemplate = () => {
	return `<div class="crop">
		#if(data.version){#
		<span cv-toggle="tooltip" cv-toggle-content="#:version#">#:version#</span>
		# } else { #
		<span></span>
		#}#
	</div>`;
};

const getCreatorColumnTemplate = () => {
	return `<div class="crop">
		<span cv-toggle="tooltip" cv-toggle-content="#:creator.userName#">
		#:creator.userName#
		</span>
	</div>`;
};

const getModifiedTimeColumnTemplate = () => {
	return `<div class="crop">
	#if(data.modifiedTime){#
		<span cv-toggle="tooltip" cv-toggle-content="#:moment(modifiedTime*1000).format("DD/MM/YYYY hh:mm A")#">#:moment(modifiedTime*1000).format("DD/MM/YYYY hh:mm A")#</span>
	# } else { #
	<span></span>
	#}#
</div>`;
};

const getDeployedOnColumnTemplate = () => {
	return `<div class="crop">
	#if(data.deployments && data.deployments.length){#
	<span cv-toggle="tooltip" cv-toggle-content="#:deployments[0].client.displayName# (ver:#:deployments[0].version#)">
	#:deployments[0].client.displayName# (ver:#:deployments[0].version#)
	</span>
	#}else if(data.isFolder){#
	<span></span>
	#}else{#
	<span>Not deployed</span>
	#}#
</div>`;
};

const getDescriptionColumnTemplate = () => {
	return `<span cv-toggle="callout" data-content="#:description#">
	<div class="wf-description-column">#=description#</div>
	</span>`;
};

const getUpdatesColumnTemplate = cvLoc => {
	return `<div class="crop">
			<span cv-toggle="tooltip" cv-toggle-content="#:updateStatus#">#:updateStatus# </span>
		</div>`;
};

const getTagsColumnTemplate = () => {
	return `<div class="crop">
			#if(data.tags){#
			<span cv-toggle="tooltip" cv-toggle-content="#:tags#">#:tags#</span>
			#}else{#
			<span></span>
			#}#
		</div>`;
};
