<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vmManagementJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
</script>
<div class="row bootstrap-wrapper">
	<cv-tile-component data-ac-id="label_resourceLimitsAndQuota-vmManagement">
			<h4 class="margin-left-15"><cv:msg key="label.resourceLimitsAndQuota" bundle="vmManagement" /></h4>
			<div data-ng-show="policyCreate.isNonCloudVendor || policyCreate.model.showVirtualizeMe || policyCreate.isApplianceEnabledCS()">
				<div class="form-group">
					<label class="col-xs-12 col-md-4 col-lg-4" for="noOfCPUs"><cv:msg key="label.noOfCPUs" bundle="restore" /></label>
					<div class="col-xs-12 col-md-8 col-lg-8">
						<input type="number" class="temporary-enabled" id="noOfCPUs" data-ng-model="policyCreate.model.noOfCPUs" min="1" max="16" />
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-md-4 col-lg-4" for="maxMemory"><cv:msg key="label.maxMemory" bundle="restore" /></label>
					<div class="col-xs-12 col-md-8 col-lg-8">
						<input type="number" class="temporary-enabled" id="maxMemory" data-ng-model="policyCreate.model.maxMemory" min="1" max="64" />
					</div>
				</div>
			</div>
			<div data-ng-if="policyCreate.isOracleCloudInfrastructure()">
				<div class="form-group">
					<label class="col-xs-12 col-md-4 col-lg-4" for="noOfDisks"><cv:msg key="label.noOfDisks" bundle="vmManagement" /></label>
					<div class="col-xs-12 col-md-8 col-lg-8">
						<input type="number" class="temporary-enabled" id="noOfDisks" data-ng-model="policyCreate.model.noOfDisks" min="1" max="16" />
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-md-4 col-lg-4" for="maxDiskSize"><cv:msg key="label.maxDiskSize" bundle="vmManagement" /></label>
					<div class="col-xs-12 col-md-8 col-lg-8">
						<input type="number" class="temporary-enabled" id="maxDiskSize" data-ng-model="policyCreate.model.maxDiskSize" min="1" max="1000" />
					</div>
				</div>
			</div>
			<div class="form-group">
				<label class="col-xs-12 col-md-4 col-lg-4" for="noOfVms"><cv:msg key="label.noOfVms" bundle="vmManagement" /></label>
				<div class="col-xs-12 col-md-8 col-lg-8">
					<input type="number" class="temporary-enabled" id="noOfVms" min="1" max="1000" data-ng-model="policyCreate.model.noOfVms" />
				</div>
			</div>
	</cv-tile-component >
	<cv-tile-component data-ac-id="label_userMemberShipAndDecommission-vmManagement">
	<h4 class="margin-left-15">{{policyCreate.userMemberShipAndDecommisionLabel}}</h4>
			<div class="form-group">
				 <label class="col-xs-12 col-lg-4" for="usersAndUserGroups"><cv:msg key="label.usersAndUserGroups" bundle="restore" /></label>
						<div class="col-xs-12 col-lg-8">
						<isteven-multi-select
					   				input-model="policyCreate.usersAndUserGroups"
					  				button-label="fullName"
									item-label="fullName"
					   				tick-property="selected"
					   				class="isteven-multi-select user-group-select"
					   				directive-id="usersAndUserGroups"
					   				name="usersAndUserGroups"
					   				id="usersAndUserGroups"
					   				search-property="fullName"
					   				max-height="400px"
					   				group-property="header"
					   				helper-elements="all none filter"
					   				translation="policyCreate.localLangUsers"
									max-labels="3">
						</isteven-multi-select>
						</div>
			</div>
	        <div data-ng-if="(policyCreate.isOracleCloudInfrastructure() ||  policyCreate.model.enableVirtualLabs)">
				<div class="form-group">
					<input name="enableDecommission" id="enableDecommission" type="checkbox" data-ng-model="policyCreate.model.enableDecommission" />
					<label for="enableDecommission" class="enableDecommission">
							<cv:msg key="label.enableDecommission" bundle="vmManagement" />
					</label>
				</div>
				<div data-ng-show="policyCreate.model.enableDecommission">
					<div class="form-group">
						<label class="col-xs-12 col-md-4 col-lg-4" for="expirationTimeInDays"><cv:msg key="label.decommissionVM" bundle="vmManagement" /></label>
						<div class="col-xs-12 col-md-8 col-lg-8">
							<input type="number"
									id="expirationTimeInDays"
									name="expirationTimeInDays"
									data-ng-model="policyCreate.model.daysRetainUntil"
									min="1"
									max="999"
									class="expirationTimeInput" /> <cv:msg key="label.days" bundle="schedule" />
						</div>
					</div>
					<div class="form-group">
						<label class="col-xs-12 col-md-4 col-lg-4" for="gracePeriodInDays"><cv:msg key="label.deletionGracePeriod" bundle="vmManagement" /></label>
						<div class="col-xs-12 col-md-8 col-lg-8">
							<input type="number"
									id="gracePeriodInDays"
									name="gracePeriodInDays"
									data-ng-model="policyCreate.model.deletionGracePeriodDays"
									min="0"
									max="30"
									class="expirationTimeInput" /> <cv:msg key="label.days" bundle="schedule" />
						</div>
					</div>
				</div>
		    </div>
			 <div data-ng-if="policyCreate.model.showLiveMount && !policyCreate.model.enableVirtualLabs">
					<div class="form-group">
						<label class="col-xs-12 col-md-4 col-lg-4" for="expirationTimeInHours"><cv:msg key="label.expirationTime" bundle="restore" /></label>
						<div class="col-xs-12 col-md-8 col-lg-8">
							<input type="number"
									id="expirationTimeInHours"
									name="expirationTimeInHours"
									data-ng-model="policyCreate.model.minutesRetainUntil"
									class="expirationTimeInput"
									min="1"
									max="24"
									data-ng-init="policyCreate.model.minutesRetainUntil = (policyCreate.model.minutesRetainUntil > 1 ? policyCreate.model.minutesRetainUntil : 1)" /> <cv:msg key="label.hours" bundle="restore" />
						</div>
					</div>
			</div>
	</cv-tile-component>
	<cv-tile-component data-ac-id="label_optionalSettings-vmManagement" data-ng-show="policyCreate.isVMware() || policyCreate.isRedHat()">
			<h4 class="margin-left-15"><cv:msg key="label.additionalSettings" bundle="vmManagement" /></h4>
			<!-- Virtual lab check box -->
		<div class="form-group">
			<div class="col-xs-12">
				<input data-ng-if="policyCreate.isVMware()"
						data-ng-disabled="policyCreate.model.enableVirtualLabs"
						name="showLiveMount"
						id="showLiveMount"
						type="checkbox"
						data-ng-model="policyCreate.model.showLiveMount"
						data-ng-click="policyCreate.changeLiveMountOptions()" />
				<label for="showLiveMount"><cv:msg key="label.liveMountOptions" bundle="restore" /></label>
			</div>
		</div>
		<div class="form-group margin-left-15" data-ng-if="policyCreate.model.showLiveMount && policyCreate.mediaAgentList && policyCreate.mediaAgentList.length > 0">
			<div class="col-xs-12 col-md-4 col-lg-4"><input name="enableMediaAgent"
																		id="enableMediaAgent"
																		type="checkbox"
																		data-ng-model="policyCreate.model.enableMediaAgent" /> <label for="enableMediaAgent"><cv:msg key="label.mediaAgent" bundle="storage" /></label></div>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<select id="mediaAgent"
						name="mediaAgent"
						data-ng-model="policyCreate.model.mediaAgent"
						data-ng-options="entity as entity.displayName for entity in policyCreate.mediaAgentList"
						data-ng-disabled="!policyCreate.model.enableMediaAgent">
				</select>
			</div>
		</div>
			<div data-ng-if="false">
				<div class="form-group" data-ng-if="policyCreate.model.showLiveMount">
					<div class="col-xs-12">
						 <input name="migrateVMs"
						 		id="migrateVMs"
						 		type="checkbox"
						 		data-ng-model="policyCreate.model.migrateVMs" /> <label for="migrateVMs" class="overwriteLabel"><cv:msg key="label.migrateVMs" bundle="restore" /></label>
					</div>
				</div>
					<div class="form-group" data-ng-if="policyCreate.model.migrateVMs">
						<label class="col-xs-12 col-md-4 col-lg-4" for="waitBeforeMigrationInHours"><cv:msg key="label.waitBeforeMigration" bundle="vmManagement" /></label>
						<div class="col-xs-12 col-md-8 col-lg-8">
							<input type="number"
									id="waitBeforeMigrationInHours"
									name="waitBeforeMigrationInHours"
									data-ng-model="policyCreate.model.waitBeforeMigrationInHours"
									min="1"
									max="24"
									class="waitBeforeMigrationInHours" />
						</div>
					</div>
			</div>
			<!-- Virtualize me check box -->
			<div class="form-group" data-ng-if="policyCreate.isVMware()">
				<div class="col-xs-12">
					<input name="showVirtualizeMe" id="showVirtualizeMe" type="checkbox" data-ng-model="policyCreate.model.showVirtualizeMe" />
					<label for="showVirtualizeMe"><cv:msg key="label.virtualizeMeForReplicationTarget" bundle="restore" /></label>
				</div>
			</div>
		<!-- iso path (windows) -->
		<div class="form-group margin-left-15" data-ng-show="policyCreate.model.showVirtualizeMe">
			<label class="col-xs-12 col-md-4 col-lg-4" for="isoPathWindows"><cv:msg key="label.isoPath" bundle="restore" /> (<cv:msg key="label.windows" bundle="profiles" />)</label>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<div class="input-group">
					<input type="text"
							class="temporary-enabled"
							readonly
							id="isoPathWindows"
							name="isoPathWindows"
							data-ng-model="policyCreate.browseOptions.isoInfo.windows.isoPath"
							placeholder="<cv:msg key="label.isoPath" bundle="restore" /> <cv:msg key="label.windows" bundle="profiles" />"
							data-ng-click="policyCreate.openBrowseDataStoresModal(policyCreate.browseOptions.destinationHost, 'windows')" />
					<span class="input-group-btn">
						<button id="vmLifeCyclePolicySettingsPage_button_#9246" class="btn btn-default" type="button" data-ng-click="policyCreate.openBrowseDataStoresModal(policyCreate.browseOptions.destinationHost, 'windows')"> 
				            <cv:msg key="label.browse" bundle="restore" />
				         </button>
					</span>
				</div>
			</div>
		</div>
		<!-- iso path (unix) -->
		<div class="form-group margin-left-15" data-ng-show="policyCreate.model.showVirtualizeMe">
			<label class="col-xs-12 col-md-4 col-lg-4" for="isoPathUnix"><cv:msg key="label.isoPath" bundle="restore" /> (<cv:msg key="label.unix" bundle="profiles" />)</label>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<div class="input-group">
					<input type="text"
							class="temporary-enabled"
							readonly
							id="isoPathUnix"
							name="isoPathUnix"
							data-ng-model="policyCreate.browseOptions.isoInfo.unix.isoPath"
							placeholder="<cv:msg key="label.isoPath" bundle="restore"/> <cv:msg key="label.unix" bundle="profiles" />"
							data-ng-click="policyCreate.openBrowseDataStoresModal(policyCreate.browseOptions.destinationHost, 'unix')" />
					<span class="input-group-btn">
						<button id="vmLifeCyclePolicySettingsPage_button_#8498" class="btn btn-default" type="button" data-ng-click="policyCreate.openBrowseDataStoresModal(policyCreate.browseOptions.destinationHost, 'unix')"> 
				            <cv:msg key="label.browse" bundle="restore" />
				         </button>
					</span>
				</div>
			</div>
		</div>
		<div class="form-group margin-left-15" data-ng-show="policyCreate.model.showVirtualizeMe && policyCreate.model.enableVirtualLabs">
			<label class="col-xs-12 col-md-4 col-lg-4" for="restoreNetwork"><cv:msg key="label.restoreNetwork" bundle="vmManagement" /></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<select id="restoreNetwork" name="restoreNetwork"
						data-ng-model="policyCreate.model.restoreNetwork"
						data-ng-disabled="!policyCreate.isNetworkListAvailable()"
						data-ng-options="networkInfo as networkInfo.networkName for networkInfo in policyCreate.browseOptions.restoreNetworkSettingsList track by networkInfo.networkName">
						<option disabled value=''>{{policyCreate.getNetworkDropdownText()}}</option>
				</select>
			</div>
		</div>
	</cv-tile-component>
</div>
