<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vmManagementJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvEnum name="Common.VSVendor"></cv:cvEnum>
</script>
<div class="row bootstrap-wrapper">
	<cv-tile-component >
			<div class="form-group">
				<label class="col-xs-12 col-lg-4" for="destinationHost">{{policyCreate.destinationHostLabel}}</label>
					<div class="col-xs-12 col-lg-8">
						<select data-ng-if="policyCreate.isOracleCloudInfrastructure()"
								id="compartment"
								name="compartment"
								data-ng-change="policyCreate.changeCompartmentDetails(policyCreate.model.compartment.guid)"
								data-ng-model="policyCreate.model.compartment"
								data-ng-options="item as item.displayName for item in policyCreate.browseOptions.compartmentList">
							 <option disabled value=''>{{policyCreate.getCompartmentDropdownText()}}</option>
						</select>
						<div data-ng-if="policyCreate.isVMware() || policyCreate.isRedHat()" class="input-group">
								<input type="text"
										readonly
										name="destinationHost"
										id="destinationHost"
										value="{{policyCreate.getCurrentHostDisplayName()}}" placeholder="{{policyCreate.destinationHostPlaceHolder}}" />
							<span class="input-group-btn">
							<!-- don't let the user browse through for user accounts, use only the one populated by default -->
							<button id="vmLifeCyclePolicyConfigPage_button_#7591" type="button" data-ng-click="policyCreate.openSelectDestinationHostDialog()" 
								class="btn btn-default browse-btn"><cv:msg key="label.browse" bundle="restore"></cv:msg>
							</button>
							</span>
						</div>
					</div>
			</div>
			<div class="form-group" data-ng-if="policyCreate.isVMware() || policyCreate.isRedHat()">
				<label class="col-xs-12 col-lg-4" for="displayName"><cv:msg key="label.changeVmDisplayName" bundle="restore" /></label>
				<div class="col-xs-12 col-lg-8">
						<span class="pull-right">
							<!-- Prefix -->
						<input id="displayNamePrefix" type="radio" name="displayNamePrefixSuffix" value="PREFIX" data-ng-model="policyCreate.model.prefixSuffixSelector" />
						<label for="displayNamePrefix" class="restore-settings-right-padding inline-label no-margin"><cv:msg key="label.prefix" bundle="restore" /></label>
                         <!-- Suffix -->
                        <input id="displayNameSuffix" type="radio" name="displayNamePrefixSuffix" value="SUFFIX" data-ng-model="policyCreate.model.prefixSuffixSelector" />
                        <label for="displayNameSuffix" class="inline-label no-margin"><cv:msg key="label.suffix" bundle="restore" /></label>
                        </span>
					    <input type="text" name="displayNamePrefixSuffix" placeholder='<cv:msg key="placeholder.prefixSuffixDisplayName" bundle="restore" />' data-ng-model="policyCreate.model.displayNamePrefixSuffix" />
					</div>
			</div>
			<div class="form-group" data-ng-if="policyCreate.isVMware()">
				<label class="col-xs-12 col-lg-4" for="data-store">{{policyCreate.dataStoreLabel}}</label>
				<div class="col-xs-12 col-lg-8">
						<select name="dataStore"
								id="data-store"
								data-ng-model="policyCreate.browseOptions.dataStore"
								data-ng-disabled="!policyCreate.isDataStoreListAvailable()"
								data-ng-options="ds as policyCreate.getDataStoreDropdownLabel(ds) for ds in policyCreate.browseOptions.dataStoreList track by ds.dataStoreName"
								data-ng-change="policyCreate.dataStoreChanged()">
						<option disabled value=''>{{policyCreate.getDataStoreDropdownText()}}</option>
						</select>
				</div>
			</div>
			<div class="form-group" data-ng-if="policyCreate.isOracleCloudInfrastructure()">
				<label class="col-xs-12 col-lg-4" for="availabilityDomain">{{policyCreate.availabilityDomainOrResourcePoolLabel}}</label>
					<div class="col-xs-12 col-lg-8">
						<select id="availabilityDomain"
								name="availabilityDomain"
								data-ng-model="policyCreate.browseOptions.availabilityDomain"
								data-ng-disabled="!policyCreate.isAvailabilityDomainListAvailable()"
								data-ng-change="policyCreate.changeAvailabilityDomain(policyCreate.model.compartment.guid, policyCreate.browseOptions.availabilityDomain)"
								data-ng-options="availabilityDomain as policyCreate.getAvailabilityDomainOrResourePoolDisplayName(availabilityDomain) for availabilityDomain in policyCreate.browseOptions.availabilityDomainList track by availabilityDomain.name">
								<option disabled value=''>{{policyCreate.getAvailabilityDomainDropdownText()}}</option>
						</select>
					</div>
			</div>
			<div class="form-group"  data-ng-if="policyCreate.isOracleCloudInfrastructure()">
				<label class="col-xs-12 col-lg-4" for="shapes"><cv:msg key="label.shapes" bundle="vmManagement" /></label>
					<div class="col-xs-12 col-lg-8">
						<isteven-multi-select
					   				  input-model="policyCreate.browseOptions.instanceTypeMultiSelectList"
					   				  output-model="policyCreate.browseOptions.selectedInstanceTypes"
					   				  item-label-formatter="policyCreate.getInstanceTypeLabel"
					  				  button-label="name"
					  				  item-label="name"
					   				  tick-property="ticked"
					   				  class="isteven-multi-select user-group-select"
					   				  id="shapes"
					   				  name="shapes"
					   				  helper-elements="all none filter"
					   				  max-labels="1"
					   				  on-item-click="funClick()"
					   				  on-select-none="funClick()"
					   				  on-select-all="funClick()"
					   				  on-reset="funcClick()"
					   				  on-close="funClick()"
					   				  is-disabled="!policyCreate.isInstanceTypeListAvailable()">
						</isteven-multi-select>
						<span class="help-block" data-ng-show="policyCreate.isInstanceTypeLoading && !policyCreate.isInstanceTypeListAvailable()">
									<cv:msg key="error.dataLoading" bundle="restore"></cv:msg>
						</span>
					</div>
			</div>
			<div class="form-group"  data-ng-if="policyCreate.isOracleCloudInfrastructure()">
				<label class="col-xs-12 col-lg-4" for="images"><cv:msg key="label.images" bundle="vmManagement" /></label>
					<div class="col-xs-12 col-lg-8">
							<isteven-multi-select
					   				  input-model="policyCreate.browseOptions.imagesMultiSelectList"
					   				  output-model="policyCreate.browseOptions.selectedImages"
					  				  button-label="name"
					  				  item-label="name"
					   				  tick-property="ticked"
					   				  class="isteven-multi-select user-group-select"
					   				  id="images"
					   				  name="images"
					   				  helper-elements="all none filter"
					   				  max-labels="1"
					   				  on-item-click="funClick()"
					   				  on-select-none="funClick()"
					   				  on-select-all="funClick()"
					   				  on-reset="funcClick()"
					   				  on-close="funClick()"
					   				  is-disabled="!policyCreate.isImagesListAvailable()">
						 	</isteven-multi-select>
							<span class="help-block" data-ng-show="policyCreate.isImagesLoading && !policyCreate.isImagesListAvailable()">
									<cv:msg key="error.dataLoading" bundle="restore"></cv:msg>
							</span>
					</div>
			</div>
			<div class="form-group" data-ng-if="!policyCreate.isOracleCloudInfrastructure() && !policyCreate.isAmazon() && !policyCreate.model.enableVirtualLabs">
				<label class="col-xs-12 col-lg-4" for="networkSettings">{{policyCreate.destinationNetworkLabel}}</label>
					<div class="col-xs-12 col-lg-8">
								<isteven-multi-select
					   				  input-model="policyCreate.browseOptions.networkSettingsList"
					   				  output-model="policyCreate.browseOptions.selectedNetwork"
					  				  button-label="networkName"
					  				  item-label="networkName"
					   				  tick-property="ticked"
					   				  class="isteven-multi-select user-group-select"
					   				  id="networkSettings"
					   				  name="networkSettings"
					   				  helper-elements="all none filter"
					   				  max-labels="1"
					   				  on-item-click="funClick()"
					   				  on-select-none="funClick()"
					   				  on-select-all="funClick()"
					   				  on-reset="funcClick()"
					   				  on-close="funClick()"
					   				  is-disabled="!policyCreate.isNetworkListAvailable()">
						 		</isteven-multi-select>
					</div>
			</div>
			<div class="form-group" data-ng-if="policyCreate.isOracleCloudInfrastructure()">
				<label class="col-xs-12 col-lg-4" for="network">{{policyCreate.destinationNetworkLabel}}</label>
					<div class="col-xs-12 col-lg-8">
								<select id="network"
										name="network"
										data-ng-change="policyCreate.networkInfoChanged(policyCreate.browseOptions.selectedNetwork)"
										data-ng-model="policyCreate.browseOptions.selectedNetwork"
										data-ng-disabled="!policyCreate.isNetworkListAvailable()"
										data-ng-options="networkInfo as networkInfo.networkName for networkInfo in policyCreate.browseOptions.networkSettingsList">
										<option disabled value=''>{{policyCreate.getNetworkDropdownText()}}</option>
								</select>
					</div>
			</div>
			<div class="form-group" data-ng-if="policyCreate.isOracleCloudInfrastructure()">
				<label class="col-xs-12 col-lg-4" for="subnetSettings"><cv:msg key="label.subnet" bundle="vmManagement" /></label>
					<div class="col-xs-12 col-lg-8">
							<isteven-multi-select
					   				  input-model="policyCreate.browseOptions.subnetsMultiSelectList"
					   				  output-model="policyCreate.browseOptions.selectedSubnets"
					  				  button-label="name"
					  				  item-label="name"
					   				  tick-property="ticked"
					   				  class="isteven-multi-select user-group-select"
					   				  id="subnetSettings"
					   				  name="subnetSettings"
					   				  helper-elements="all none filter"
					   				  max-labels="1"
					   				  on-item-click="funClick()"
					   				  on-select-none="funClick()"
					   				  on-select-all="funClick()"
					   				  on-reset="funcClick()"
					   				  on-close="funClick()"
					   				  is-disabled="!policyCreate.isNetworkListAvailable()">
						 		</isteven-multi-select>
						<span class="help-block" data-ng-show="policyCreate.isNetworkLoading && !policyCreate.isNetworkListAvailable()">
									<cv:msg key="error.dataLoading" bundle="restore"></cv:msg>
						 </span>
					</div>
			</div>
			<div class="form-group" data-ng-if="policyCreate.isOracleCloudInfrastructure()">
				<label class="col-xs-12 col-lg-4" for="sshKeys"><cv:msg key="label.sshKey" bundle="vmManagement" /></label>
					<div class="col-xs-12 col-lg-8">
						<span class="btn btn-default btn-file btn-file-fullWidth">
							<span class="btn-text sshKeyFileName">{{policyCreate.sshKeyFileLabel}}</span>
							<cv-file-input file-input="policyCreate.file" on-change="policyCreate.fileUpload()"></cv-file-input>
						</span>
					</div>
			</div>
	</cv-tile-component>
	<cv-tile-component data-ac-id="label_virtualLabSettings-vmManagement" data-ng-show="false" data-title='<cv:msg key="label.virtualLabSettings" bundle="vmManagement"/>' >
			<div class="form-group">
			   <input name="configureExistingNetwork" id="configureExistingNetwork" type="checkbox" data-ng-model="policyCreate.model.configureExistingNetwork" value="existingNetwork" data-ng-change="policyCreate.virtualLabetworkChanged('configureExistingNetwork')" />
			   <label for="configureExistingNetwork" class="overwriteLabel">
			      <cv:msg key="label.configureExistingNetwork" bundle="vmManagement" />
			   </label>
			</div>
			<div class="form-group" data-ng-disabled="!policyCreate.model.configureExistingNetwork">
				<label class="col-xs-12 col-lg-4" for="existingNetwork"><cv:msg key="label.network" bundle="vmManagement" /></label>
					<div class="col-xs-12 col-lg-8">
							<select id="existingNetwork" name="existingNetwork"
										data-ng-model="policyCreate.browseOptions.existingNetwork"
										data-ng-disabled="!policyCreate.isNetworkListAvailable()"
										data-ng-options="networkInfo as networkInfo.networkName for networkInfo in policyCreate.browseOptions.existingNetworkSettingsList track by networkInfo.networkName">
										<option disabled value=''>{{policyCreate.getNetworkDropdownText()}}</option>
							</select>
					</div>
			</div>
			<div class="form-group">
			   <input name="createIsolatedNetwork" id="createIsolatedNetwork" type="checkbox" data-ng-model="policyCreate.model.createIsolatedNetwork" data-ng-change="policyCreate.virtualLabetworkChanged('createIsolatedNetwork')" />
			   <label for="createIsolatedNetwork" class="overwriteLabel">
			      <cv:msg key="label.isolatedNetwork" bundle="restore" />
			   </label>
			</div>
			<div data-ng-disabled="!policyCreate.model.createIsolatedNetwork">
				<div class="form-group col-xs-12 col-lg-12">
						<input name="showGatewayOptions" id="showGatewayOptions" type="checkbox" data-ng-model="policyCreate.model.showGatewayOptions" />
						<label for="showGatewayOptions" class="overwriteLabel">
							   <cv:msg key="label.configureGatewayVMs" bundle="vmManagement" />
						</label>
				</div>
				<div class="form-group" data-ng-if="policyCreate.model.showGatewayOptions">
				   <label class="col-xs-12 col-lg-4" for="gatewayTemplate"><cv:msg key="label.gatewayTemplate" bundle="restore" /></label>
				   <div class="col-xs-12 col-lg-8">
				         <select id="gatewayTemplate" name="gatewayTemplate"
									data-ng-model="policyCreate.browseOptions.gatewayTemplate"
									data-ng-disabled="!policyCreate.isGatewayTemplateListAvailable()"
									data-ng-options="gatewayTemplate as gatewayTemplate.vmName for gatewayTemplate in policyCreate.browseOptions.gatewayTemplateList track by gatewayTemplate.vmName">
									<option disabled value=''>{{policyCreate.getGatewayTemplateDropdownText()}}</option>
						</select>
				   </div>
				</div>
				<div class="form-group" data-ng-if="policyCreate.model.showGatewayOptions">
						<label class="col-xs-12 col-lg-4" for="gatewayNetwork"><cv:msg key="label.gatewayNetwork" bundle="vmManagement" /></label>
						<div class="col-xs-12 col-lg-8">
							<select id="gatewayNetwork" name="gatewayNetwork"
									data-ng-model="policyCreate.browseOptions.gatewayNetwork"
									data-ng-disabled="!policyCreate.isNetworkListAvailable()"
									data-ng-options="networkInfo as networkInfo.networkName for networkInfo in policyCreate.browseOptions.gatewayNetworkSettingsList track by networkInfo.networkName">
									<option disabled value=''>{{policyCreate.getNetworkDropdownText()}}</option>
							</select>
						</div>
				</div>
			</div>
	</cv-tile-component>
</div>
