<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vmManagement"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vmManagementJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
</script>
<form id="replicationTargetRedHatForm"
	name="replicationTargetRedHatForm" novalidate
	data-cv-submit="redHatCtrl.save()" autocomplete="off"
	class="form-horizontal edit-users-grid-form bootstrap-wrapper">
	<div class="">
		<div class="panel-body">
			<div
				class="{{redHatCtrl.redHatErrorMessage.type}} redHatCtrl.redHatErrorMessage text-center">{{redHatCtrl.redHatErrorMessage.message}}</div>
			<!-- Replication target name -->
			<div class="form-group">
				<label class="col-xs-12 col-md-5" for="replicationTargetName"><cv:msg
						key="label.policyName" bundle="vmManagement" /></label>
				<div class="col-xs-12 col-md-7">
					<input type="text" name="replicationTargetName"
						id="replicationTargetName"
						data-ng-model="redHatCtrl.restoreData.replicationTargetName"
						required />
					<div class="help-block"
						data-ng-if="cv.replicationTargetRedHatForm.needsAttention(replicationTargetRedHatForm.replicationTargetName)">
						<i class="ion-alert-circled"></i>
						<cv:msg key="error.name" bundle="messagesJs" />
					</div>
				</div>
			</div>
			<!-- Destination Hypervisor -->
			<div class="form-group">
				<label class="col-xs-12 col-md-5" for="serverId"><cv:msg
						key="label.destinationServer" bundle="restore" /></label>
				<div class="col-xs-12 col-md-7">
					<cv-select-hypervisors model="redHatCtrl.model"
						vendor="{{redHatCtrl.vendor}}" ctrl="redHatCtrl.ctrl">
					</cv-select-hypervisors>
				</div>
			</div>
			<!--  Proxy -->
			<div class="form-group"
				data-ng-if="redHatCtrl.model.selectedHypervisor.clientId">
				<label class="col-xs-12 col-md-5" for="destinationProxy"><cv:msg
						key="label.accessNode" bundle="restore"></cv:msg></label>
				<div class="col-xs-12 col-md-7">
					<cv-select-proxy model="redHatCtrl.restoreData.globalOptions"
						ctrl="redHatCtrl.ctrl"
						hypervisor="redHatCtrl.model.selectedHypervisor"
						selection="single"> </cv-select-proxy>
				</div>
			</div>
			<div class="form-group">
				<label class="col-xs-12 col-md-5" for="usersAndUserGroups"><cv:msg
						key="label.usersAndUserGroups" bundle="restore" /></label>
				<div class="col-xs-12 col-md-7">
					<isteven-multi-select
						data-input-model="redHatCtrl.usersAndUserGroups"
						data-output-model="redHatCtrl.usersAndUserGroup"
						button-label="fullName" item-label="fullName"
						tick-property="selected" id="usersAndUserGroups"
						name="usersAndUserGroups" max-height="400px"
						group-property="header" selection-mode="multiple">
					</isteven-multi-select>
				</div>
			</div>
			<!-- VM Display name -->
			<div class="form-group">
				<div class="col-xs-12">
					<div data-ng-if="redHatCtrl.displayNameOptions">
						<cv-display-name-azure
							restore-data="redHatCtrl.model.selectedVms[0]"
							mode="{{redHatCtrl.mode}}" ctrl="redHatCtrl.ctrl"
							vendor="redHatCtrl.vendor"> </cv-display-name-azure>
					</div>
				</div>
			</div>
			<div class="form-group">
				<label class="col-xs-12 col-md-5" for="destinationHost"><cv:msg
						key="label.destinationCluster" bundle="vmManagementJs" /></label>
				<div class="col-xs-12 col-md-7">
					<div class="input-group">
						<input type="text" readonly name="destinationHost"
							id="destinationHost"
							value="{{redHatCtrl.getCurrentHostDisplayName()}}"
							placeholder="{{redHatCtrl.destinationHostPlaceHolder}}" /> <span
							class="input-group-btn">
							<button id="vmLCPolicyRedHat_button_#9442" type="button" 
								data-ng-click="redHatCtrl.openSelectDestinationHostDialog()"
								class="btn btn-default browse-btn">
								<cv:msg key="label.browse" bundle="restore"></cv:msg>
							</button>
						</span>
					</div>
					<span class="help-block"
						data-ng-if="redHatCtrl.missingDestinationCluster.message">
						<i class="ion-alert-circled">{{redHatCtrl.missingDestinationCluster.message}}</i>
					</span>
				</div>
			</div>
			<div class="form-group"
				data-ng-disabled="!redHatCtrl.browseOptions.destinationHost.displayName">
				<label class="col-xs-12 col-md-5" for="networkSettings"><cv:msg
						key="label.destinationNetworkModal" bundle="restore"></cv:msg><span
				class="optional-text"><cv:msg key="label.optional"
						bundle="restore" /></span></label>
				<div class="col-xs-12 col-md-7">
					<isteven-multi-select
						input-model="redHatCtrl.browseOptions.networkSettingsList"
						output-model="redHatCtrl.browseOptions.selectedNetwork"
						button-label="networkName" item-label="networkName"
						tick-property="selected"
						class="isteven-multi-select user-group-select"
						id="networkSettings" name="networkName"
						helper-elements="all none filter" max-labels="1"
						translation="localLangDestinationNetwork">
					</isteven-multi-select>
				</div>
			</div>
		<div class="form-group">
			<uib-accordion close-others="true">
				<cv-plain-accordion
				accordion-label="label.advanced.options"
				collapsed="redHatCtrl.advanceOptionsAccordion">
					<cv-advance-options
						data-ng-if="redHatCtrl.model.selectedHypervisor.clientId && redHatCtrl.restoreData.globalOptions.selectedProxy"
						vendor="redHatCtrl.vendor" vm-list="redHatCtrl.vmList[0]"
						source-Id="redHatCtrl.model.selectedHypervisor.clientId"
						edit-mode="redHatCtrl.editMode" mode=replicationTarget
						ctrl="redHatCtrl.ctrl">
					 </cv-advance-options>
				</cv-plain-accordion>
			</uib-accordion>
		</div>
		</div>
	</div>
	<div class="modal-footer">
		<button id="vmLCPolicyRedHat_button_#1261" type="button" class="btn btn-default cvBusyOnAjax" 
			data-ng-click="redHatCtrl.saveRedHatCancelled()">
			<cv:msg key="Cancel" bundle="messages" />
		</button>
		<button id="vmLCPolicyRedHat_button_#8256" data-ng-if="!redHatCtrl.editMode" type="submit" class="btn btn-primary cvBusyOnAjax" > 
			<cv:msg key="Add" />
		</button>
		<button id="vmLCPolicyRedHat_button_#9006" data-ng-if="redHatCtrl.editMode" type="submit" class="btn btn-primary cvBusyOnAjax"> 
			<cv:msg key="Save" />
		</button>
	</div>
</form>