<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vmManagement"></cv:cvMessages>
</script>
<span class="col-xs-12 text-center {{rOpenStackCtrl.openStackErrorMessage.type}} serverMessage">{{rOpenStackCtrl.openStackErrorMessage.message}}</span>
<form id="replicationTargetOpenStackForm"  name="replicationTargetOpenStackForm" novalidate
	data-cv-submit="rOpenStackCtrl.save()" autocomplete="off"
	class="form-horizontal edit-users-grid-form bootstrap-wrapperv replication-target-form">
	<div class="panel-body">
		<!-- Replication Target Name -->
		<div class="form-group">
			<label class="col-xs-12 col-md-5" for="replicationTargetName"><cv:msg key="label.policyName" bundle="vmManagement"/></label>
			<div class="col-xs-12 col-md-7">
				<input type="text" name="replicationTargetName" id="replicationTargetName" data-ng-model="rOpenStackCtrl.restoreData.replicationTargetName" required />
				<div class="help-block" data-ng-if="cv.replicationTargetOpenStackForm.needsAttention(replicationTargetOpenStackForm.replicationTargetName)">
					<i class="ion-alert-circled" ></i><cv:msg key="error.name" bundle="messagesJs"/>
				</div>
			</div>
		</div>
		<!-- OpenStack hypervisor -->
		<div class="form-group">
			<label class="col-xs-12 col-md-5" for="openstackSubscription"><cv:msg key="label.destinationServer" bundle="restore" /></label>
			<div class="col-xs-12 col-md-7">
				<cv-select-hypervisors
					model="rOpenStackCtrl.model"
					vendor="{{rOpenStackCtrl.vendor}}"
					ctrl="rOpenStackCtrl.ctrl">
				</cv-select-hypervisors>
			</div>
		</div>
		
		<!-- Access Node -->
		<div data-ng-if="rOpenStackCtrl.model.selectedHypervisor.clientId" class="form-group">
			<div data-ng-if="rOpenStackCtrl.restoreData.globalOptions.showProxy">
				<label class="col-xs-12 col-md-5"  for="destinationProxy">
					<cv:msg key="label.accessNode" bundle="restore"></cv:msg>
				</label>
				<div class="col-xs-12 col-md-7">
					 <cv-select-proxy
						id="destinationProxy"
						name="destinationProxy"
						model="rOpenStackCtrl.restoreData.globalOptions"
						ctrl="rOpenStackCtrl.ctrl"
						hypervisor="rOpenStackCtrl.model.selectedHypervisor"
						selection="single">
					 </cv-select-proxy>
				</div>
			</div>
		</div>
		<!-- Instance display name : Prefix/Suffix -->
		<div class="form-group">
			<label class="col-xs-12 col-md-5" for="instanceDisplayName"><cv:msg key="label.instanceDisplayName" bundle="restore"/>
				<span  class="optional-text"><cv:msg key="label.optional" bundle="restore" /></span>
			</label>
			<div class="col-xs-12 col-md-5">
				<div class="multiple-radio-group">
					<label for="displayNamePrefix"><input id="displayNamePrefix" name="displayNamePrefix" value="PREFIX" data-ng-model="rOpenStackCtrl.prefixSuffixSelector"  type="radio" />
					<span class="block-indent"><cv:msg key="label.prefix" bundle="restore" /></span></label>
				</div>
				<div class="multiple-radio-group">
					<label for="displayNameSuffix"><input id="displayNameSuffix" name="displayNameSuffix" value="SUFFIX" data-ng-model="rOpenStackCtrl.prefixSuffixSelector"  type="radio" />
					<span class="block-indent"><cv:msg key="label.suffix" bundle="restore" /></span></label>
				</div>
			</div>
			<div class="col-xs-12 col-md-7 col-lg-offset-5">
				<input type="text" id="displayNamePrefixSuffix" name="displayNamePrefixSuffix" data-ng-model="rOpenStackCtrl.displayNamePrefixSuffix" placeholder='<cv:msg key="placeholder.prefixSuffixDisplayNameAmazon" bundle="restore" />'/>
			</div>
		</div>
		
		<cv-restore-options-openstack data-ng-if="rOpenStackCtrl.model.selectedHypervisor.clientId"
			vendor="vendor"
			vm-list="rOpenStackCtrl.vmList"
			modified-vms="rOpenStackCtrl.modifiedVms"
			source-id={{rOpenStackCtrl.model.selectedHypervisor.clientId}}
			destination-id="rOpenStackCtrl.model.selectedHypervisor.clientId" 
			replication-type="{{rOpenStackCtrl.attributes.replicationType}}"
			edit-mode="editMode"
			mode="repTarget"
			ctrl="ctrl">
		</cv-restore-options-openstack>
		<div class="panel-body userMemberShip">
			<h4 class="form-header cursor-pointer push-down">
				<cv:msg key="label.userMemberShip" bundle="vmManagement"/>
			</h4>
			<div class="form-group">
				<label class="col-xs-12 col-md-5" for="usersAndUserGroups"><cv:msg key="label.usersAndUserGroups" bundle="restore"/></label>
				<div class="col-xs-12 col-md-7">
					<isteven-multi-select
			   			data-input-model="rOpenStackCtrl.usersAndUserGroups"
			  			data-output-model="rOpenStackCtrl.usersAndUserGroup"
			  			button-label="fullName"
						item-label="fullName"
			   			tick-property="selected"
			   			class="isteven-multi-select user-group-select"
			   			id="usersAndUserGroups"
			   			name="usersAndUserGroups"
			   			search-property="fullName"
			   			max-height="400px"
			   			group-property="header"
			   			selection-mode="multiple">
					</isteven-multi-select>
				</div>
			</div>
		</div>				
	</div>
	<div class="modal-footer">
		<fmt:bundle basename="localization.messages">
			<button id="vmLCPolicyOpenStack_button_#5588" type="button" class="btn btn-default setup-btn--hidden cvBusyOnAjax" data-ng-click="cancel()"><cv:msg key="Cancel" /></button> 
			<button id="vmLCPolicyOpenStack_button_#1026" data-ng-if="!rOpenStackCtrl.editMode" 
					type="submit" class="btn btn-primary cvBusyOnAjax" >
					<cv:msg key="Add" />
			</button>
			<button id="vmLCPolicyOpenStack_button_#2202" data-ng-if="rOpenStackCtrl.editMode" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="Save" /></button> 
		</fmt:bundle>
	</div>
</form>