<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div class="row">
	<div class="col-md-6">
		<cv-tile-component data-ac-id="lcPolicyDetails-vmware" data-title='<cv:msg key="label.summary" bundle="profiles" />' loader="policyDetails.details">
			<ul class="list-style-secondary">
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.destinationServer" bundle="restore"/></span>
					<span class="pageDetailColumn">{{::policyDetails.details.destinationHyperV.clientName}}</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.accessNode" bundle="restore"/></span>
					<span class="pageDetailColumn">{{::policyDetails.details.proxyClientEntity.clientName}}</span>
				</li>
				<li class="group" data-ng-if="policyDetails.details.securityAssociations.users && policyDetails.details.securityAssociations.users.length > 0">
					<span class="pageDetailColumn"><cv:msg key="label.users" bundle="restore" /></span>
					<span class="pageDetailColumn">{{::policyDetails.getUserNamesInCSV(policyDetails.details.securityAssociations.users)}}</span>
				</li>
				<li class="group" data-ng-if="policyDetails.details.securityAssociations.userGroups && policyDetails.details.securityAssociations.userGroups.length">
					<span class="pageDetailColumn"><cv:msg key="label.userGroups" bundle="restore" /></span>
					<span class="pageDetailColumn">{{::policyDetails.getUserGroupNamesInCSV(policyDetails.details.securityAssociations.userGroups)}}</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.changeVmDisplayName" bundle="restore" />
						( <span data-ng-if="policyDetails.details.vmNameEditType === 'PREFIX'"><cv:msg key="label.prefix" bundle="restore" /></span>
						<span data-ng-if="policyDetails.details.vmNameEditType === 'SUFFIX'"><cv:msg key="label.suffix" bundle="restore" /></span> )
					</span>
					<span class="pageDetailColumn">{{::policyDetails.details.vmNameEditString ? policyDetails.details.vmNameEditString : '<cv:msg key="label.notSet" bundle="restore" />'}}</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.compartment" bundle="restore"/></span>
				 	<span class="pageDetailColumn">{{::policyDetails.ociRTDetails.esxHostDiplayName}}</span>
				</li>
				<li class="group">
				 	<span class="pageDetailColumn"><cv:msg key="label.availabilityDomain" bundle="restore"/></span>
				 	<span class="pageDetailColumn">{{::policyDetails.details.dataStores[0].dataStoreName}}</span>
				</li>
				<li class="group">
				 	<span class="pageDetailColumn"><cv:msg key="label.virtualCloudNetwork" bundle="restore"/></span>
					<span class="pageDetailColumn">{{::(!!policyDetails.details.networkInfo[0].label)? policyDetails.details.networkInfo[0].label : policyDetails.details.networkInfo[0].networkName}}</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.subnet" bundle="restore"/></span>
					<span class="pageDetailColumn">{{policyDetails.getSubnetsInTarget(policyDetails.details.networkInfo[0].subnetNames)}}</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.shape" bundle="restore"/></span>
				 	<span class="pageDetailColumn">{{policyDetails.getShapesInTarget(policyDetails.details.amazonPolicy.instanceType)}}</span>
				</li>
				<li data-ng-if="policyDetails.details.resourcePoolPath" class="group">
				 	<span class="pageDetailColumn"><cv:msg key="label.stagingBucket" bundle="restore"/></span>
				 	<span class="pageDetailColumn">{{::policyDetails.details.resourcePoolPath}}</span>
				</li>
				<li data-ng-if="policyDetails.ociRTDetails.vmOptions.sshKeyFileLabel" class="group">
					<span class="pageDetailColumn"><cv:msg key="label.sshKey" bundle="vmManagement"/></span>
					<span class="pageDetailColumn">{{::policyDetails.ociRTDetails.vmOptions.sshKeyFileLabel}}</span>
				</li>
				<li class="group" data-ng-if="policyDetails.details.templates">
				 	<span class="pageDetailColumn"><cv:msg key="fs.keyword.fileextension.Image" bundle="search"/></span>
                     <span class="pageDetailColumn" data-ng-show="policyDetails.templateNames">{{::policyDetails.templateNames}}</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.createPublicIp" bundle="restore"/></span>
				 	<span data-ng-if="policyDetails.details.isPublicIPSettingsAllowed === true"class="pageDetailColumn"><cv:msg key="label.enabled" bundle="vmsJs"/></span>
				 	<span data-ng-if="!policyDetails.details.isPublicIPSettingsAllowed" class="pageDetailColumn"><cv:msg key="label.disabled" bundle="profiles"/></span>
				</li>
				<li class="group" data-ng-if="policyDetails.details.vmPolicyAppType" id="oci_vmPolicyAppType_id">
					<span class="pageDetailColumn"><cv:msg key="label.PolicyType" bundle="restore"/></span>
				 	<span class="pageDetailColumn">{{::policyDetails.policyAppType}}</span>
				</li>
			</ul>
			<div class="page-details-box-links">
				<span>
					<a class="page-action-item" href="" data-ng-click="policyDetails.openEditModal()" data-ng-if="!policyDetails.hideEdit">
						<cv:msg key="action.edit" bundle="collections" />
					</a>
				</span>
			</div>
		</cv-tile-component>
	</div>
</div>