<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.navJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vmManagement"></cv:cvMessages>
</script>
<form id="replicationTargetHyperVForm" name="replicationTargetHyperVForm" novalidate data-cv-submit="rHypervCtrl.save()" autocomplete="off"
		class="form-horizontal edit-users-grid-form bootstrap-wrapper">
	<div class="panel-body">
	<cv-plain-accordion accordion-label="label.general"
				collapsed="rHypervCtrl.generalOptionsAccordion">
		<!-- Replication target name -->
		<div class="form-group">
			<label class="col-xs-12 col-md-5" for="replicationTargetName"><cv:msg key="label.policyName" bundle="vmManagement" /></label>
			<div class="col-xs-12 col-md-7">
				<input type="text" name="replicationTargetName" id="replicationTargetName" data-ng-model="rHypervCtrl.restoreData.replicationTargetName" required />
				<div class="help-block" data-ng-if="cv.replicationTargetHyperVForm.needsAttention(replicationTargetHyperVForm.replicationTargetName)">
				<i class="ion-alert-circled" ></i><cv:msg key="error.name" bundle="messagesJs"/>
				</div>			</div>
		</div>

		<!-- Destination Hypervisor -->
		<div class="form-group">
			<label class="col-xs-12 col-md-5" for="serverId"><cv:msg key="label.destinationServer" bundle="restore" />	</label>
			<div class="col-xs-12 col-md-7">
				<cv-select-hypervisors
					model="rHypervCtrl.model"
					vendor="{{rHypervCtrl.vendor}}"
					disabled="{{rHypervCtrl.editMode}}"
					ctrl="rHypervCtrl.ctrl">
				</cv-select-hypervisors>
			</div>
		</div>

		<!--  Proxy -->
		<div data-ng-if="rHypervCtrl.model.selectedHypervisor.clientId" class="form-group">
			<label class="col-xs-12 col-md-5" for="destinationProxy"><cv:msg key="label.accessNode" bundle="restore"/></label>
				<div class="col-xs-12 col-md-7">
				<cv-select-proxy
					model="rHypervCtrl.restoreData.globalOptions"
					ctrl="rHypervCtrl.ctrl"
					vendor ="{{rHypervCtrl.vendor}}"
					hypervisor="rHypervCtrl.model.selectedHypervisor"
					selection="single">
				</cv-select-proxy>
			</div>
		</div>

		<div class="form-group">
			<label class="col-xs-12 col-md-5" for="usersAndUserGroups"><cv:msg key="label.usersAndUserGroups" bundle="restore"/></label>
			<div class="col-xs-12 col-md-7">
				<isteven-multi-select
		   			data-input-model="rHypervCtrl.usersAndUserGroups"
		  			data-output-model="rHypervCtrl.usersAndUserGroup"
		  			button-label="fullName"
					item-label="fullName"
		   			tick-property="selected"
		   			class="isteven-multi-select user-group-select"
		   			id="usersAndUserGroups"
		   			name="usersAndUserGroups"
		   			search-property="fullName"
		   			max-height="400px"
		   			group-property="header"
		   			selection-mode="multiple">
				</isteven-multi-select>
			</div>
		</div>

		<!-- Restore location -->
		<div class="form-group">
			<div class="col-xs-12 col-md-7">
				<input id="restoreLocation" name="restoreLocation" type="checkbox" data-ng-model="rHypervCtrl.model.defaultRestoreLocationChecked"/>
				<label id="restoreLocation" for="restoreLocation"><cv:msg key="label.restoreLocation" bundle="restore"/></label>
			</div>
		</div>
		<!-- Destination folder -->
		<div class="form-group" data-ng-show="!rHypervCtrl.model.defaultRestoreLocationChecked">
			<label class="col-xs-12 col-md-5" id="destinationFolder" for="destinationFolder"><cv:msg key="label.destinationFolder" bundle="restore"/></label>
			<div class="col-xs-12 col-md-7">
				<div class="input-group cursor-pointer">
					<input type="text" name="destinationFolder" id="destinationFolder" data-ng-model="rHypervCtrl.restoreData.destinationFolder" data-ng-required="!rHypervCtrl.model.defaultRestoreLocationChecked" data-ng-blur='changeAllVmsDestinationFolder(restoreData.vmOptions.destinationFolder)'/>
					<div class="help-block" data-ng-if="cv.replicationTargetHyperVForm.needsAttention(replicationTargetHyperVForm.destinationFolder)">
						<i class="ion-alert-circled" ></i><cv:msg key="error.destinationFolder" bundle="messagesJs"/>
					</div>
					<span class="input-group-btn">
						<button id="vmLCPolicyHyperv_button_#9439" type="button" data-ng-click="openSelectDestinationFolder(restoreData.subClientEntity)" class="btn btn-default browse-btn">
							<cv:msg key="label.browse" bundle="restore"/>
						</button>
					</span>
				</div>
			</div>
		</div>




	<cv-restore-options-hyperv 
		data-ng-if="rHypervCtrl.model.selectedHypervisor.clientId && rHypervCtrl.restoreData.globalOptions.selectedProxy && rHypervCtrl.restoreData.globalOptions.selectedProxy[0].checked" 
		vendor ="rHypervCtrl.vendor" 
		policy-app-type="vmPolicyAppType" 
		vm-list="rHypervCtrl.vmList" 
		source-Id = "rHypervCtrl.model.selectedHypervisor.clientId" 
		edit-mode="rHypervCtrl.editMode"  
		mode=replicationTarget 
		ctrl="rHypervCtrl.ctrl" >
	</cv-restore-options-hyperv>
	
		</cv-plain-accordion>
		<!-- Advanced Options Accordion -->
		    <div ng-if="showLiveMountOption">
			<cv-plain-accordion accordion-label="pageHeader.liveMount"
				collapsed="additionalOptions"> <!-- Virtual lab check box -->
			<!--    	<div class="margin-top-10 margin-bottom-10">
		    		<cv-please-note header='<cv:msg key="action.note" bundle="restoreJs" />' body='<cv:msg key="info.failoverForLiveSync" bundle="restoreJs" />'></cv-please-note>
		    	</div>--> <cv-advance-options
				vendor="rHypervCtrl.vendor" vm-list="rHypervCtrl.vmList[0]"
				source-Id="rHypervCtrl.model.selectedHypervisor.clientId" edit-mode="rHypervCtrl.editMode"
				mode=replicationTarget ctrl="rHypervCtrl.ctrl"
				destination-Host="restoreData.vmOptions.destinationHost"
				server-Details="rHypervCtrl.model.selectedHypervisor"
				policy-app-type="vmPolicyAppType">
				</cv-advance-options>
				 </div>
			</cv-plain-accordion>

	<div class="modal-footer">
		<button id="vmLCPolicyHyperv_button_#5720" type="button" class="btn btn-default cvBusyOnAjax " data-ng-click="rHypervCtrl.saveHyperVCancelled()">
			<cv:msg key="Cancel" bundle="messages" />
		</button>
		<button id="vmLCPolicyHyperv_button_#1530" data-ng-if="!rHypervCtrl.editMode" type="submit" class="btn btn-primary cvBusyOnAjax" >
			<cv:msg key="Add" />
		</button>
		<button id="vmLCPolicyHyperv_button_#8437" data-ng-if="rHypervCtrl.editMode" type="submit" class="btn btn-primary cvBusyOnAjax">
			<cv:msg key="Save" />
		</button>
	</div>
		</div>
</form>