<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div class="row">
	<div class="col-md-6">
		<cv-tile-component data-ac-id="lcPolicyDetails-azure" data-title='<cv:msg key="label.summary" bundle="profiles" />' loader="policyDetails.details">
			<ul class="list-style-secondary">
				<li class="group" data-ng-if="::policyDetails.details.vmPolicyAppType" id="amazon_vmPolicyAppType_id">
					<span class="pageDetailColumn"><cv:msg key="label.PolicyType" bundle="restore" /></span>
					<span class="pageDetailColumn" data-ng-bind="policyDetails.policyAppType"></span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.destinationServer" bundle="restore"/></span>
					<span class="pageDetailColumn">{{::policyDetails.details.destinationHyperV.clientName}}</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.instanceDisplayName" bundle="restore" />
						( <span data-ng-if="policyDetails.details.vmNameEditType === 'PREFIX'"><cv:msg key="label.prefix" bundle="restore" /></span>
						<span data-ng-if="policyDetails.details.vmNameEditType === 'SUFFIX'"><cv:msg key="label.suffix" bundle="restore" /></span> )
					</span>
					<span class="pageDetailColumn">{{::policyDetails.details.vmNameEditString ? policyDetails.details.vmNameEditString : '<cv:msg key="label.notSet" bundle="restore" />'}}</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.accessNode" bundle="restore"/></span>
					<span class="pageDetailColumn">{{::policyDetails.details.proxyClientEntity.clientName}}</span>
				</li>
				<li class="group">
				 	<span class="pageDetailColumn"><cv:msg key="label.availabilityZone" bundle="restore" /> </span>
					<span class="pageDetailColumn">{{::policyDetails.details.amazonPolicy.availabilityZones[0].availabilityZoneName}}</span>
				</li>
				<li class="group">
				 	<span class="pageDetailColumn"><cv:msg key="label.volumeType" bundle="restore" /> </span>
					<span class="pageDetailColumn">{{::policyDetails.details.amazonPolicy.volumeType}}</span>
					<span class="pageDetailColumn" data-ng-show="!policyDetails.details.amazonPolicy.volumeType"><cv:msg key="label.auto" bundle="messagesJs"/></span>
				</li>
				<li class="group">
				 	<span class="pageDetailColumn"><cv:msg key="label.encryptionKey" bundle="restore" /> </span>
					<span class="pageDetailColumn">{{::policyDetails.details.amazonPolicy.encryptionOption.encryptionKey}}</span>
					<span class="pageDetailColumn" data-ng-show="!policyDetails.details.amazonPolicy.encryptionOption.encryptionKey"><cv:msg key="label.auto" bundle="messagesJs"/></span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.networkSettings" bundle="restore" /> </span>
					<span class="pageDetailColumn">{{::policyDetails.details.networkList[0].name}}</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.securityGroupsLabel" bundle="restore"/> </span>
				  	<span class="pageDetailColumn" data-ng-show="policyDetails.details.securityGroups[0].groupId">
				  	{{::policyDetails.details.securityGroups.displayName}}</span>
					<span class="pageDetailColumn" data-ng-show="!policyDetails.details.securityGroups[0].groupId"><cv:msg key="label.auto" bundle="messagesJs"/></span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.instanceType" bundle="restore" /> </span>
					<span class="pageDetailColumn" data-ng-show="policyDetails.details.amazonPolicy.instanceType[0].instanceType.vmInstanceTypeName">{{::policyDetails.details.amazonPolicy.instanceType[0].instanceType.vmInstanceTypeName}}</span>
					<span class="pageDetailColumn" data-ng-show="!policyDetails.details.amazonPolicy.instanceType[0].instanceType.vmInstanceTypeName"><cv:msg key="label.auto" bundle="messagesJs"/></span>
				</li>
				<li class="group" data-ng-if="::policyDetails.details.securityAssociations.users && policyDetails.details.securityAssociations.users.length > 0">
					<span class="pageDetailColumn"><cv:msg key="label.users" bundle="restore" /></span>
					<span class="pageDetailColumn">{{::policyDetails.getUserNamesInCSV(policyDetails.details.securityAssociations.users)}}</span>
				</li>
				<li class="group" data-ng-if="::policyDetails.details.securityAssociations.userGroups && policyDetails.details.securityAssociations.userGroups.length">
					<span class="pageDetailColumn"><cv:msg key="label.userGroups" bundle="restore" /></span>
					<span class="pageDetailColumn">{{::policyDetails.getUserGroupNamesInCSV(policyDetails.details.securityAssociations.userGroups)}}</span>
				</li>

				<!-- test failover options  -->
				<span data-ng-if="policyDetails.showTestFailoverForAmazon">
					<li class="group" data-ng-if="policyDetails.details.minutesRetainUntil">
						<span class="pageDetailColumn"><cv:msg key="label.expirationTime" bundle="restore" /></span>
						<span class="pageDetailColumn">{{::policyDetails.details.minutesRetainUntil}} <cv:msg key="label.hours" bundle="schedule" /></span>
					</li>
					<li class="group" data-ng-if="policyDetails.details.daysRetainUntil">
						<span class="pageDetailColumn"><cv:msg key="label.testExpirationTime" bundle="vmManagement" /></span>
						<span class="pageDetailColumn">{{::policyDetails.details.daysRetainUntil}} <cv:msg key="label.days" bundle="schedule" /></span>
					</li>
					<li class="group">
						<span class="pageDetailColumn"><cv:msg key="label.testNetwork" bundle="vmManagement" /></span>
						<span class="pageDetailColumn" data-ng-bind="policyDetails.details.networkInfo[0].networkName ? (policyDetails.details.networkInfo[0].label ? policyDetails.details.networkInfo[0].label : policyDetails.details.networkInfo[0].networkName) : policyDetails.defaultUIDisplay"></span>
					</li>

					<li class="group">
						<span class="pageDetailColumn"><cv:msg key="label.testInstanceType" bundle="vmManagement" /></span>
					 	<span class="pageDetailColumn" data-ng-bind="policyDetails.details.amazonPolicy.vmInstanceTypes[0].vmInstanceTypeName ? policyDetails.details.amazonPolicy.vmInstanceTypes[0].vmInstanceTypeName : policyDetails.defaultUIDisplay">
					 	</span>
					</li>
				</span>

			</ul>
			<div class="page-details-box-links">
				<span>
					<a class="page-action-item" href="" data-ng-click="policyDetails.openEditModal()" data-ng-if="!policyDetails.hideEdit">
						<cv:msg key="action.edit" bundle="collections" />
					</a>
				</span>
			</div>
		</cv-tile-component>
	</div>
</div>