<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collectionsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vmsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vmManagementJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vmManagement"></cv:cvMessages>
	<cv:cvEnum name="CvEntities.VMAllocationPolicyType"></cv:cvEnum>
</script>
<div class="row">
	<div class="col-md-12">
		<h1 class="page-title">
			<span class="name">
				<span data-ng-bind="policyDetails.details.entity.vmAllocPolicyName"></span>
			</span>
		</h1>
		<cv-capability-links data-ng-if="::policyDetails.details.entity.vmAllocPolicyId" cv-permitted-options="policyDetails.permittedOptions"></cv-capability-links>
	</div>
</div>
<span class="server-message {{serverMessage.type}}">{{serverMessage.message}}</span>
<div data-ng-if="policyDetails.details.entity.policyType === 'AMAZON'">
	<ng-include src="policyDetails.getPageUrl('vmLCPolicyAmazonDetails.jsp')"></ng-include>
</div>
<div data-ng-if="(policyDetails.details.entity.policyType === 'AZURE' || policyDetails.details.entity.policyType === 'AZURE_RESOURCE_MANAGER' || policyDetails.details.entity.policyType === 'AZURE_STACK')">
	<ng-include src="policyDetails.getPageUrl('vmLCPolicyAzureDetails.jsp')"></ng-include>
</div>
<div data-ng-if="policyDetails.details.entity.policyType === 'MICROSOFT'">
	<ng-include src="policyDetails.getPageUrl('vmLCPolicyHypervDetails.jsp')"></ng-include>
</div>
<div data-ng-if="policyDetails.details.entity.policyType === 'NUTANIX_AHV'">
	<ng-include src="policyDetails.getPageUrl('vmLCPolicyNutanixDetails.jsp')"></ng-include>
</div>
<div data-ng-if="policyDetails.details.entity.policyType === 'ORACLE_CLOUD_INFRASTRUCTURE'">
	<ng-include src="policyDetails.getPageUrl('vmLCPolicyOCIDetails.jsp')"></ng-include>
</div>
<div data-ng-if="policyDetails.details.entity.policyType === 'OPENSTACK'">
	<ng-include src="policyDetails.getPageUrl('vmLCPolicyOpenStackDetails.jsp')"></ng-include>
</div>
<div data-ng-if="policyDetails.details.entity.policyType === 'GOOGLE_CLOUD'">
	<ng-include src="policyDetails.getPageUrl('vmLCPolicyGoogleCloudDetails.jsp')"></ng-include>
</div>
<div data-ng-if="policyDetails.details.entity.policyType === 'RHEV'">
	<ng-include src="policyDetails.getPageUrl('vmLCPolicyRedHatDetails.jsp')"></ng-include>
</div>
<div data-ng-if="(policyDetails.details.entity.policyType === 'VMWARE' || policyDetails.details.entity.policyType === 'VMW_LIVEMOUNT' || policyDetails.details.entity.policyType === 'VMW_BACKUP_LABTEMPLATE')">
	<ng-include src="policyDetails.getPageUrl('vmLCPolicyVMWareDetails.jsp')"></ng-include>
</div>