<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vmManagementJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvEnum name="Common.VSVendor"></cv:cvEnum>
</script>
<div class="setup-title">
	<h1 data-ng-if="!editMode"><cv:msg key="header.addLifeCyclePolicy" bundle="vmManagementJs"/></h1>
	<h1 data-ng-if="editMode"><cv:msg key="header.editLifeCyclePolicy" bundle="vmManagementJs"/></h1>
</div>
<div  class="form-horizontal">
		<div class="panel-body">
		<div data-ng-if="!editMode && showVendorSelection" class="form-group">
			<label class="col-xs-12 col-md-5" for="vendorTypes"><cv:msg key="label.vendorType" bundle="servers"/></label>
			<div data-ng-disabled="disableSelectVendor" class="col-xs-12 col-md-7">
				<isteven-multi-select
					id="vendorTypes"
					name="vendorTypes"
					data-input-model="model.vendors"
					data-output-model="model.vendor"
					data-tick-property="selected"
					item-label="name"
					data-button-label="name"
					data-search-property="name"
					disabled="disabled"
					helper-elements="filter showSelected"
					class="isteven-multi-select user-group-select modal-right"
					translation="localLang"
					data-ng-disabled="nodes && model.vendorType=='MICROSOFT'"
					on-item-click="changeStepsByVendor()"
					data-selection-mode="single"
					directive-id="vendorTypes">
				</isteven-multi-select>
			</div>
		</div>

	<div data-ng-if="vendorSelected" class="form-group" id="application_type_policy_id">
				<label class="col-xs-12 col-md-5" for="appType">
					<cv-help-text help-label="<cv:msg key="tableHeader.applicationType" bundle="users" />" help-text='label.applicationTypeNote'></cv-help-text>
				</label>
				<div class="col-xs-12 col-md-7" data-ng-disabled="disableVMPolicyAppType">
					<isteven-multi-select data-input-model="vmPolicyApplicationTypes"
						data-output-model="selectedVMPolicyAppType" button-label="name"
						item-label="name" tick-property="selected" class="isteven-multi-select user-group-select"
						id="applicationTypeSelection" name="applicationTypeSelection"
						max-height="400px" group-property="header" helper-elements="all none filter"
						selection-mode="single" directive-id="applicationTypeSelection"
						translation="localLangApplicationType" on-item-click="changeApplicationType(selectedVMPolicyAppType[0])">
					</isteven-multi-select>
				</div>
	</div>
		</div>
</div>

<div data-ng-if="vmPolicyAppType" data-ng-class="['bootstrap-wrapper' , {'form-horizontal' : model.vendor === 'AMAZON' }]" >
	<div data-ng-if="model.vendor === 'VMW'" data-ng-controller='replicationControllerVMW as repTargetCtrl'>
		<ng-include src="getModalUrl('vmLCPolicyVMWare.jsp')"></ng-include>
	</div>
	<div data-ng-if="(model.vendor === 'AZURE' || model.vendor === 'AZURE_V2' || model.vendor === 'AZURE_STACK')"
		data-ng-controller='replicationControllerAzure as rAzureCtrl'>
		<ng-include src="getModalUrl('vmLCPolicyAzure.jsp')"></ng-include>
	</div>
	<!-- TODO: Use ngInclude here too. Amazon files will be fetched before a vendor is selected-->
	<div data-ng-if="model.vendor === 'AMAZON'">
		<cv-restore-options-amazon restore-target-model=rtModelAmazon mode=restoreOptionsAWSMode disabled-hypervisor="disabledHypervisor"/>
	</div>

	<div data-ng-if="model.vendor === 'MICROSOFT'"
		data-ng-controller="replicationControllerHyperv as rHypervCtrl">
		<ng-include src="getModalUrl('vmLCPolicyHyperv.jsp')"></ng-include>
	</div>
	<div data-ng-if="model.vendor === 'ORACLE_CLOUD_INFRASTRUCTURE'"
		data-ng-controller="replicationControllerOCI as rOCICtrl">
		<ng-include src="getModalUrl('vmLCPolicyOCI.jsp')"></ng-include>
	</div>
	 <div data-ng-if="model.vendor === 'NUTANIX' || model.vendor === 'NUTANIX_AHV'"
		data-ng-controller='replicationNutanixController as nutanixCtrl'>
		<ng-include src="getModalUrl('vmLCPolicyNutanix.jsp')"></ng-include>
	</div>

	<div data-ng-if="model.vendor === 'OPENSTACK' "
		data-ng-controller='replicationControllerOpenStack as rOpenStackCtrl'>
		<ng-include src="getModalUrl('vmLCPolicyOpenStack.jsp')"></ng-include>
	</div>
	<div data-ng-if="model.vendor === 'REDHAT'"
		data-ng-controller="replicationControllerRedHat as redHatCtrl">
		<ng-include src="getModalUrl('vmLCPolicyRedHat.jsp')"></ng-include>
	</div>
	<div data-ng-if="model.vendor === 'GOOGLE_CLOUD'"
		data-ng-controller="replicationControllerGoogleCloud as rGoogleCloudCtrl">
		<ng-include src="getModalUrl('vmLCPolicyGoogleCloud.jsp')"></ng-include>
	</div>

	<div class="modal-footer" data-ng-if="!model.vendor || model.vendor.length === 0">
		<fmt:bundle basename="localization.messages">
			<button id="lcPolicyAdd_button_#9352" type="button" class="btn btn-default setup-btn--hidden cvBusyOnAjax" data-ng-click="cancel()"><cv:msg key="Cancel" /></button>
		</fmt:bundle>
	</div>
</div>