<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.vmManagement"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vmManagementJs"></cv:cvMessages>
</script>

<div class="setup-title">
	<h1> <cv:msg key="title.addHedvigDatastore" bundle="vmManagement"/></h1>
</div>
<div class="margin-10">
	<cv-please-note header='<cv:msg key="action.note" bundle="restoreJs" />' body='<cv:msg key="info.hedvigDatastoreCreationNote" bundle="vmManagement" />'></cv-please-note>
</div>
	<form name="addOrEditHedvigDatastoreForm" class="form-horizontal edit-users-grid-form bootstrap-wrapper" data-cv-submit="manageHedvigDSCtrl.submit()" autocomplete="off">
	<div class="panel panel-default">
		<div class="panel-body margin-bottom-10">
		<p data-ng-if="manageHedvigDSCtrl.serverMessage.message" class="{{manageHedvigDSCtrl.serverMessage.type}} serverMessage" data-ng-bind="manageHedvigDSCtrl.serverMessage.message"></p>
		<div class="form-group">
				<label class="col-xs-12 col-md-5" for="datastoreName">
					<cv:msg key="label.name" bundle="vmManagement" />
				</label>
				<div class="col-xs-12 col-md-7">
					<input type="text" name="dataStoreName" id="dataStoreName"
						data-ng-model="manageHedvigDSCtrl.model.dataStoreName" />
					<div class="help-block"
						data-ng-show="!manageHedvigDSCtrl.model.dataStoreName && cv.addOrEditHedvigDatastoreForm.getAttempted()">
						<i class="ion-alert-circled"></i>
						<cv:msg key="error.dataStoreName" bundle="vmManagement" />
					</div>
				</div>
		</div>
		<div class="form-group">
				<label class="col-xs-12 col-md-5" for="hedvigCluster">
					<cv:msg key="label.hedvigCluster" bundle="vmManagement" />
				</label>

				<div data-ng-class="{'col-xs-12 col-md-6' : manageHedvigDSCtrl.showRegisterCluster ,'col-xs-12 col-md-7' : !manageHedvigDSCtrl.showRegisterCluster}">
					<isteven-multi-select
						data-input-model="manageHedvigDSCtrl.model.hedvigClusters"
						data-output-model="manageHedvigDSCtrl.model.selectedHedvigCluster"
						button-label="displayName"
						item-label="displayName"
						tick-property="selected"
						class="isteven-multi-select user-group-select"
						id="hedvigCluster"
						name="hedvigCluster"
						search-property="displayName"
						max-height="400px"
						group-property="header"
						helper-elements="all none filter"
						selection-mode="single"
						translation="manageHedvigDSCtrl.localLang"
						on-item-click="manageHedvigDSCtrl.loadHedvigProxies()"
						directive-id="hedvigCluster">
					</isteven-multi-select>
					<div class="help-block"
						data-ng-show="(!manageHedvigDSCtrl.model.selectedHedvigCluster || manageHedvigDSCtrl.model.selectedHedvigCluster.length == 0) && cv.addOrEditHedvigDatastoreForm.getAttempted()">
						<i class="ion-alert-circled"></i>
						<cv:msg key="error.hedvigCluster" bundle="vmManagement" />
					</div>
				</div>
				<div data-ng-if="manageHedvigDSCtrl.showRegisterCluster" class="padding-top-15">
					<a data-ng-click="manageHedvigDSCtrl.registerNewCluster()">
						<cv:msg key="action.add" bundle="storage" />
					</a>
				</div>

		</div>
		<div class="form-group">
				<label class="col-xs-12 col-md-5" for="hedvigProxy">
					<cv:msg key="label.hedvigProxy" bundle="vmManagement" />
				</label>
				<div data-ng-disabled="(!manageHedvigDSCtrl.model.selectedHedvigCluster || manageHedvigDSCtrl.model.selectedHedvigCluster.length == 0)" class="col-xs-12 col-md-7">
					<isteven-multi-select
						data-input-model="manageHedvigDSCtrl.model.hedvigProxies"
						data-output-model="manageHedvigDSCtrl.model.selectedHedvigProxy"
						button-label="target"
						item-label="target"
						tick-property="selected"
						class="isteven-multi-select user-group-select"
						id="hedvigProxy"
						name="hedvigProxy"
						search-property="target"
						max-height="400px"
						group-property="header"
						helper-elements="all none filter"
						selection-mode="single"
						translation="manageHedvigDSCtrl.localLang"
						directive-id="hedvigProxy">
					</isteven-multi-select>
					<div class="help-block"
						data-ng-show="(!manageHedvigDSCtrl.model.selectedHedvigProxy || manageHedvigDSCtrl.model.selectedHedvigProxy.length == 0) && cv.addOrEditHedvigDatastoreForm.getAttempted()">
						<i class="ion-alert-circled"></i>
						<cv:msg key="error.hedvigProxy" bundle="vmManagement" />
					</div>
				</div>
		</div>
		<div class="form-group">
				<label class="col-xs-12 col-md-5" for="capacity">
					<cv:msg key="label.capacity" bundle="vmManagement" />
				</label>
				<div class="col-xs-12 col-md-2">
					<input class="margin-right-20" type="number" min="1" max="1024" name="capacity" id="capacity" data-ng-model="manageHedvigDSCtrl.model.capacity" required>

				</div>
				<div class="col-xs-12 col-md-2">
					<select id="capacityType" name="capacityType "
	                            data-ng-model="manageHedvigDSCtrl.model.selectedCapacityType"
	                            data-ng-options="capacityType as capacityType.type for capacityType in manageHedvigDSCtrl.model.capacityTypes">
	                 </select>
				</div>
		</div>

		<div class="button-container">
	  		<button id="cancelHedvigDS" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="manageHedvigDSCtrl.cancel()"><cv:msg key="action.cancel" bundle="profiles"/></button>
	  		<button id="createHedvigDS" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="action.add" bundle="profiles"/></button>
		</div>
		</div>
		</div>
	</form>
