<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vmManagementJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
</script>
<div class='form-horizontal edit-users-grid-form '
	id="advanceOptionsOCIForm">
	<div class="row">
		<div class="panel-body remove-border-padding">
			<!-- Expiration time For VMware-->
			<div class="form-group"
				data-ng-if="advOptCtrl.isVMware() && advOptCtrl.showLiveMount">
				<label class="col-xs-12 col-md-5 col-lg-5"
					for="expirationTimeInHours"><cv:msg
						key="label.expirationTime" bundle="restore" /></label>
				<div class="col-xs-12 col-md-7 col-lg-7">
					<span data-ng-if="!advOptCtrl.showOnlyDays"> <input type="radio" id="expirationTimeHours" name="expirationTimeHoursDays"
						data-ng-model="advOptCtrl.expirationTime" value="Hours"
						data-ng-click="advOptCtrl.expirationTimeClick('Hours')">
						<label for="expirationTimeInHours"> <cv:msg
								key="label.hours" bundle="restore" />
					</label> <input type="number" class="temporary-enabled"
						id="expirationTimeInHours" name="expirationTimeInHours"
						data-ng-model="advOptCtrl.model.minutesRetainUntil" min="1"
						max="24" data-ng-change="advOptCtrl.expirationTimeClick('expirationTimeInHours')"
						data-ng-init="advOptCtrl.model.minutesRetainUntil = (advOptCtrl.model.minutesRetainUntil > 1 ? advOptCtrl.model.minutesRetainUntil : 1)">
					</span> <span> <input type="radio" id="expirationTimeDays" name="expirationTimeHoursDays"
						data-ng-model="advOptCtrl.expirationTime" value="Days"
						data-ng-click="advOptCtrl.expirationTimeClick('Days')" data-ng-if="!advOptCtrl.showOnlyDays">
						<label data-ng-if="!advOptCtrl.showOnlyDays" for="expirationTimeInDays" class="expirationTimeLabel">
							<cv:msg key="label.days" bundle="vmManagementJs" />
					</label> <input type="number" id="expirationTimeInDays"
						name="expirationTimeInDays"
						data-ng-model="advOptCtrl.model.daysRetainUntil" min="1" max="999"
						data-ng-change="advOptCtrl.expirationTimeClick('expirationTimeInDays')"
						data-ng-init="advOptCtrl.model.daysRetainUntil= (advOptCtrl.model.daysRetainUntil > 1 ? advOptCtrl.model.daysRetainUntil : 1)">
					</span>
				</div>
			</div>
			<%-- 			<!--  don't not require to show livemount toggle.-->
			<div class="form-group col-xs-12" data-ng-if="advOptCtrl.isHyperv()"
					data-ng-disabled="true">
					<toggle-control status="advOptCtrl.showLiveMount"
						data-ng-click="advOptCtrl.manageLiveMountOptionsActivity()"
					title="Enable/disable <cv:msg key='label.liveMountOptions' bundle='restore' />"></toggle-control>
				&nbsp; &nbsp; <span class="no-padding"> <cv:msg
						key="label.liveMountOptions" bundle="restore" /></span>
			</div>
			--%>
			<!-- No Of VMs -->
			<div class="form-group" data-ng-if="advOptCtrl.isRegularPolicy">
				<label class="col-xs-12 col-md-5 col-lg-5" for="noOfVms"><cv:msg
						key="label.noOfVMsRHEV" bundle="vmManagement" /></label>
				<div class="col-xs-12 col-md-7 col-lg-7">
					<input type="number" class="temporary-enabled" id="noOfVms" min="1"
						max="1000" data-ng-change="advOptCtrl.noOfVMsChanged()"
						data-ng-model="advOptCtrl.model.noOfVms" /> <span> <cv:msg
							key="label.perUser" bundle="vmManagement" />
					</span> <span class="help-block"
						data-ng-if="advOptCtrl.invalidNoOfVMs.message"> <i
						class="ion-alert-circled">{{advOptCtrl.invalidNoOfVMs.message}}</i>
					</span>
				</div>
			</div>
			<!-- Expiration time for other vendors -->
			<div class="form-group"
				data-ng-if="!advOptCtrl.isVMware() && advOptCtrl.showLiveMountFlag">
				<label class="col-xs-12 col-md-5 col-lg-5" for="noOfVms"><cv:msg
						key="label.expirationTime" bundle="restore" /></label>
				<div class="col-xs-12 col-md-7 col-lg-7">
					<input type="number" class="temporary-enabled"
						id="expirationTimeInHours" name="expirationTimeInHours"
						data-ng-model="advOptCtrl.model.minutesRetainUntil" min="1"
						max="24" data-ng-change="advOptCtrl.expirationTimeChanged()"
						data-ng-init="advOptCtrl.model.minutesRetainUntil = (advOptCtrl.model.minutesRetainUntil > 1 ? advOptCtrl.model.minutesRetainUntil : 1)" />
					<cv:msg key="label.hours" bundle="restore" />
					<span class="help-block"
						data-ng-if="advOptCtrl.invalidExpTime.message"> <i
						class="ion-alert-circled">{{advOptCtrl.invalidExpTime.message}}</i>
					</span>
				</div>
			</div>
<%-- 			<!-- LIVE MOUNT OPTIONS TOGGLE -->
	 			<div class="form-group col-xs-12" data-ng-if="advOptCtrl.isVMware()"
						data-ng-disabled="advOptCtrl.model.enableVirtualLabs">
						<toggle-control status="advOptCtrl.showLiveMount"
							data-ng-click="advOptCtrl.manageLiveMountOptionsActivity()"
						title="Enable/disable <cv:msg key='label.liveMountOptions' bundle='restore' />"></toggle-control>
					&nbsp; &nbsp; <span class="no-padding"> <cv:msg
							key="label.liveMountOptions" bundle="restore" /></span>
				</div> --%>

				<div class="form-group col-xs-12" data-ng-if="!advOptCtrl.isHyperv() && !advOptCtrl.isVMware">
				<span class="no-padding">
					<cv:msg key="label.liveMountOptions" bundle="restore" />
				</span>
				</div>
				<!-- Media agent label -->
				<div class="form-group" data-ng-if="advOptCtrl.showLiveMountFlag && !advOptCtrl.isHyperv()">
					<div class="col-xs-12 col-md-5 col-lg-5">
						<div class="'margin-left-15' : advOptCtrl.isRegularPolicy">
						<label for="mediaAgent"> <cv:msg key="label.mediaAgent"
											bundle="storage" /> <span class="optional-text"><cv:msg
								key="label.optional" bundle="restore" /> </span>
							</label>
					</div>
					</div>
					<!-- Media agent drop down -->
					<div class="col-xs-12 col-md-7 col-lg-7">
					<isteven-multi-select data-input-model="advOptCtrl.mediaAgentLists"
								data-output-model="advOptCtrl.mediaAgentList"
								button-label="displayName" item-label="displayName"
								tick-property="selected" id="mediaAgent" name="mediaAgent"
						max-height="400px" group-property="header" selection-mode="single"
								on-close="advOptCtrl.mediaAgentListChanged()"
								translation="advOptCtrl.localLangMediaAgent">
							</isteven-multi-select>
						</div>
					</div>
				<!-- Migrate VMs toggle -->
			<div class="form-group col-xs-12" data-ng-if="advOptCtrl.isVMware()"
				data-ng-disabled="advOptCtrl.expirationTime=='Hours'">
					<toggle-control status="advOptCtrl.migrateVms"
						data-ng-click="advOptCtrl.managemigrateVmsActivity()"
						title="Enable/disable <cv:msg key='label.migrateVMs' bundle='restore' />">
				</toggle-control>
				&nbsp; <span class="no-padding"><cv:msg
							key="label.migrateVMs" bundle="restore" /></span>
			</div>
		</div>
	</div>
</div>
