<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vmManagement"></cv:cvMessages>
</script>
<div class="panel-body">

	<div class="form-group">
		<label class="col-xs-12 col-md-5" for="clientGroup">
			<cv-help-text help-label="label.clientGroups" help-text="'<cv:msg key='label.serverGroupInfo' bundle='vmManagement'/>'" />
		</label>
		<div class="col-xs-12 col-md-7">
			<isteven-multi-select
				input-model="asOut.model.clientGroups"
			  	output-model="asOut.model.clientGroup"
			  	button-label="name"
			  	item-label="name"
			  	selection-mode="single"
   				tick-property="selected"
   				class="isteven-multi-select user-group-select"
   				id="clientGroup"
   				name="clientGroup"
   				directive-id="clientGroup"
   				max-labels="1"
   				helper-elements="filter"
   				search-property="name"
   				on-item-click="asOut.setClientGroup(data)">
			</isteven-multi-select>
			<span class="help-block"
				data-ng-show="formController.$submitted && (!asOut.model.clientGroup || asOut.model.clientGroup.length == 0)">
				<i class="ion-alert-circled"></i>
				<cv:msg key="label.selectClientGroup" bundle="vmManagement" />
			</span>
		</div>
	</div>

	<div class="form-group" data-ng-if="!asOut.kubernetesOptions && !asOut.isAzureRM">
		<label class="col-xs-12 col-md-5" for="role" >
			<cv-help-text help-label="label.IAMRole" help-text="'<cv:msg key='label.IAMroleInfo' bundle='vmManagement'/>'" />
		</label>
		<div class="col-xs-12 col-md-7">
			<isteven-multi-select
				input-model="asOut.model.roles"
   				output-model="asOut.model.role"
  				button-label="name"
				item-label="name"
				selection-mode="single"
   				tick-property="selected"
   				class="isteven-multi-select user-group-select"
   				id="role"
   				name="role"
   				directive-id="role"
   				max-labels="1"
   				helper-elements="filter"
   				search-property="name"
   				on-item-click="asOut.setIAMRole(data)">
			</isteven-multi-select>
			<span class="help-block"
				data-ng-show="formController.$submitted && (!asOut.model.role || asOut.model.role.length == 0)">
				<i class="ion-alert-circled"></i>
				<cv:msg key="label.selectIAMRole" bundle="vmManagement" />
			</span>
		</div>
	</div>

	<div class="form-group" data-ng-if="asOut.isAzureRM">
		<label class="col-xs-12 col-md-5" for="role" >
			<cv:msg key="label.resourceGroup" bundle="restore" />
		</label>
		<div class="col-xs-12 col-md-7">
			<isteven-multi-select
				input-model="asOut.model.azureResourceGroupList"
   				output-model="asOut.model.azureResourceGroup"
  				button-label="displayName"
				item-label="displayName"
				selection-mode="single"
   				tick-property="selected"
   				class="isteven-multi-select user-group-select"
   				id="resourceGroup"
   				name="resourceGroup"
   				directive-id="resourceGroup"
   				max-labels="1"
   				helper-elements="filter"
   				search-property=displayName
   				on-item-click="asOut.setResourceGroup(data)">
			</isteven-multi-select>
			<span class="help-block"
				data-ng-show="formController.$submitted && (!asOut.model.azureResourceGroup || asOut.model.azureResourceGroup.length == 0)">
				<i class="ion-alert-circled"></i>
				<cv:msg key="error.resourceGroup" bundle="restore" />
			</span>
		</div>
	</div>
	<div>
		<cv-regions data-ng-if="asOut.policyDetails && !asOut.kubernetesOptions"
			server-id="asOut.serverId" policy-details="asOut.policyDetails">
		</cv-regions>
	</div>

	<cv-plain-accordion accordion-label="label.advancedSettings" collapsed="asOut.advancedSettingsAccordion">
        <div class="form-group" data-ng-if="!asOut.kubernetesOptions">
        	<div class="col-xs-12">
				<!-- <cv-toggle value="asOut.policyDetails.autoSelectInstanceType"
					toggle-label="label.autoSelectInstanceType">
				</cv-toggle> -->
				<toggle-control
					status="asOut.model.autoSelectInstanceType ? 'enabled-activity' : 'disabled-activity'"
					title="<cv:msg key='label.autoSelectInstanceType' bundle='restore'/>"
					ng-click="asOut.autoSelectInstanceTypeClick()"></toggle-control>
				<label class="margin-left-10">
					<span data-ng-if="!asOut.isAzureRM">
	        			<cv:msg key='label.autoSelectInstanceType' bundle='restore'/>
	        		</span>
	        		<span data-ng-if="asOut.isAzureRM">
						<cv:msg key='label.autoSelectVMSize' bundle='vmManagement'/>
	        		</span>
				</label>
			</div>
			<div data-ng-show="!asOut.model.autoSelectInstanceType">
	        	<label class="col-xs-12 col-md-5" for="instanceType" >
	        		<span data-ng-if="!asOut.isAzureRM">
	        			<cv-help-text help-label="label.instanceType" help-text="'<cv:msg key='label.instanceTypeInfo'  bundle='vmManagement'/>'" />
	        		</span>
	        		<span data-ng-if="asOut.isAzureRM">
	        			<cv-help-text help-label="label.vmSize" help-text="'<cv:msg key='label.vmSizeInfo'  bundle='vmManagement'/>'" />
	        		</span>
				</label>
				<div class="col-xs-12 col-md-7">
					<isteven-multi-select
						input-model="asOut.model.instanceTypes"
						output-model="asOut.model.instanceType"
					  	button-label="name"
					  	item-label="name"
					  	selection-mode="single"
		   				tick-property="selected"
		   				class="isteven-multi-select user-group-select"
		   				id="instanceType"
		   				name="instanceType"
		   				directive-id="instanceType"
		   				max-labels="1"
		   				helper-elements="filter"
		   				search-property="name"
		   				on-item-click="asOut.setInstanceType(data)">
					</isteven-multi-select>
					<span class="help-block"
						data-ng-show="cv.autoScaleProxyConfigureForm.getAttempted() && (!asOut.model.instanceType || asOut.model.instanceType.length == 0)">
						<i class="ion-alert-circled"></i>
						<span data-ng-if="!asOut.isAzureRM">
							<cv:msg key="label.setInstanceType" bundle="vmManagement" />
						</span>
				        <span data-ng-if="asOut.isAzureRM">
							<cv:msg key="placeholder.selectVMSize" bundle="restore" />
						</span>
					</span>
				</div>
			</div>
		</div>
		<!--MR : 265944 AutoScale proxy changes from project feedback, changing expiration time label to idle time and hiding this option for now, as its should be 1 hour by default
        <div class="form-group">
        	<label class="col-xs-12 col-md-5" for="expirationTime">
        		<cv-help-text help-label="<cv:msg key='label.idleTime' bundle='vmManagement'/>" help-text="'<cv:msg key='label.expirationTimeInfo' bundle='vmManagement'/>'" />
			</label>
			<div class="col-xs-12 col-md-7">
				<input type="number" name="expirationTime" id="expirationTime" data-ng-model="asOut.policyDetails.expirationTime" min="1" max="100" required/><label><cv:msg key="label.hours" bundle="restore"/></label>
				<span class="help-block"
					data-ng-show="formController.expirationTime.$invalid">
					<i class="ion-alert-circled"></i>
					<cv:msg key="error.validRange1to100" bundle="vmManagement" />
				</span>
			</div>
		</div>
		  -->
		<div class="form-group">
			<label class="col-xs-12 col-md-5" for="maxNoOFVMs">
				<cv-help-text help-label="label.maxNoOfProxies" help-text="'<cv:msg key='label.maxNoOfProxiesInfo' bundle='vmManagement' />'" />
			</label>
			<div class="col-xs-12 col-md-7">
				<input type="number" class="temporary-enabled" id="maxNoOFVMs" name="maxNoOFVMs"
				min="1" max="100" data-ng-model="asOut.policyDetails.scaleOption.scaleOutParam.maxVMthreshold" ng-required>
				<span class="help-block"
					data-ng-show="formController.maxNoOFVMs.$invalid">
					<i class="ion-alert-circled"></i>
					<cv:msg key="error.validRange1to100" bundle="vmManagement" />
				</span>
			</div>
		</div>
		<div class="form-group" data-ng-if="!asOut.kubernetesOptions">
			<div class="col-xs-12">
				<cv-toggle value="asOut.policyDetails.isPublicIPSettingsAllowed"
					toggle-label="label.publicIP">
				</cv-toggle>
			</div>
		</div>
	</cv-plain-accordion>
</div>