import { vmManagementAppModule } from 'common/js/modules';

var vmManagementMod = vmManagementAppModule;
vmManagementMod.service('vmLifeCylePolicyService', [
	'$http',
	function($http) {
		this.getGatewayTemplates = function(clientId, instanceId, hostNameOrCluster, objType) {
			var params = 'clientId=' + clientId + '&instanceId=' + instanceId;
			if (!!hostNameOrCluster && !!objType) {
				params += '&hostNameOrCluster=' + hostNameOrCluster + '&objType=' + objType;
			}
			return $http.get('getTemplates.do?' + params);
		};

		this.createHedvigDatastore = function(virtualMachineOption) {
			let vmProvisioningOptionRequest = {
				operationType: 60, //CREATE_DATASTORE
				virtualMachineOption: [virtualMachineOption]
			};

			let url = cv.contextPath + '/proxy/HedvigDatastore';
			return $http({
				url: url,
				method: 'POST',
				data: JSON.stringify(vmProvisioningOptionRequest),
				headers: {
					'Content-Type': 'application/json',
					Accept: 'application/json'
				}
			});
		};

		this.getHedvigDatastoresList = function(hypervisorId, vmHost, propertyLevels) {
			let url = cv.contextPath + '/proxy/HedVigDatastore';

			if (!propertyLevels) {
				propertyLevels = 0; //basic details
			}
			url += '?propertyLevels=' + propertyLevels;

			if (!!hypervisorId) {
				url += '&clientId=' + hypervisorId;
			}

			if (!!vmHost) {
				url += '&VMHost=' + vmHost;
			}

			//<?xml version="1.0" encoding="UTF-8" standalone="no" ?><Ida_GetHedvigDataStoreReq VMHost="" propertyLevels="0"><Hypervisordetails clientId="0"/></Ida_GetHedvigDataStoreReq>
			return $http({
				method: 'GET',
				url: url
			});
		};
	}
]);

export default vmManagementMod;
