import { vmManagementAppModule } from 'common/js/modules';

var vmManagementMod = vmManagementAppModule;
vmManagementMod.service('virtualMachineService', [
	'$http',
	'$q',
	function($http, $q) {
		this.getVirtualMachines = function(vmEntities, policyId, isLiveMount, replicationId, vAppId) {
			if (!policyId) {
				policyId = 0;
			}
			if (!replicationId) {
				replicationId = 0;
			}
			if (!vAppId) {
				vAppId = 0;
			}
			return $http.post('getVirtualMachines.do', {
				vmEntities: vmEntities,
				policyId: policyId,
				isLiveMount: isLiveMount,
				replicationId: replicationId,
				vAppId: vAppId
			});
		};

		this.performVMOperation = function(vmEntity, instanceId, operationType, vmLocation, policyId, expiration) {
			return $http.post('vmOperation.do', {
				vmEntity: vmEntity,
				instanceId: instanceId,
				operationType: operationType,
				vmLocation: vmLocation,
				policyId: policyId,
				expiration: expiration
			});
		};
	}
]);

export default vmManagementMod;
