import 'modules/servers/js/services/servers.svc.js';
import 'vsa/js/constants/servers.constants.js';
import 'storage/js/services/storage.svc.js';

import { vsaAppServerModule } from 'common/js/modules';

var serverMod = vsaAppServerModule;
serverMod.factory('vmLifeCyclePolicyFactory', [
	'$uibModal',
	'cvToaster',
	'cvLoc',
	'cvUtil',
	'$state',
	'$q',
	'serverService',
	'storageService',
	'VSA_VENDOR',
	function($modal, cvToaster, cvLoc, cvUtil, $state, $q, serverService, storageService, VSA_VENDOR) {
		var factory = {};
		//var self = this;
		factory.policyTypes = {
			VMWARE: 0,
			VMWARE_LIVEMOUNT: 4,
			RHEV: 9,
			VMW_BACKUP_LABTEMPLATE: 13,
			ORACLE_CLOUD_INFRASTRUCTURE: 15,
			AMAZON: 1,
			AZURE_RESOURCE_MANAGER: 7,
			KUBERNETES: 19
		};

		var toggleStatus = {
			enable: 'enabled-activity',
			disable: 'disabled-activity'
		};

		factory.getVendorByPolicyType = function(policyType) {
			switch (policyType) {
				case 'ORACLE_CLOUD_INFRASTRUCTURE':
				case factory.policyTypes.ORACLE_CLOUD_INFRASTRUCTURE:
					return VSA_VENDOR.ORACLECLOUDINFRASTRUCTURE;
				case 'VMWARE':
				case 'VMW_LIVEMOUNT':
				case 'VMW_BACKUP_LABTEMPLATE':
				case factory.policyTypes.VMWARE:
				case factory.policyTypes.VMWARE_LIVEMOUNT:
				case factory.policyTypes.VMW_BACKUP_LABTEMPLATE:
					return VSA_VENDOR.VMWARE;
				case 'RHEV':
				case factory.policyTypes.RHEV:
					return VSA_VENDOR.REDHAT;
				case 'AMAZON':
				case factory.policyTypes.AMAZON:
					return VSA_VENDOR.AMAZON;
				case 'MICROSOFT':
					return VSA_VENDOR.HYPERV;
				case 'AZURE_RESOURCE_MANAGER':
				case factory.policyTypes.AZURE_RESOURCE_MANAGER:
					return VSA_VENDOR.AZURERM;
				default:
					return VSA_VENDOR.VMWARE;
			}
		};

		factory.isOracleCloudInfrastructure = function(vendor) {
			if (vendor === 'ORACLE_CLOUD_INFRASTRUCTURE') {
				return true;
			}
			return false;
		};

		factory.checkToggleStatus = function(parameter) {
			var action = null;
			action = parameter == toggleStatus.enable ? 'disable' : 'enable';
			return action == 'enable' ? toggleStatus.enable : toggleStatus.disable;
		};

		factory.isAmazon = function(vendor) {
			if (vendor === 'AMAZON') {
				return true;
			}
			return false;
		};

		factory.isVMware = function(vendor) {
			if (vendor === 'VMW') {
				return true;
			}
			return false;
		};

		factory.isRedHat = function(vendor) {
			if (vendor === 'REDHAT') {
				return true;
			}
			return false;
		};
		factory.isHyperv = function(vendor) {
			return vendor === 'MICROSOFT';
		};

		factory.isAzureRM = function(vendor) {
			if (vendor === VSA_VENDOR.AZURERM) {
				return true;
			}
			return false;
		};

		factory.isApplianceEnabledCS = function(model) {
			return factory.isRedHat(model.vendor) && model.isCSApplianceVM && model.showLiveMount;
		};

		factory.groupCloudMediaAgents = function(agents) {
			var cloudMediaAgents = {};
			var mediaAgent = [];
			if (agents && agents.length) {
				for (var i = 0; i < agents.length; i++) {
					mediaAgent = agents[i];
					for (var j = 0; j < mediaAgent.length; j++) {
						if (mediaAgent[j].hostName) {
							if (!cloudMediaAgents['serverGroups']) {
								cloudMediaAgents['serverGroups'] = [];
							}
							cloudMediaAgents['serverGroups'].push(mediaAgent[j]);
						} else {
							if (!cloudMediaAgents['mediaAgents']) {
								cloudMediaAgents['mediaAgents'] = [];
							}
							cloudMediaAgents['mediaAgents'].push(mediaAgent[j]);
						}
					}
				}
			}
			return cloudMediaAgents;
		};

		factory.groupCloudAgents = function(vendor) {
			$q.agentsList = [];
			$q.agents = [];
			var defer = $q.defer();
			$q.all([serverService.getServersByVendor(vendor), storageService.getMediaAgentList('NONE')]).then(
				data => {
					for (var i in data) {
						$q.agentsList.push(data[i].data);
					}
					var groupedAgents = factory.groupCloudMediaAgents($q.agentsList);
					for (var i in groupedAgents) {
						if (groupedAgents[i] && groupedAgents[i].length) {
							$q.agents.push({
								name: cvLoc('label.' + i),
								msGroup: true
							});
							groupedAgents[i].forEach(function(el) {
								$q.agents.push(el);
							});
							$q.agents.push({ msGroup: false });
						}
					}

					defer.resolve($q.agents);
				},
				function(err) {
					defer.reject(err);
				}
			);

			return defer.promise;
		};

		//This function allows to get policy type for the vendor
		factory.getPolicyTypeForVendor = function(vendor, model) {
			switch (vendor) {
				case VSA_VENDOR.ORACLECLOUDINFRASTRUCTURE:
					return factory.policyTypes.ORACLE_CLOUD_INFRASTRUCTURE;
				case VSA_VENDOR.VMWARE:
					var policyType = factory.policyTypes.VMWARE_LIVEMOUNT;
					if (model.enableVirtualLabs) {
						policyType = factory.policyTypes.VMW_BACKUP_LABTEMPLATE;
					} else if (!model.showLiveMount) {
						policyType = factory.policyTypes.VMWARE;
					}
					return policyType;
				case VSA_VENDOR.REDHAT:
					return factory.policyTypes.RHEV;
				case VSA_VENDOR.AMAZON:
					return factory.policyTypes.AMAZON;
				case VSA_VENDOR.AZURERM:
					return factory.policyTypes.AZURE_RESOURCE_MANAGER;
				case VSA_VENDOR.KUBERNETES:
					return factory.policyTypes.KUBERNETES;
				default:
					return factory.policyTypes.VMWARE_LIVEMOUNT;
			}
		};

		factory.getPolicyTypeEnumByPolicyType = function(policyType) {
			switch (policyType) {
				case 'ORACLE_CLOUD_INFRASTRUCTURE':
					return factory.policyTypes.ORACLE_CLOUD_INFRASTRUCTURE;
				case 'VMWARE':
					return factory.policyTypes.VMWARE;
				case 'VMW_LIVEMOUNT':
					return factory.policyTypes.VMWARE_LIVEMOUNT;
				case 'VMW_BACKUP_LABTEMPLATE':
					return factory.policyTypes.VMW_BACKUP_LABTEMPLATE;
				case 'RHEV':
					return factory.policyTypes.RHEV;
				case 'AMAZON':
					return factory.policyTypes.AMAZON;
				default:
					return factory.policyTypes.VMWARE;
			}
		};
		/*
		 * getDestinationHostDisplayName - return entity.name if exist not return from displayName
		 */
		factory.getDestinationHostDisplayName = function(destinationHost) {
			var destinationHostName = '';
			if (destinationHost) {
				if (!!destinationHost.entity && !!destinationHost.entity.name) {
					destinationHostName = destinationHost.entity.name;
				} else if (!!destinationHost.displayName) {
					destinationHostName = destinationHost.displayName;
				}
			}
			return destinationHostName;
		};

		factory.getCompartmentGuidAndAvailabilityDomain = function(hostname, availabilityDomainObj) {
			var spliter = '!';
			var availabilityDomain =
				!!availabilityDomainObj && !!availabilityDomainObj.name ? availabilityDomainObj.name : '';
			//availabilityDomain  has Region:availabilityDomainId need to split them using delimiter (:) colon.
			var aDSplit = availabilityDomain.split(':');
			availabilityDomain = aDSplit.length > 1 ? aDSplit[1] : availabilityDomain;
			var compartNameAndAvailabilityDomain = !!availabilityDomain ? hostname + spliter + availabilityDomain : hostname;
			return compartNameAndAvailabilityDomain;
		};
		factory.savePolicy = function(model, browse, vendor) {
			var data = {
				entity: {
					vmAllocPolicyName: model.policyName
				},
				destinationHyperV: {
					clientId: model.serverDetails.clientId,
					clientName: model.serverDetails.clientName
				},
				enableEditVMName: model.displayNamePrefixSuffix ? true : false,
				vmNameEditString: model.displayNamePrefixSuffix,
				vmNameEditType: model.displayNamePrefixSuffix ? model.prefixSuffixSelector.toUpperCase() : null
			};
			data.entity.policyType = factory.getPolicyTypeForVendor(model.vendor, model);

			var esxServers;
			if (factory.isOracleCloudInfrastructure(vendor)) {
				esxServers = [
					{
						esxServerName: model.compartment.displayName
							? model.compartment.guid + '|' + model.compartment.displayName
							: model.compartment.guid
					}
				];
				var amazonPolicy = {};
				var availabilityZones = [
					{
						availabilityZoneName: browse.availabilityDomain.name
					}
				];

				amazonPolicy.availabilityZones = availabilityZones;

				var instanceTypes = [];

				angular.forEach(browse.selectedInstanceTypes, function(type) {
					instanceTypes.push({
						instanceType: {
							vmInstanceTypeName: type.id
						},
						cpuCores: type.numOfCpu,
						memory: type.memoryInMB
					});
				});
				amazonPolicy.instanceType = instanceTypes;
				data.amazonPolicy = amazonPolicy;

				data.maxDiscs = model.noOfDisks;
				data.maxDiskSpace = model.maxDiskSize;
				var subnets = [];
				angular.forEach(browse.selectedSubnets, function(subnet) {
					subnets.push({
						name: subnet.name,
						label: subnet.name,
						subnetId: subnet.subnetId,
						subnetMask: subnet.subnetMask,
						networkAddress: subnet.networkAddress
					});
				});
				var networkInfo = [
					{
						label: browse.selectedNetwork.networkName,
						networkName: browse.selectedNetwork.networkId,
						subnetNames: subnets
					}
				];
				data.networkInfo = networkInfo;

				var images = [];
				angular.forEach(browse.selectedImages, function(image) {
					images.push({
						vmName: image.name,
						vmGUID: image.strGUID
					});
				});
				data.templates = images;

				var keyPair = {
					name: model.sshKeyFileName,
					path: model.sshKeyData
				};
				data.keyPairs = [keyPair];
			} else if (factory.isAmazon(vendor)) {
				//set the VmPolicyApplicationType
				data.vmPolicyAppType = 2;
				if (
					model.durationHour &&
					model.maxCpuThreshold &&
					model.maxMemoryThreshold &&
					model.minCpuThreshold &&
					model.minMemoryThreshold
				) {
					data.scaleOption = {};
					data.scaleOption.durationHrs = model.durationHour;
					data.scaleOption.maxCPUThresholdPercent = model.maxCpuThreshold;
					data.scaleOption.maxMemThresholdPercent = model.maxMemoryThreshold;
					data.scaleOption.minCPUThresholdPercent = model.minCpuThreshold;
					data.scaleOption.minMemThresholdPercent = model.minMemoryThreshold;
					data.entity.vmAllocPolicyId = model.vmAllocationPolicyId;
					data.scaleOption.autoScaleUp = model.autoScaleUp === toggleStatus.enable ? true : false;
					data.scaleOption.autoScaleOut = model.autoScaleOut === toggleStatus.enable ? true : false;
					data.scaleOption.useForAutoDeployment = model.autoDeployment === toggleStatus.enable ? true : false;
				}

				if (model.amazonPolicy) {
					data.amazonPolicy = model.amazonPolicy;
				}

				if (model.securityGroups) {
					data.securityGroups = [];
					data.securityGroups.push(model.securityGroups);
				}

				if (model.vmCredentials) {
					if (typeof model.vmCredentials.password === 'string') {
						var passwordBytes = cvUtil.getBytes(model.vmCredentials.password);
					}
					data.vmCredentials = {
						userName: model.vmCredentials.userName,
						password: passwordBytes ? passwordBytes : model.vmCredentials.password
					};
				}

				if (model.associatedClientGroup) {
					data.associatedClientGroup = model.associatedClientGroup;
				}

				if (model.roleInfo) {
					data.roleInfo = model.roleInfo;
				}
			} else {
				if (!!browse) {
					esxServers = [
						{
							esxServerName: factory.getDestinationHostDisplayName(browse.destinationHost)
						}
					];

					if (browse.dataStore && browse.dataStore.dataStoreName) {
						data.dataStores = [
							{
								dataStoreName: browse.dataStore.dataStoreName
							}
						];
					}

					if (model.enableVirtualLabs) {
						if (model.configureExistingNetwork && !!browse.existingNetwork && !!browse.existingNetwork.networkName) {
							data.networkNames = [];
							data.networkNames.push(browse.existingNetwork.networkName);
						}
						if (model.createIsolatedNetwork) {
							if (
								model.showGatewayOptions &&
								browse.gatewayTemplate &&
								(browse.gatewayTemplate.vmGUID || browse.gatewayTemplate.entity)
							) {
								if (!data.gatewayTemplate) {
									data.gatewayTemplate = {};
								}
								data.gatewayTemplate.vmName = browse.gatewayTemplate.vmName
									? browse.gatewayTemplate.vmName
									: browse.gatewayTemplate.entity.gateway.name;
								data.gatewayTemplate.vmGUID = browse.gatewayTemplate.vmGUID
									? browse.gatewayTemplate.vmGUID
									: browse.gatewayTemplate.entity.gateway.strGUID;
								if (!!browse.gatewayNetwork && !!browse.gatewayNetwork.networkName) {
									data.primaryGatewayNetwork = browse.gatewayNetwork.networkName;
								}
							}
							data.createIsolatedNetwork = true;
						} else {
							data.createIsolatedNetwork = false;
						}
					} else {
						//data.resourcePoolPath =browse.availabilityDomain.resourcePoolPath;
						if (browse.selectedNetwork && browse.selectedNetwork.length > 0) {
							data.networkNames = [];
							angular.forEach(browse.selectedNetwork, function(network) {
								/*
								 * commenting this in sp12, as planning to give support for java gui policies
								 * at adminconsole var networkInfo = { 'sourceNetwork': 'Any Network',
								 * destinationNetwork: network.networkName };
								 */
								data.networkNames.push(network.networkName);
							});
						}
					}

					if (model.showVirtualizeMe && (!!browse.isoInfo.windows || !!browse.isoInfo.unix)) {
						data.isoInfo = [];
						if (!!browse.isoInfo.windows) {
							data.isoInfo.push(browse.isoInfo.windows);
						}
						if (!!browse.isoInfo.unix) {
							data.isoInfo.push(browse.isoInfo.unix);
						}
						if (model.enableVirtualLabs && !!model.restoreNetwork && !!model.restoreNetwork.networkName) {
							data.restoreNetworkName = model.restoreNetwork.networkName;
						}
						data.maxCores = model.noOfCPUs;
						data.maxMemory = model.maxMemory;
					}

					if (factory.isApplianceEnabledCS(model)) {
						data.maxCores = model.noOfCPUs;
						data.maxMemory = model.maxMemory;
					}

					// set minutesRetainUntil/daysRetainUntil when showLiveMount is enabled.
					if (model.showLiveMount) {
						data.isLiveMountEnabled = true;
						if (!!model.minutesRetainUntil && !model.enableVirtualLabs) {
							data.minutesRetainUntil = model.minutesRetainUntil;
							data.daysRetainUntil = null;
						}
						/*
						 * hiding virtual lab settings for sp14 else{ // if live mount is set and it is not
						 * going to expire in hours. Then, migrateVMs should be set by default with 1 hour
						 * gap. data.migrateVMs = model.migrateVMs; data.waitBeforeMigrationInHours = 1; }
						 */
						/*
						 * else if (model.expirationTime === "Days") { data.daysRetainUntil =
						 * model.daysRetainUntil; data.minutesRetainUntil = null; }
						 */

						if (model.enableMediaAgent && model.mediaAgent && model.mediaAgent.displayName) {
							data.mediaAgent = {
								clientName: model.mediaAgent.mediaAgentName,
								clientId: model.mediaAgent.mediaAgentId
							};
						}
					}
				}
			}

			if (factory.isVMware(vendor)) {
				var dataCenterEntity = {};

				var DATACENTER = 'DATACENTER';
				var host = browse.destinationHost;
				if (host.parent && host.parent.type === DATACENTER) {
					dataCenterEntity = host.parent.entity;
				} else if (host.parent && host.parent.parent && host.parent.parent.type === DATACENTER) {
					dataCenterEntity = host.parent.parent.entity;
				}

				if (dataCenterEntity.name) {
					data.dataCenter = {};
					data.dataCenter.dataCenterName = dataCenterEntity.name;
					data.dataCenter.GUID = dataCenterEntity.strGUID; // we can store strGUID for edit template edits from datacenter level.
					if (dataCenterEntity.dataCenterId > 0) {
						data.dataCenter.dataCenterId = dataCenterEntity.dataCenterId;
					}
				}
			}

			if (model.enableDecommission && (model.enableVirtualLabs || factory.isOracleCloudInfrastructure(vendor))) {
				data.daysRetainUntil = model.daysRetainUntil;
				data.deletionGracePeriodDays = model.deletionGracePeriodDays;
				data.minutesRetainUntil = null;
			}

			/*
			 * if(model.migrateVMs){ data.migrateVMs = model.migrateVMs; data.waitBeforeMigrationInHours =
			 * model.waitBeforeMigrationInHours; }
			 */
			data.maxVMQuota = model.noOfVms;
			data.esxServers = esxServers;

			if (!data.vmPolicyAppType) {
				data.vmPolicyAppType = 1;
			}

			return data;
		};

		return factory;
	}
]);
export default serverMod;
