import 'modules/vmManagement/js/services/virtualMachine.svc.js';
import 'vsa/js/services/restore.svc.js';
import 'vsa/js/factories/vmActions.factory.js';
import 'common/js/icon-constant.js';

import { vmManagementAppModule } from 'common/js/modules';

/**
 *
 */

var vmManagementMod = vmManagementAppModule;

vmManagementMod.factory('virtualMachineFactory', [
	'cvToaster',
	'$state',
	'$stateParams',
	'$uibModal',
	'$dialogs',
	'cvLoc',
	'virtualMachineService',
	'restoreService',
	'VirtualMachineConstants',
	'vmFactory',
	'VENDORS',
	'cvPermissionFactory',
	'cvActionsEventFactory',
	'vendorTypes',
	'VSA_VENDOR',
	'SERVER_ICONS',
	'VSA_SOLUTIONS_STATE',
	function virtualMachineFactory(
		cvToaster,
		$state,
		$stateParams,
		$uibModal,
		$dialogs,
		cvLoc,
		virtualMachineService,
		restoreService,
		VirtualMachineConstants,
		vmFactory,
		VENDORS,
		cvPermissionFactory,
		cvActionsEventFactory,
		vendorTypes,
		VSA_VENDOR,
		SERVER_ICONS,
		VSA_SOLUTIONS_STATE
	) {
		virtualMachineFactory.virtualMachines;
		virtualMachineFactory.vmOperationResponse;
		virtualMachineFactory.taosterTTL = 10000;

		var self = this;
		if (
			cv &&
			cv.additionalSettings &&
			cv.additionalSettings.AdminConsole &&
			cv.additionalSettings.AdminConsole.enableVMProvisioning
		) {
			virtualMachineFactory.supportedHypervisors = ['VMW', 'AZURE', 'AZURE_V2', 'AMAZON', 'MICROSOFT'];
		} else {
			virtualMachineFactory.supportedHypervisors = ['VMW'];
		}

		virtualMachineFactory.getVmEntity = function(vmGUID, vmName) {
			var entity = {
				vmName: vmName,
				vmGUID: vmGUID
			};
			return entity;
		};
		virtualMachineFactory.getVirtualMachines = function(policyId, vmGUID, vmName, isLiveMount, replicationId, vAppId) {
			var vmEntities = [];
			if (vmGUID) {
				var vmEntity = virtualMachineFactory.getVmEntity(vmGUID, vmName);
				vmEntities.push(vmEntity);
			}
			return virtualMachineService
				.getVirtualMachines(JSON.stringify(vmEntities), policyId, isLiveMount, replicationId, vAppId)
				.success(function(data) {
					virtualMachineFactory.virtualMachines = data;
				})
				.error(function(e) {
					cvToaster.showErrorMessage({
						ttl: virtualMachineFactory.taosterTTL,
						message: e ? e : cvLoc('generic_error')
					});
				});
		};

		//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
		// get image for OS
		////Use constant "OSType"
		virtualMachineFactory.getIconForOS = function(osType) {
			let image = SERVER_ICONS.UNKNOWN; //default icon\image

			switch (_.toLower(osType)) {
				//				case _.toLower(VirtualMachineConstants.OSType[0]):	//CLIENT_PLATFORM_OSTYPE_UNKNOWN
				//					image= SERVER_ICONS.UNKNOWN;
				//					break;
				case _.toLower(VirtualMachineConstants.OSType[1]): //CLIENT_PLATFORM_OSTYPE_WINDOWS
					image = SERVER_ICONS.WINDOWS_COLOR;
					break;
				case _.toLower(VirtualMachineConstants.OSType[2]): //CLIENT_PLATFORM_OSTYPE_UNIX
					image = SERVER_ICONS.UNIX;
					break;
				case _.toLower(VirtualMachineConstants.OSType[3]): //CLIENT_PLATFORM_OSTYPE_NETWARE
					image = SERVER_ICONS.NETWARE;
					break;
				case _.toLower(VirtualMachineConstants.OSType[4]): //CLIENT_PLATFORM_OSTYPE_NAS_FILER
					image = SERVER_ICONS.NAS;
					break;
				case _.toLower(VirtualMachineConstants.OSType[5]): //CLIENT_PLATFORM_OSTYPE_DATA_ONTAP
					image = SERVER_ICONS.NETAPP;
					break;
			}
			return image;
		};
		//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
		virtualMachineFactory.getEntityListPageState = function(individualVM) {
			let entityListPageState = VSA_SOLUTIONS_STATE.USERVMS;
			if (_.get(individualVM, 'vendor', undefined) === VSA_VENDOR.KUBERNETES) {
				entityListPageState = VSA_SOLUTIONS_STATE.APPS;
			}
			return entityListPageState;
		};

		virtualMachineFactory.performVMOperation = function(
			vmGUID,
			vmName,
			instanceId,
			operationType,
			vmLocation,
			policyId,
			expiration
		) {
			var vmEntity = {};
			if (vmGUID) {
				var vmEntity = virtualMachineFactory.getVmEntity(vmGUID, vmName);
			}
			return virtualMachineService
				.performVMOperation(
					JSON.stringify(vmEntity),
					instanceId,
					operationType,
					JSON.stringify(vmLocation),
					policyId,
					expiration
				)
				.success(function(data) {
					virtualMachineFactory.vmOperationResponse = data;
					if (data.errorCode != 0) {
						cvToaster.showErrorMessage({
							ttl: virtualMachineFactory.taosterTTL,
							message: data.errorMessage ? data.errorMessage : cvLoc('generic_error')
						});
					}
				})
				.error(function(e) {
					cvToaster.showErrorMessage({
						ttl: virtualMachineFactory.taosterTTL,
						message: e ? e : cvLoc('generic_error')
					});
				});
		};

		virtualMachineFactory.getPolicyDetails = function(vmOperationDetails, callBackFunction) {
			if (vmOperationDetails && vmOperationDetails.policyId) {
				restoreService
					.getReplicationTarget(vmOperationDetails.policyId)
					.success(function(data) {
						if (data) {
							virtualMachineFactory.selectedPolicyDetails = data;
						} else {
							virtualMachineFactory.selectedPolicyDetails = {};
						}
						callBackFunction(vmOperationDetails, virtualMachineFactory.selectedPolicyDetails);
					})
					.error(function(e) {
						cvToaster.showErrorMessage({
							ttl: virtualMachineFactory.taosterTTL,
							message: e ? e : cvLoc('generic_error')
						});
					});
			} else {
				callBackFunction(vmOperationDetails);
			}
		};

		var vmOperationCallBackFunction = function(vmOperationDetails, policyDetails) {
			if (!policyDetails) {
				policyDetails = {};
			}
			if (VirtualMachineConstants.VMOperationType['RENEW_VM'] === vmOperationDetails.operationType) {
				vmOperationDetails.renewDefaultHours = 1;
				vmOperationDetails.renewMaxHours = 24;
				if (vmOperationDetails.isLiveMount) {
					vmOperationDetails.renewOpType = 'hours';
				} else {
					vmOperationDetails.renewOpType = 'days';
				}

				if (policyDetails.minutesRetainUntil && policyDetails.minutesRetainUntil > 0) {
					vmOperationDetails.renewOpType = 'hours';
					vmOperationDetails.renewMaxHours = policyDetails.minutesRetainUntil;
				} else if (policyDetails.daysRetainUntil && policyDetails.daysRetainUntil > 0) {
					vmOperationDetails.renewOpType = 'days';
					vmOperationDetails.renewMaxDays = policyDetails.daysRetainUntil;
				}
			}
			$uibModal.open({
				templateUrl: appUtil.appRoot + 'modules/vmManagement/partials/vmOperationDialog.jsp',
				backdrop: 'static',
				controller: [
					'$uibModalInstance',
					'vmOperationDetails',
					function($uibModalInstance, vApp) {
						virtualMachineFactory.vmOperationDetails = vmOperationDetails;
						virtualMachineFactory.closeModal = function() {
							$uibModalInstance.close();
						};
					}
				],
				resolve: {
					vmOperationDetails: function() {
						return vmOperationDetails;
					}
				}
			});
		};

		virtualMachineFactory.vmOperationDialog = function(vmOperationDetails) {
			if (VirtualMachineConstants.VMOperationType['RENEW_VM'] === vmOperationDetails.operationType) {
				virtualMachineFactory.getPolicyDetails(vmOperationDetails, vmOperationCallBackFunction);
			} else {
				vmOperationCallBackFunction(vmOperationDetails);
			}
		};

		virtualMachineFactory.virtualMachineSpecificActions = {
			//"LIVE_RECOVERY" : {
			//	label : cvLoc('header.restore.liveRecovery'),
			//	value : "LIVE_RECOVERY",
			//	permissionIds : []
			//},
			REMOVE: {
				label: cvLoc('label.globalActions.doNotBackup'),
				value: 'REMOVE',
				permissionIds: []
			},
			//"LIVE_MOUNT" : {
			//	label : cvLoc('action.livemount'),
			//	value : "LIVE_MOUNT",
			//	permissionIds : []
			//},
			ACTIVE_MOUNTS: {
				label: cvLoc('label.globalActions.viewActiveMounts'),
				value: 'ACTIVE_MOUNTS',
				permissionIds: []
			},
			REPLICATE: {
				label: cvLoc('label.globalActions.configureReplication'),
				value: 'REPLICATE',
				permissionIds: [3]
			},
			CHANGE_PLAN: {
				label: cvLoc('label.globalActions.associatePlan'),
				value: 'CHANGE_PLAN',
				permissionIds: [2]
			},
			CHANGE_COMPANY: {
				label: cvLoc('label.globalActions.changeCompany'),
				value: 'CHANGE_COMPANY'
			}
		};

		virtualMachineFactory.virtualMachineSpecificActionsHandler = function(
			value,
			entity,
			entityType,
			actionObject,
			entityId,
			entityName
		) {
			switch (value) {
				case 'BACKUP':
					vmFactory.showBackupOptions(entity);
					break;
				case 'RESTORE':
				case 'LIVE_RECOVERY':
					vmFactory.vmRestore(entity, actionObject.recoveryType);
					break;
				case 'REMOVE':
					vmFactory.removeVM(entity);
					break;
				case 'LIVE_MOUNT':
					vmFactory.liveMountVM(entity, actionObject.replicationTargets);
					break;
				case 'REPLICATE':
					vmFactory.replicateVM(entity);
					break;
				case 'CHANGE_PLAN': {
					let selectedVm = [];
					selectedVm.push(entity);
					vmFactory.changePlan(selectedVm, actionObject.ctrl);
					break;
				}
				case 'CHANGE_COMPANY':
					vmFactory.changeCompany(entity, _.get(actionObject, 'ctrl.refresh'));
					break;
			}
		};

		virtualMachineFactory.showReplicate = function(entity, vendorType) {
			return (
				entity &&
				entity.bkpEndTime &&
				entity.bkpStartTime &&
				_.get(VENDORS, vendorType) &&
				(vendorType === VENDORS.NUTANIX.type ? cvConfig.showNutanixReplication : true) &&
				!!$state.href('replicationGroups')
			); // show the replication option only user has access to replication group.
		};

		virtualMachineFactory.showRemoveVM = function(vendorType) {
			var skipForVendors = [VSA_VENDOR.KUBERNETES];
			return (
				cv.userRole !== 'Role_Tenant_User' &&
				cv.userRole !== 'Role_Restricted_User' &&
				!skipForVendors.includes(vendorType)
			);
		};

		virtualMachineFactory.getActions = (entity, ctrl) => {
			var arrayOfCommonActionsToOverrideUserVMList = [
				{
					BACKUP: {
						show: vmFactory.isBackupOptionValid(entity) && !entity.isDeleted,
						permissionIds: [12],
						groupId: 1,
						rank: 2,
						onClick: virtualMachineFactory.virtualMachineSpecificActionsHandler
					}
				},
				{
					RESTORE: {
						show: entity.subclientId && entity.vmBackupJob && vmFactory.isProtectedVM(entity),
						recoveryType: 'default',
						permissionIds: [20, 39, 42],
						showIfAtleastOnePermissionIsPresent: true,
						groupId: 1,
						rank: 1,
						onClick: virtualMachineFactory.virtualMachineSpecificActionsHandler
					}
				},
				{
					JOBS: {
						show: vmFactory.isProtectedVM(entity),
						href: cvActionsEventFactory.getBackupRestoreJobHref({
							vmGuid: encodeURIComponent(entity.strGUID),
							vmClientId: entity.client.clientId,
							vmName: entity.client.clientName
						}),
						groupId: 2,
						rank: 2
					}
				},
				{
					RETIRE: {
						show: entity.retireClientPhase === VirtualMachineConstants.RetireClientPhase[0],
						groupId: 4,
						rank: 1
					}
				},
				{
					DELETE: {
						show: entity.retireClientPhase === VirtualMachineConstants.RetireClientPhase[2],
						groupId: 4,
						rank: 1
					}
				},
				{
					RECONFIGURE: {
						show: entity.retireClientPhase === VirtualMachineConstants.RetireClientPhase[2],
						groupId: 4,
						rank: 2
					}
				},
				{
					MANAGE_TAGS: {
						permissionIds: [],
						label: cvLoc('label.manageTags'),
						show: cvConfig.enableTags,
						refreshGrid: !_.isNil(ctrl) && !_.isNil(ctrl.refresh) ? ctrl.refresh : null
					}
				}
			];
			var arrayOfUserVMSpecificActionsToOverrideUserVMList = [
				{
					REMOVE: {
						show:
							virtualMachineFactory.showRemoveVM(entity.vendor) && !entity.isDeleted && vmFactory.isProtectedVM(entity),
						permissionIds: [2],
						groupId: 2,
						rank: 3,
						onClick: virtualMachineFactory.virtualMachineSpecificActionsHandler
					}
				},
				{
					ACTIVE_MOUNTS: {
						show: vmFactory.isLiveMountVendorSupported(entity.vendor) && vmFactory.isProtectedVM(entity),
						groupId: 2,
						rank: 4,
						href: '#virtualMachines//' + entity.strGUID + '?isLiveMount=true'
					}
				},
				{
					REPLICATE: {
						show: virtualMachineFactory.showReplicate(entity, entity.vendor) && vmFactory.isProtectedVM(entity),
						groupId: 2,
						rank: 5,
						onClick: virtualMachineFactory.virtualMachineSpecificActionsHandler
					}
				},
				{
					CHANGE_PLAN: {
						show: true,
						ctrl: ctrl,
						groupId: 2,
						rank: 1,
						onClick: virtualMachineFactory.virtualMachineSpecificActionsHandler
					}
				},
				{
					CHANGE_COMPANY: {
						show: (cv.isMspAdmin || (cv.isReseller && cv.isTenantAdmin)) && cv.providers.length, //'Change company' is applicable for MSP admin or for 'Tenant Admin' if reseller mode is enabled and there is atleast one company
						groupId: 5,
						rank: 1,
						ctrl: ctrl,
						onClick: virtualMachineFactory.virtualMachineSpecificActionsHandler
					}
				}
			];

			return cvPermissionFactory
				.updateAndGetCommonActionsList(
					arrayOfCommonActionsToOverrideUserVMList,
					false,
					angular.copy(cvPermissionFactory.commonPermittedList)
				)
				.concat(
					cvPermissionFactory.updateAndGetCommonActionsList(
						arrayOfUserVMSpecificActionsToOverrideUserVMList,
						false,
						virtualMachineFactory.virtualMachineSpecificActions
					)
				);
		};

		virtualMachineFactory.convertResponse = obj => {
			if (angular.isDefined(obj.type)) {
				obj.type = VirtualMachineConstants.VSObjType[obj.type];
			}
			if (angular.isDefined(obj.vmStatus)) {
				obj.vmStatus = VirtualMachineConstants.VmStatusEnum[obj.vmStatus];
			}
			if (angular.isDefined(obj.vendor)) {
				obj.vendor = vendorTypes.getVendorName(obj.vendor);
			}
			if (angular.isDefined(obj.osType)) {
				obj.osType = VirtualMachineConstants.OSType[obj.osType];
			}
			if (angular.isDefined(obj.retireClientPhase)) {
				obj.retireClientPhase = VirtualMachineConstants.RetireClientPhase[obj.retireClientPhase];
			}
			return obj;
		};

		return virtualMachineFactory;
	}
]);

vmManagementMod.controller('vmOperationDialogController', [
	'$state',
	'cvLoc',
	'cvUtil',
	'virtualMachineFactory',
	function($state, cvLoc, cvUtil, virtualMachineFactory) {
		var self = this;
		self.vmOperationDetails = virtualMachineFactory.vmOperationDetails;
		self.operationTitle = 'VM Operation';
		self.expirationInHours = 1;
		if (self.vmOperationDetails.operationType === 'RENEW_VM') {
			self.operationTitle = cvLoc('label.renewVM');
		}

		var defaultStartTime = function() {
			var d = new Date();
			d.setHours(0);
			d.setMinutes(0);
			return d;
		};

		var defaultEndTime = function() {
			var d = new Date(2147483647000); // https://en.wikipedia.org/wiki/Year_2038_problem
			d.setHours(23);
			d.setMinutes(59);
			return d;
		};

		self.startDate = defaultStartTime();
		self.endDate = defaultEndTime();

		if (self.vmOperationDetails.renewOpType == 'hours') {
			self.expirationDateLabel = cvLoc('label.extendFor');
		} else {
			self.expirationDateLabel = cvLoc('label.expirationDate');
			var millSecondsWithMaxDays = Date.now();

			if (self.vmOperationDetails.renewMaxDays) {
				millSecondsWithMaxDays += 1000 * 60 * 60 * 24 * self.vmOperationDetails.renewMaxDays;
				self.selectionDate = new Date(millSecondsWithMaxDays);
				self.endDate = self.selectionDate;
			} else {
				millSecondsWithMaxDays += 1000 * 60 * 60 * 24 * 90;
				self.selectionDate = new Date(millSecondsWithMaxDays);
			}
		}

		self.datepicker = false;

		self.openDateSelection = function() {
			self.datepicker = true;
		};

		self.minDate = self.minDate ? null : new Date();

		self.checkMinDate = function() {
			if (self.minDate > self.startDate) {
				return self.minDate;
			}
			return self.endDate;
		};

		self.checkMaxDate = function() {
			return self.endDate;
		};

		self.closeModal = virtualMachineFactory.closeModal;
		var expiration = '';
		self.submit = function() {
			var validationPassed = true;
			if (self.vmOperationDetails.operationType === 'RENEW_VM') {
				var message = cvLoc('msg.invailddate');
				if (self.vmOperationDetails.renewOpType == 'hours') {
					if (!self.expirationInHours || self.expirationInHours == 0) {
						message = cvLoc('msg.invaildhour');
						validationPassed = false;
					} else if (self.expirationInHours > self.vmOperationDetails.renewMaxHours) {
						message = cvLoc('msg.exceedhours', self.vmOperationDetails.renewMaxHours);
						validationPassed = false;
					}
					expiration = self.expirationInHours;
				} else if (self.vmOperationDetails.renewOpType == 'days') {
					if (!self.selectionDate) {
						validationPassed = false;
					} else {
						expiration =
							self.selectionDate.getMonth() +
							1 +
							'/' +
							self.selectionDate.getDate() +
							'/' +
							self.selectionDate.getFullYear();
					}
				}

				if (!validationPassed) {
					self.renewVMOpsValidation = {
						message: message,
						type: 'error'
					};

					return false;
				}
			}

			if (!validationPassed) {
				return;
			}

			virtualMachineFactory
				.performVMOperation(
					self.vmOperationDetails.vmGUID,
					self.vmOperationDetails.vmName,
					self.vmOperationDetails.instanceId,
					self.vmOperationDetails.operationType,
					self.vmOperationDetails.vmLocation,
					self.vmOperationDetails.policyId,
					expiration
				)
				.then(function(data) {
					$state.forceReload();
				});
			virtualMachineFactory.closeModal();
		};
	}
]); // end controller(vmOperationDialogController)

/*
 * CvEntities.x -> VMAllocationPolicyType, Common.x -> VSVendor, TMMsg.x -> VMOperationType
 */
vmManagementMod.constant('VirtualMachineConstants', {
	VMAllocationPolicyType: {
		MICROSOFT: 'MICROSOFT',
		RHEV: 'RHEV',
		VMW_BACKUP_LABTEMPLATE: 'VMW_BACKUP_LABTEMPLATE',
		VMW_LIVEMOUNT: 'VMW_LIVEMOUNT',
		VMW_LABTEMPLATE: 'VMW_LABTEMPLATE',
		VMWARE: 'VMWARE',
		ORACLE_CLOUD_INFRASTRUCTURE: 'ORACLE_CLOUD_INFRASTRUCTURE',
		AZURE_STACK: 'AZURE_STACK'
	},
	VSVendor: {
		VMWARE: 'VMW',
		ORACLE_CLOUD_INFRASTRUCTURE: 'ORACLE_CLOUD_INFRASTRUCTURE'
	},
	VMOperationType: {
		NONE: 'NONE',
		DELETE_VM: 'DELETE_VM',
		RENEW_VM: 'RENEW_VM',
		POWER_ON: 'POWER_ON',
		POWER_OFF: 'POWER_OFF',
		SHUTDOWN_VM: 'SHUTDOWN_VM',
		RESTART_VM: 'RESTART_VM'
	},

	// Remove below when enum project is done for UI
	VSObjType: {
		0: 'NONE',
		1: 'SERVER',
		2: 'RES_POOL',
		3: 'VAPP',
		4: 'DATACENTER',
		5: 'FOLDER',
		6: 'CLUSTER',
		7: 'DATASTORE',
		8: 'DATASTORE_CLUSTER',
		9: 'VM',
		10: 'VMName',
		11: 'VMGuestOS',
		12: 'VMGuestHostName',
		13: 'ClusterSharedVolumes',
		14: 'LocalDisk',
		15: 'ClusterDisk',
		16: 'UnprotectedVMs',
		17: 'ROOT',
		18: 'FileServer',
		19: 'SMBShare',
		20: 'TypesFolder',
		21: 'VMFolder',
		22: 'ServerFolder',
		23: 'TemplateFolder',
		24: 'StorageRepositoryFolder',
		25: 'VAppFolder',
		26: 'DatacenterFolder',
		27: 'ClusterFolder',
		28: 'VMPowerState',
		29: 'VMNotes',
		30: 'VMCustomAttribute',
		31: 'Network',
		32: 'User',
		33: 'VMTemplate',
		34: 'Tag',
		35: 'TagCategory',
		36: 'Subclient',
		37: 'ClientGroup',
		38: 'ProtectionDomain',
		39: 'ConsistencyGroup',
		40: 'InstanceSize',
		41: 'Organization',
		42: 'Images',
		43: 'StoragePolicy',
		44: 'Database',
		45: 'Table',
		46: 'Project'
	},
	VmStatusEnum: {
		0: 'ALL',
		1: 'PROTECTED',
		2: 'NOT_PROTECTED',
		3: 'PENDING',
		4: 'BACKED_UP_WITH_ERROR',
		7: 'WARNING'
	},
	OSType: {
		0: 'CLIENT_PLATFORM_OSTYPE_UNKNOWN',
		1: 'CLIENT_PLATFORM_OSTYPE_WINDOWS',
		2: 'CLIENT_PLATFORM_OSTYPE_UNIX',
		3: 'CLIENT_PLATFORM_OSTYPE_NETWARE',
		4: 'CLIENT_PLATFORM_OSTYPE_NAS_FILER',
		5: 'CLIENT_PLATFORM_OSTYPE_DATA_ONTAP'
	},
	RetireClientPhase: {
		0: 'UNKNOWN',
		1: 'RETIRE_IN_PROGRESS',
		2: 'DECONFIGURED'
	}
});

export default vmManagementMod;
