import { vsaAppServerModule } from 'common/js/modules';
import 'vsa/js/directives/cv-display-name-azure-directive.js';
import 'modules/vmManagement/js/factory/vmLifeCyclePolicy/lifeCyclePolicy.factory.js';

var serverMod = vsaAppServerModule;

serverMod.constant('RESTORE_OPTIONS_MODE_REDHAT', {
	REPLICATION_TARGET: 'replicationTarget'
});

serverMod.directive('cvAdvanceOptions', function() {
	return {
		restrict: 'E', // E = element
		templateUrl: appUtil.appRoot + 'modules/vmManagement/partials/lifeCyclePolicy/advanceOptions.jsp',
		scope: {},
		bindToController: {
			vendor: '=',
			mode: '@',
			ctrl: '=',
			vmList: '=',
			sourceId: '=',
			editMode: '=',
			destinationHost: '=?',
			serverDetails: '=?',
			policyAppType: '='
		},
		controllerAs: 'advOptCtrl',
		controller: 'advanceOptionsController'
	};
});

var controllers = {};
controllers.advanceOptionsController = [
	'$scope',
	'$stateParams',
	'$log',
	'cvUtil',
	'RESTORE_OPTIONS_MODE_REDHAT',
	'vmLifeCyclePolicyFactory',
	'storageService',
	'cvLoc',
	'serverService',
	'cvTreeFactory',
	'vmLifeCylePolicyService',
	'vmFactory',
	'VM_POLICY_APP_TYPE',
	function(
		$scope,
		$stateParams,
		$log,
		cvUtil,
		RESTORE_OPTIONS_MODE_REDHAT,
		vmLifeCyclePolicyFactory,
		storageService,
		cvLoc,
		serverService,
		cvTreeFactory,
		vmLifeCylePolicyService,
		vmFactory,
		VM_POLICY_APP_TYPE
	) {
		var self = this;
		this.$onInit = function() {
			self.errors = {};
			$scope.localLang = cvUtil.getIStevenLocLabels();
			self.mediaAgentLists = [{ id: 0, displayName: 'Loading...', selected: true }];
			self.localLangGatewayNetwork = cvUtil.getIStevenLocLabels();
			self.localLangGatewayNetwork.nothingSelected = cvLoc('placeholder.selectCompartment');
			self.localLangGatewayTemplate = cvUtil.getIStevenLocLabels();
			self.localLangGatewayTemplate.nothingSelected = cvLoc('placeholder.selectCompartment');
			self.localLangExistingNetwork = cvUtil.getIStevenLocLabels();
			self.localLangExistingNetwork.nothingSelected = cvLoc('placeholder.selectCompartment');
			self.localLangMediaAgent = cvUtil.getIStevenLocLabels();
			self.localLangMediaAgent.nothingSelected = cvLoc('placeholder.fbrMAUnix');
			self.isRegularPolicy = self.policyAppType === VM_POLICY_APP_TYPE.REGULAR.type;

			if (!self.vmList.advanceOptions) {
				self.vmList.advanceOptions = {};
			}

			self.selectedIsoPathWindows = [];
			self.selectedIsoPathUnix = [];
			self.browseOptions = {
				isoInfo: {
					windows: null,
					unix: null
				}
			};

			self.initializeOptionValues = function() {
				self.model = {};

				if (self.editMode) {
					self.configureVirtualizeMeFlag = !!self.vmList.advanceOptions.configureVirtualizeMe;
				}
				if (self.vmList.advanceOptions.noOfCPUs) {
					self.model.noOfCPUs = self.vmList.advanceOptions.noOfCPUs;
				} else {
					self.model.noOfCPUs = 1;
					self.vmList.advanceOptions.noOfCPUs = self.model.noOfCPUs;
				}
				if (self.vmList.advanceOptions.maxMemory) {
					self.model.maxMemory = self.vmList.advanceOptions.maxMemory;
				} else {
					self.model.maxMemory = 1;
					self.vmList.advanceOptions.maxMemory = self.model.maxMemory;
					if (self.editMode) {
						self.maxmemoryToggle = 'enabled-activity';
						self.maxMemoryFlag = true;
						self.vmList.advanceOptions.maxMemoryToggle = true;
					}
				}
				if (self.vmList.advanceOptions.noOfVms) {
					self.model.noOfVms = self.vmList.advanceOptions.noOfVms;
				} else {
					self.model.noOfVms = 5;
					self.vmList.advanceOptions.noOfVms = self.model.noOfVms;
				}
				if (self.vmList.advanceOptions.minutesRetainUntil) {
					self.expirationTime = 'Hours';
					self.model.minutesRetainUntil = self.vmList.advanceOptions.minutesRetainUntil;
					self.vmList.advanceOptions.expirationTime = self.expirationTime;
				} else {
					self.model.minutesRetainUntil = 1;
					self.vmList.advanceOptions.minutesRetainUntil = self.model.minutesRetainUntil;
					self.expirationTime = 'Hours';
					self.vmList.advanceOptions.expirationTime = self.expirationTime;
				}
				if (self.vmList.advanceOptions.daysRetainUntil) {
					self.expirationTime = 'Days';
					self.model.daysRetainUntil = self.vmList.advanceOptions.daysRetainUntil;
					self.vmList.advanceOptions.expirationTime = self.expirationTime;
					if (self.vmList.advanceOptions.migrateVMs) {
						self.migrateVms = 'enabled-activity';
					}
				} else {
					self.model.daysRetainUntil = 1;
					self.vmList.advanceOptions.daysRetainUntil = self.model.daysRetainUntil;
				}
				if (self.vmList.advanceOptions.mediaAgent && self.vmList.advanceOptions.mediaAgent.clientName) {
					self.model.mediaAgent = self.vmList.advanceOptions.mediaAgent;
					self.model.mediaAgent.mediaAgentName = self.vmList.advanceOptions.mediaAgent.clientName;
					self.model.mediaAgent.mediaAgentId = self.vmList.advanceOptions.mediaAgent.clientId;
					self.vmList.advanceOptions.enableMediaAgent = true;
					self.vmList.advanceOptions.mediaAgent = [];
					self.vmList.advanceOptions.mediaAgent[0] = {
						displayName: self.model.mediaAgent.mediaAgentName,
						mediaAgentName: self.model.mediaAgent.mediaAgentName,
						mediaAgentId: self.model.mediaAgent.mediaAgentId
					};
				} else {
					self.model.mediaAgent = '';
				}
				self.model.enableVirtualLabs = true;
				//self.showOnlyDays = true; //Will open up later when dev test groups is enabled
			};

			self.initializeOptionValues();

			self.isVMware = function() {
				return vmLifeCyclePolicyFactory.isVMware(self.vendor);
			};

			self.isRedHat = function() {
				return vmLifeCyclePolicyFactory.isRedHat(self.vendor);
			};

			self.isHyperv = function() {
				return vmLifeCyclePolicyFactory.isHyperv(self.vendor);
			};

			/** Initialize data * */
			self.initialize = function() {
				self.replicationTargetMode = RESTORE_OPTIONS_MODE_REDHAT.REPLICATION_TARGET;
				if (self.mode === self.replicationTargetMode) {
					self.model.selectedVms = [];
					self.model.selectedVms.push(self.vmList);
					if (self.isVMware()) {
						self.existingNetworkSettingsList = [];
						self.gatewayNetworkSettingsList = [];
						if (self.editMode) {
							//&& self.vmList.advanceOptions.isLiveMountEnabled -- add this check back when liveMount option is made as optional
							self.showLiveMount = 'enabled-activity';
							self.showLiveMountFlag = true;
							self.vmList.advanceOptions.showLiveMount = true;
						} else if (!self.editMode) {
							//self.vmList.advanceOptions.showVirtualizeMe = false;
							self.showLiveMount = 'enabled-activity';
							self.showLiveMountFlag = true;
							self.showOnlyDays
								? (self.vmList.advanceOptions.showLiveMount = false)
								: (self.vmList.advanceOptions.showLiveMount = true);
							self.model.enableDecommission = false;
						}
					} else if (self.isRedHat() || self.vendor == 'MICROSOFT') {
						self.showLiveMount = 'enabled-activity';
						self.showLiveMountFlag = true;
						self.vmList.advanceOptions.showLiveMount = true;
					} else {
						self.showLiveMount = 'disabled-activity';
						self.vmList.advanceOptions.showLiveMount = false;
						self.showLiveMountFlag = false;
					}
				}
			};
			/** End of initilaize * */

			self.initialize();

			self.model.isCSApplianceVM = !!(
				cv &&
				cv.additionalSettings &&
				cv.additionalSettings.AdminConsole &&
				cv.additionalSettings.AdminConsole.isCSApplianceVM
			);

			self.isApplianceEnabledCS = function() {
				self.model.vendor = self.vendor;
				self.vmList.advanceOptions.isApplianceEnabledCS = vmLifeCyclePolicyFactory.isApplianceEnabledCS(self.model);
				return self.vmList.advanceOptions.isApplianceEnabledCS;
			};

			self.expirationTimeClick = function(source) {
				if (source === 'Hours') {
					self.vmList.advanceOptions.expirationTime = 'Hours';
					$('#expirationTimeInHours').focus();
					self.migrateVms = 'disabled-activity';
					self.vmList.advanceOptions.migrateVMs = self.migrateVms;
					self.expirationTime = source;
				} else if (source === 'Days') {
					self.expirationTime = source;
					self.vmList.advanceOptions.expirationTime = 'Days';
					$('#expirationTimeInDays').focus();
				} else if (source === 'expirationTimeInHours') {
					self.expirationTime = 'Hours';
					self.migrateVms = 'disabled-activity';
					self.vmList.advanceOptions.migrateVMs = self.migrateVms;
					self.vmList.advanceOptions.minutesRetainUntil = self.model.minutesRetainUntil;
					self.vmList.advanceOptions.expirationTime = self.expirationTime;
				} else if (source === 'expirationTimeInDays') {
					self.expirationTime = 'Days';
					self.vmList.advanceOptions.daysRetainUntil = self.model.daysRetainUntil;
					self.vmList.advanceOptions.expirationTime = self.expirationTime;
				}
			};

			/**
			 * mediaAgentDetails - get mediaAgent for the livemount 3dnfs server selection.*
			 */
			self.mediaAgentDetails = function() {
				storageService
					.getMediaAgentList('NONE')
					.success(function(data) {
						self.mediaAgentLists = [];
						self.mediaAgentLists.push({
							displayName: cvLoc('label.selectMediaAgent'),
							mediaAgentName: '',
							selected: false
						});

						if (!!data) {
							self.mediaAgentLists = self.mediaAgentLists.concat(cvUtil.sortAscending(data, 'displayName'));
						}
						var selectMediaAgent;
						if (self.model.mediaAgent && self.model.mediaAgent.mediaAgentName) {
							angular.forEach(self.mediaAgentLists, function(mediaAgent) {
								if (mediaAgent.mediaAgentName === self.model.mediaAgent.mediaAgentName) {
									selectMediaAgent = mediaAgent;
									self.enableMediaAgent = true;
									self.enableMediaAgentFlag = true;
									self.model.mediaAgent = mediaAgent;
									mediaAgent.selected = true;
									return;
								}
							});
						}

						if (!self.enableMediaAgent) {
							self.mediaAgentLists[0].selected = true;
						}
					})
					.error(function(data, status, headers, config) {
						self.serverMessage = cvUtil.errMsg(data);
						return false;
					});
			};

			var isValidGatewayTemplate = function(gateway, esxHosts) {};

			var filterTemplates = function() {
				var host = self.destinationHost;
				var esxHosts = [];
				esxHosts.push(vmFactory.getDestinationHostName(host));
				self.gatewayTemplateList = [];
				angular.forEach(self.templateList, function(template) {
					if (isValidGatewayTemplate(template, esxHosts)) {
						if (self.gatewayTemplate && self.gatewayTemplate.vmGUID === template.vmGUID) {
							self.gatewayTemplate = template;
						}
						self.gatewayTemplateList.push(template);
					}
				});

				if (!self.gatewayTemplate && self.gatewayTemplateList.length > 0) {
					self.gatewayTemplate = self.gatewayTemplateList[0];
				}
			};

			// loadVMwareTemplateDetails();

			/** toggle button management * */
			// live mount toggle activity
			self.manageLiveMountOptionsActivity = function() {
				self.showLiveMount = vmLifeCyclePolicyFactory.checkToggleStatus(self.showLiveMount);
				self.showLiveMount === 'enabled-activity' ? (self.showLiveMountFlag = true) : (self.showLiveMountFlag = false);
				self.vmList.advanceOptions.showLiveMount = self.showLiveMountFlag;
				if (!self.showLiveMountFlag) {
					self.enableMediaAgent = 'disabled-activity';
					self.vmList.advanceOptions.mediaAgent = false;
					self.migrateVms = 'disabled-activity';
				}
			};

			// media agent toggle activity
			self.manageEnableMAActivity = function() {
				self.enableMediaAgent = vmLifeCyclePolicyFactory.checkToggleStatus(self.enableMediaAgent);
				self.enableMediaAgent === 'enabled-activity'
					? (self.enableMediaAgentFlag = true)
					: (self.enableMediaAgentFlag = false);
				self.vmList.advanceOptions.enableMediaAgent = self.enableMediaAgentFlag;
				if (self.enableMediaAgentFlag) {
					if (!self.editMode) {
						self.mediaAgentLists[0].selected = true;
					}
					self.vmList.advanceOptions.mediaAgent = self.mediaAgentList;
				} else {
					self.vmList.advanceOptions.mediaAgent = [];
					for (var i = 0; i <= self.mediaAgentLists.length - 1; i++) {
						if (self.mediaAgentLists[i].selected) {
							self.mediaAgentLists[i].selected = false;
						}
					}
				}
			};

			self.manageExistingNtwrkActivity = function(selectionType) {
				self.configureExistingNetwork = vmLifeCyclePolicyFactory.checkToggleStatus(self.configureExistingNetwork);
				self.configureExistingNetwork === 'enabled-activity'
					? (self.configureExistingNetworkFlag = true)
					: (self.configureExistingNetworkFlag = false);
				self.vmList.advanceOptions.configureExistingNetwork = self.configureExistingNetworkFlag;
				self.virtualLabetworkChanged(selectionType);
			};

			self.managemigrateVmsActivity = function() {
				self.migrateVms = vmLifeCyclePolicyFactory.checkToggleStatus(self.migrateVms);
				self.migrateVms === 'enabled-activity' ? (self.migrateVmsFlag = true) : (self.migrateVmsFlag = false);
				self.vmList.advanceOptions.migrateVMs = self.migrateVmsFlag;
			};

			self.ctrl.manageVirtualizeMe = function(virtualizeMe) {
				self.configureVirtualizeMeFlag = virtualizeMe;
			};

			self.mediaAgentDetails();

			/**
			 * All these functions set the respective values selected to send it to the parent controller *
			 */

			self.noOfVMsChanged = function() {
				if (self.model.noOfVms === undefined || self.model.noOfVms === null) {
					self.invalidNoOfVMs = cvUtil.errMsg(cvLoc('error.invalidNoOfVMs'));
					return;
				}
				if (self.invalidNoOfVMs && self.invalidNoOfVMs.message) {
					self.invalidNoOfVMs = {};
				}
				self.vmList.advanceOptions.noOfVms = self.model.noOfVms;
			};

			self.expirationTimeChanged = function() {
				if (self.model.minutesRetainUntil === undefined || self.model.minutesRetainUntil === null) {
					self.invalidExpTime = cvUtil.errMsg(cvLoc('error.invalidExpirationTime'));
					return;
				}
				if (self.invalidExpTime && self.invalidExpTime.message) {
					self.invalidExpTime = {};
				}
				self.vmList.advanceOptions.minutesRetainUntil = self.model.minutesRetainUntil;
			};

			self.openBrowseDataStoresModal = function(destinationHosts, osType) {
				// load the root level data (data stores based on destination hosts)
				if (!destinationHosts || !destinationHosts.entity.name) {
					return;
				}

				var destinationServer = self.serverDetails;
				if (!destinationServer.name) {
					destinationServer.name = destinationServer.clientName;
				}
				var serverId = destinationServer.clientId;

				var cvTreeModalParams = {
					dialogTitle: cvLoc('label.isoPath'),
					treeRoot: {
						label: destinationHosts.entity.name,
						type: 'esxServer',
						iconClass: 'vsaIconSERVER'
					},
					selectedItems: osType === 'unix' ? self.selectedIsoPathUnix : self.selectedIsoPathWindows,
					selectableTypes: ['iso'],
					loadChildren: function(entity) {
						if (entity.type === 'esxServer') {
							var destinationHostname = entity.label;
							// Load data store list
							return serverService.getDataStores(serverId, destinationHostname, destinationServer, self.vendor);
						} else if (entity.type === 'datastore') {
							var dataStoreName = entity.label;
							var destinationHostname = entity.destinationHostname;
							return serverService.getIsoPaths(
								serverId,
								dataStoreName,
								destinationServer,
								self.vendor,
								destinationHostname
							);
						} else {
							// error.. type not supported
						}
					},
					processChildren: function(entity, data) {
						if (entity.type === 'esxServer') {
							if (data.data && data.data.length) {
								return data.data.map(function(ds) {
									return {
										label: ds.dataStoreName,
										destinationHostname: entity.label,
										type: 'datastore',
										iconClass: 'vsaIconDATASTORE'
									};
								});
							}
						} else if (entity.type === 'datastore') {
							if (
								data.data &&
								data.data.hostInfo &&
								data.data.hostInfo.length > 0 &&
								data.data.hostInfo[0].dataStore &&
								data.data.hostInfo[0].dataStore.length > 0 &&
								data.data.hostInfo[0].dataStore[0].filepath &&
								data.data.hostInfo[0].dataStore[0].filepath.length > 0
							) {
								return data.data.hostInfo[0].dataStore[0].filepath.map(function(filePath) {
									return {
										label: filePath,
										iconClass: 'vsaIconLocalDisk',
										isLeaf: true,
										type: 'iso'
									};
								});
							}
						}
					}
				};

				// Saving the value
				cvTreeFactory.openCvTreeWrapperModal(cvTreeModalParams).result.then(function(result) {
					if (!self.vmList.advanceOptions.browseOptions) {
						self.vmList.advanceOptions.browseOptions = { isoInfo: {} };
					}

					// ok clicked
					if (osType === 'unix') {
						// unix
						if (result.length) {
							self.browseOptions.isoInfo.unix = {
								isoPath: result[0].label,
								osType: 0
							};
							self.vmList.advanceOptions.browseOptions.isoInfo.unix = self.browseOptions.isoInfo.unix;
						} else {
							self.browseOptions.isoInfo.unix = null;
						}
					} else if (osType === 'windows') {
						// windows
						if (result.length) {
							self.browseOptions.isoInfo.windows = {
								isoPath: result[0].label,
								osType: 1
							};
							self.vmList.advanceOptions.browseOptions.isoInfo.windows = self.browseOptions.isoInfo.windows;
						} else {
							self.browseOptions.isoInfo.windows = null;
						}
					}
					self.vmList.advanceOptions.configureVirtualizeMe =
						!!self.browseOptions.isoInfo.windows || !!self.browseOptions.isoInfo.unix;
				});
			};

			self.mediaAgentListChanged = function() {
				self.vmList.advanceOptions.mediaAgent = self.mediaAgentList;
			};
			/** End of functions setting the value to the parent controller* */
			self.ctrl.validateNoOfVMs = function() {
				self.noNoOfVMsError = true;
				if (self.invalidNoOfVMs && self.invalidNoOfVMs.message) {
					self.noNoOfVMsError = false;
				}
				return self.noNoOfVMsError;
			};

			self.ctrl.validateExpirationTime = function() {
				self.noExpTimeError = true;
				if (self.invalidExpTime && self.invalidExpTime.message) {
					self.noExpTimeError = false;
				}
				return self.noExpTimeError;
			};
		};
	}
];

serverMod.controller(controllers);
export default serverMod;
